rule win_fengine_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.fengine."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.fengine"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33ff c6041000 898df4efffff 85c0 }
            // n = 4, score = 100
            //   33ff                 | xor                 edi, edi
            //   c6041000             | mov                 byte ptr [eax + edx], 0
            //   898df4efffff         | mov                 dword ptr [ebp - 0x100c], ecx
            //   85c0                 | test                eax, eax

        $sequence_1 = { 75e5 8d85b8feffff 50 ff15???????? }
            // n = 4, score = 100
            //   75e5                 | jne                 0xffffffe7
            //   8d85b8feffff         | lea                 eax, [ebp - 0x148]
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_2 = { e8???????? 83c408 85c0 750f c705????????02000000 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   85c0                 | test                eax, eax
            //   750f                 | jne                 0x11
            //   c705????????02000000     |     

        $sequence_3 = { 897e70 6a43 58 668986b8000000 668986be010000 c74668d0154100 6a0d }
            // n = 7, score = 100
            //   897e70               | mov                 dword ptr [esi + 0x70], edi
            //   6a43                 | push                0x43
            //   58                   | pop                 eax
            //   668986b8000000       | mov                 word ptr [esi + 0xb8], ax
            //   668986be010000       | mov                 word ptr [esi + 0x1be], ax
            //   c74668d0154100       | mov                 dword ptr [esi + 0x68], 0x4115d0
            //   6a0d                 | push                0xd

        $sequence_4 = { 8d55cc 8bce c745cc8b85d4fe c745d0ffff8b70 }
            // n = 4, score = 100
            //   8d55cc               | lea                 edx, [ebp - 0x34]
            //   8bce                 | mov                 ecx, esi
            //   c745cc8b85d4fe       | mov                 dword ptr [ebp - 0x34], 0xfed4858b
            //   c745d0ffff8b70       | mov                 dword ptr [ebp - 0x30], 0x708bffff

        $sequence_5 = { 53 8d4e04 6800080000 51 }
            // n = 4, score = 100
            //   53                   | push                ebx
            //   8d4e04               | lea                 ecx, [esi + 4]
            //   6800080000           | push                0x800
            //   51                   | push                ecx

        $sequence_6 = { e8???????? ebb4 c745e448294100 a1???????? eb1a c745e444294100 a1???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   ebb4                 | jmp                 0xffffffb6
            //   c745e448294100       | mov                 dword ptr [ebp - 0x1c], 0x412948
            //   a1????????           |                     
            //   eb1a                 | jmp                 0x1c
            //   c745e444294100       | mov                 dword ptr [ebp - 0x1c], 0x412944
            //   a1????????           |                     

        $sequence_7 = { c1e706 8b048560514100 83c00c 03c7 50 ff15???????? 33c0 }
            // n = 7, score = 100
            //   c1e706               | shl                 edi, 6
            //   8b048560514100       | mov                 eax, dword ptr [eax*4 + 0x415160]
            //   83c00c               | add                 eax, 0xc
            //   03c7                 | add                 eax, edi
            //   50                   | push                eax
            //   ff15????????         |                     
            //   33c0                 | xor                 eax, eax

        $sequence_8 = { 6a43 58 668986b8000000 668986be010000 c74668d0154100 }
            // n = 5, score = 100
            //   6a43                 | push                0x43
            //   58                   | pop                 eax
            //   668986b8000000       | mov                 word ptr [esi + 0xb8], ax
            //   668986be010000       | mov                 word ptr [esi + 0x1be], ax
            //   c74668d0154100       | mov                 dword ptr [esi + 0x68], 0x4115d0

        $sequence_9 = { 8b5e24 c1e003 50 03fa 03da e8???????? }
            // n = 6, score = 100
            //   8b5e24               | mov                 ebx, dword ptr [esi + 0x24]
            //   c1e003               | shl                 eax, 3
            //   50                   | push                eax
            //   03fa                 | add                 edi, edx
            //   03da                 | add                 ebx, edx
            //   e8????????           |                     

    condition:
        7 of them and filesize < 210944
}