rule win_finfisher_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.finfisher."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.finfisher"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 56 8d85ccf9ffff 50 e8???????? }
            // n = 4, score = 200
            //   56                   | push                esi
            //   8d85ccf9ffff         | lea                 eax, [ebp - 0x634]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_1 = { 68???????? 6804010000 8d85ccf9ffff 50 }
            // n = 4, score = 200
            //   68????????           |                     
            //   6804010000           | push                0x104
            //   8d85ccf9ffff         | lea                 eax, [ebp - 0x634]
            //   50                   | push                eax

        $sequence_2 = { 8d84860c010000 3938 740a 8b00 51 }
            // n = 5, score = 100
            //   8d84860c010000       | lea                 eax, [esi + eax*4 + 0x10c]
            //   3938                 | cmp                 dword ptr [eax], edi
            //   740a                 | je                  0xc
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   51                   | push                ecx

        $sequence_3 = { 8365fc00 ff36 a1???????? ff5004 }
            // n = 4, score = 100
            //   8365fc00             | and                 dword ptr [ebp - 4], 0
            //   ff36                 | push                dword ptr [esi]
            //   a1????????           |                     
            //   ff5004               | call                dword ptr [eax + 4]

        $sequence_4 = { c78584f7ffff40020000 8d8570f7ffff 898580f7ffff 89b588f7ffff 89b58cf7ffff }
            // n = 5, score = 100
            //   c78584f7ffff40020000     | mov    dword ptr [ebp - 0x87c], 0x240
            //   8d8570f7ffff         | lea                 eax, [ebp - 0x890]
            //   898580f7ffff         | mov                 dword ptr [ebp - 0x880], eax
            //   89b588f7ffff         | mov                 dword ptr [ebp - 0x878], esi
            //   89b58cf7ffff         | mov                 dword ptr [ebp - 0x874], esi

        $sequence_5 = { 8bd8 ffb5acf7ffff 3bde 0f856dffffff ff15???????? }
            // n = 5, score = 100
            //   8bd8                 | mov                 ebx, eax
            //   ffb5acf7ffff         | push                dword ptr [ebp - 0x854]
            //   3bde                 | cmp                 ebx, esi
            //   0f856dffffff         | jne                 0xffffff73
            //   ff15????????         |                     

        $sequence_6 = { ff4510 394510 72ea eb06 8b4510 }
            // n = 5, score = 100
            //   ff4510               | inc                 dword ptr [ebp + 0x10]
            //   394510               | cmp                 dword ptr [ebp + 0x10], eax
            //   72ea                 | jb                  0xffffffec
            //   eb06                 | jmp                 8
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]

        $sequence_7 = { e8???????? 83c424 8b8db0f7ffff 8b4160 8985b4f7ffff 81780c00202200 0f8536050000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c424               | add                 esp, 0x24
            //   8b8db0f7ffff         | mov                 ecx, dword ptr [ebp - 0x850]
            //   8b4160               | mov                 eax, dword ptr [ecx + 0x60]
            //   8985b4f7ffff         | mov                 dword ptr [ebp - 0x84c], eax
            //   81780c00202200       | cmp                 dword ptr [eax + 0xc], 0x222000
            //   0f8536050000         | jne                 0x53c

        $sequence_8 = { 85c0 0f8538020000 6a04 8bbd48f9ffff 8d4708 }
            // n = 5, score = 100
            //   85c0                 | test                eax, eax
            //   0f8538020000         | jne                 0x23e
            //   6a04                 | push                4
            //   8bbd48f9ffff         | mov                 edi, dword ptr [ebp - 0x6b8]
            //   8d4708               | lea                 eax, [edi + 8]

        $sequence_9 = { 750a bb9a0000c0 e9???????? 8bd0 8b8dc0f7ffff ff15???????? }
            // n = 6, score = 100
            //   750a                 | jne                 0xc
            //   bb9a0000c0           | mov                 ebx, 0xc000009a
            //   e9????????           |                     
            //   8bd0                 | mov                 edx, eax
            //   8b8dc0f7ffff         | mov                 ecx, dword ptr [ebp - 0x840]
            //   ff15????????         |                     

        $sequence_10 = { ff15???????? 8b8db0f7ffff 895918 8b85a0f7ffff 89411c 32d2 }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   8b8db0f7ffff         | mov                 ecx, dword ptr [ebp - 0x850]
            //   895918               | mov                 dword ptr [ecx + 0x18], ebx
            //   8b85a0f7ffff         | mov                 eax, dword ptr [ebp - 0x860]
            //   89411c               | mov                 dword ptr [ecx + 0x1c], eax
            //   32d2                 | xor                 dl, dl

        $sequence_11 = { 8b3f 85ff 75a7 ff45f8 837df825 7293 be010000c0 }
            // n = 7, score = 100
            //   8b3f                 | mov                 edi, dword ptr [edi]
            //   85ff                 | test                edi, edi
            //   75a7                 | jne                 0xffffffa9
            //   ff45f8               | inc                 dword ptr [ebp - 8]
            //   837df825             | cmp                 dword ptr [ebp - 8], 0x25
            //   7293                 | jb                  0xffffff95
            //   be010000c0           | mov                 esi, 0xc0000001

        $sequence_12 = { ff75fc ff750c ff15???????? 3bc6 }
            // n = 4, score = 100
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   ff15????????         |                     
            //   3bc6                 | cmp                 eax, esi

        $sequence_13 = { 50 e8???????? 83c41c c745fc04000000 6850020000 }
            // n = 5, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c41c               | add                 esp, 0x1c
            //   c745fc04000000       | mov                 dword ptr [ebp - 4], 4
            //   6850020000           | push                0x250

    condition:
        7 of them and filesize < 262144
}