rule win_fireball_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.fireball."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.fireball"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 57 c785b8f6ffff40000000 ff15???????? 85c0 7410 8d45a8 }
            // n = 6, score = 100
            //   57                   | push                edi
            //   c785b8f6ffff40000000     | mov    dword ptr [ebp - 0x948], 0x40
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7410                 | je                  0x12
            //   8d45a8               | lea                 eax, [ebp - 0x58]

        $sequence_1 = { 83e61f c1e606 033485000a2500 837e0800 }
            // n = 4, score = 100
            //   83e61f               | and                 esi, 0x1f
            //   c1e606               | shl                 esi, 6
            //   033485000a2500       | add                 esi, dword ptr [eax*4 + 0x250a00]
            //   837e0800             | cmp                 dword ptr [esi + 8], 0

        $sequence_2 = { 8d8d04f7ffff e8???????? 8d8dd4f6ffff e8???????? 8d8d88f6ffff e8???????? }
            // n = 6, score = 100
            //   8d8d04f7ffff         | lea                 ecx, [ebp - 0x8fc]
            //   e8????????           |                     
            //   8d8dd4f6ffff         | lea                 ecx, [ebp - 0x92c]
            //   e8????????           |                     
            //   8d8d88f6ffff         | lea                 ecx, [ebp - 0x978]
            //   e8????????           |                     

        $sequence_3 = { e9???????? 8d8d38f5ffff e9???????? 8d8da0f6ffff e9???????? 8d8d80f5ffff e9???????? }
            // n = 7, score = 100
            //   e9????????           |                     
            //   8d8d38f5ffff         | lea                 ecx, [ebp - 0xac8]
            //   e9????????           |                     
            //   8d8da0f6ffff         | lea                 ecx, [ebp - 0x960]
            //   e9????????           |                     
            //   8d8d80f5ffff         | lea                 ecx, [ebp - 0xa80]
            //   e9????????           |                     

        $sequence_4 = { 83c404 8b4c2470 64890d00000000 59 5e }
            // n = 5, score = 100
            //   83c404               | add                 esp, 4
            //   8b4c2470             | mov                 ecx, dword ptr [esp + 0x70]
            //   64890d00000000       | mov                 dword ptr fs:[0], ecx
            //   59                   | pop                 ecx
            //   5e                   | pop                 esi

        $sequence_5 = { 0f4275e8 85f6 0f8598000000 33c0 85c0 7514 }
            // n = 6, score = 100
            //   0f4275e8             | cmovb               esi, dword ptr [ebp - 0x18]
            //   85f6                 | test                esi, esi
            //   0f8598000000         | jne                 0x9e
            //   33c0                 | xor                 eax, eax
            //   85c0                 | test                eax, eax
            //   7514                 | jne                 0x16

        $sequence_6 = { e8???????? 59 59 8b7d08 833cfda8f5240000 755b 6a18 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   833cfda8f5240000     | cmp                 dword ptr [edi*8 + 0x24f5a8], 0
            //   755b                 | jne                 0x5d
            //   6a18                 | push                0x18

        $sequence_7 = { 51 6af6 ff15???????? 8b04bd000a2500 }
            // n = 4, score = 100
            //   51                   | push                ecx
            //   6af6                 | push                -0xa
            //   ff15????????         |                     
            //   8b04bd000a2500       | mov                 eax, dword ptr [edi*4 + 0x250a00]

        $sequence_8 = { 59 8365fc00 8b049d000a2500 f644380401 7413 ff7510 ff750c }
            // n = 7, score = 100
            //   59                   | pop                 ecx
            //   8365fc00             | and                 dword ptr [ebp - 4], 0
            //   8b049d000a2500       | mov                 eax, dword ptr [ebx*4 + 0x250a00]
            //   f644380401           | test                byte ptr [eax + edi + 4], 1
            //   7413                 | je                  0x15
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   ff750c               | push                dword ptr [ebp + 0xc]

        $sequence_9 = { 0f94c0 5d c3 56 33f6 ffb6c8f62400 }
            // n = 6, score = 100
            //   0f94c0               | sete                al
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   56                   | push                esi
            //   33f6                 | xor                 esi, esi
            //   ffb6c8f62400         | push                dword ptr [esi + 0x24f6c8]

    condition:
        7 of them and filesize < 335872
}