rule win_flash_develop_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.flash_develop."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.flash_develop"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 55 56 33c9 57 0fb68170034200 99 8bf0 }
            // n = 7, score = 100
            //   55                   | push                ebp
            //   56                   | push                esi
            //   33c9                 | xor                 ecx, ecx
            //   57                   | push                edi
            //   0fb68170034200       | movzx               eax, byte ptr [ecx + 0x420370]
            //   99                   | cdq                 
            //   8bf0                 | mov                 esi, eax

        $sequence_1 = { 33fa 0fa4f708 c1e608 8934cd40484800 99 }
            // n = 5, score = 100
            //   33fa                 | xor                 edi, edx
            //   0fa4f708             | shld                edi, esi, 8
            //   c1e608               | shl                 esi, 8
            //   8934cd40484800       | mov                 dword ptr [ecx*8 + 0x484840], esi
            //   99                   | cdq                 

        $sequence_2 = { c78424c8020000e0b04600 c78424cc02000068df4600 c78424d0020000b40d4700 c78424d4020000503e4700 c78424d8020000446e4700 c78424dc0200000c9d4700 c78424e0020000b0cc4700 }
            // n = 7, score = 100
            //   c78424c8020000e0b04600     | mov    dword ptr [esp + 0x2c8], 0x46b0e0
            //   c78424cc02000068df4600     | mov    dword ptr [esp + 0x2cc], 0x46df68
            //   c78424d0020000b40d4700     | mov    dword ptr [esp + 0x2d0], 0x470db4
            //   c78424d4020000503e4700     | mov    dword ptr [esp + 0x2d4], 0x473e50
            //   c78424d8020000446e4700     | mov    dword ptr [esp + 0x2d8], 0x476e44
            //   c78424dc0200000c9d4700     | mov    dword ptr [esp + 0x2dc], 0x479d0c
            //   c78424e0020000b0cc4700     | mov    dword ptr [esp + 0x2e0], 0x47ccb0

        $sequence_3 = { 891ccd28184800 892ccd2c184800 0fa4f710 c1e610 33f0 33fa 0fa4f708 }
            // n = 7, score = 100
            //   891ccd28184800       | mov                 dword ptr [ecx*8 + 0x481828], ebx
            //   892ccd2c184800       | mov                 dword ptr [ecx*8 + 0x48182c], ebp
            //   0fa4f710             | shld                edi, esi, 0x10
            //   c1e610               | shl                 esi, 0x10
            //   33f0                 | xor                 esi, eax
            //   33fa                 | xor                 edi, edx
            //   0fa4f708             | shld                edi, esi, 8

        $sequence_4 = { 33fa c1e308 892ccd2c204800 8bef 0fa4f708 891ccd28204800 8bde }
            // n = 7, score = 100
            //   33fa                 | xor                 edi, edx
            //   c1e308               | shl                 ebx, 8
            //   892ccd2c204800       | mov                 dword ptr [ecx*8 + 0x48202c], ebp
            //   8bef                 | mov                 ebp, edi
            //   0fa4f708             | shld                edi, esi, 8
            //   891ccd28204800       | mov                 dword ptr [ecx*8 + 0x482028], ebx
            //   8bde                 | mov                 ebx, esi

        $sequence_5 = { 893ccd44484800 8bf0 8bfa 0fa4f708 }
            // n = 4, score = 100
            //   893ccd44484800       | mov                 dword ptr [ecx*8 + 0x484844], edi
            //   8bf0                 | mov                 esi, eax
            //   8bfa                 | mov                 edi, edx
            //   0fa4f708             | shld                edi, esi, 8

        $sequence_6 = { 892ccd34204800 8bef 0fa4f708 33fa 891ccd30204800 8bde c1e608 }
            // n = 7, score = 100
            //   892ccd34204800       | mov                 dword ptr [ecx*8 + 0x482034], ebp
            //   8bef                 | mov                 ebp, edi
            //   0fa4f708             | shld                edi, esi, 8
            //   33fa                 | xor                 edi, edx
            //   891ccd30204800       | mov                 dword ptr [ecx*8 + 0x482030], ebx
            //   8bde                 | mov                 ebx, esi
            //   c1e608               | shl                 esi, 8

        $sequence_7 = { c7842464010000240a4200 c7842468010000043a4200 c784246c01000070694200 c7842470010000cc9a4200 }
            // n = 4, score = 100
            //   c7842464010000240a4200     | mov    dword ptr [esp + 0x164], 0x420a24
            //   c7842468010000043a4200     | mov    dword ptr [esp + 0x168], 0x423a04
            //   c784246c01000070694200     | mov    dword ptr [esp + 0x16c], 0x426970
            //   c7842470010000cc9a4200     | mov    dword ptr [esp + 0x170], 0x429acc

        $sequence_8 = { 0fb68170054200 33ea 0fa4dd10 33fa 99 8934cd28304800 }
            // n = 6, score = 100
            //   0fb68170054200       | movzx               eax, byte ptr [ecx + 0x420570]
            //   33ea                 | xor                 ebp, edx
            //   0fa4dd10             | shld                ebp, ebx, 0x10
            //   33fa                 | xor                 edi, edx
            //   99                   | cdq                 
            //   8934cd28304800       | mov                 dword ptr [ecx*8 + 0x483028], esi

        $sequence_9 = { 893ccd44404800 83c104 81f900010000 0f8c39f8ffff 5f 5e 5d }
            // n = 7, score = 100
            //   893ccd44404800       | mov                 dword ptr [ecx*8 + 0x484044], edi
            //   83c104               | add                 ecx, 4
            //   81f900010000         | cmp                 ecx, 0x100
            //   0f8c39f8ffff         | jl                  0xfffff83f
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp

    condition:
        7 of them and filesize < 1111040
}