rule win_ghostemperor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.ghostemperor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ghostemperor"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7406 8b442424 eb0d c7442424ffffffff }
            // n = 4, score = 200
            //   7406                 | je                  0x1a
            //   8b442424             | dec                 eax
            //   eb0d                 | mov                 dword ptr [edi + 0x10], 0
            //   c7442424ffffffff     | jmp                 0xb

        $sequence_1 = { 4183f802 743b 8a4802 41304902 }
            // n = 4, score = 200
            //   4183f802             | je                  0x75
            //   743b                 | mov                 edx, dword ptr [esi + 0x4c]
            //   8a4802               | movups              xmm0, xmmword ptr [edx + edi*8]
            //   41304902             | movups              xmm1, xmmword ptr [edx + edi*8 + 0x10]

        $sequence_2 = { 0f1004fa 0f104cfa10 0f1014f9 0f57d0 0f1044f910 }
            // n = 5, score = 200
            //   0f1004fa             | xor                 edx, edx
            //   0f104cfa10           | dec                 eax
            //   0f1014f9             | mov                 dword ptr [edi + 0x10], 0
            //   0f57d0               | jmp                 0xb
            //   0f1044f910           | mov                 dword ptr [edi + 0x18], 0

        $sequence_3 = { 31d2 41b801000000 4531c9 ff15???????? }
            // n = 4, score = 200
            //   31d2                 | dec                 eax
            //   41b801000000         | inc                 eax
            //   4531c9               | inc                 bp
            //   ff15????????         |                     

        $sequence_4 = { 488d5108 e8???????? 8b4648 85c0 746e 8b564c }
            // n = 6, score = 200
            //   488d5108             | add                 eax, dword ptr [esi + 0x4c]
            //   e8????????           |                     
            //   8b4648               | dec                 ecx
            //   85c0                 | shl                 eax, 3
            //   746e                 | dec                 eax
            //   8b564c               | mov                 ecx, eax

        $sequence_5 = { 4c8b5c2408 4883c410 c3 ff25???????? ff25???????? ff25???????? ff25???????? }
            // n = 7, score = 200
            //   4c8b5c2408           | dec                 esp
            //   4883c410             | mov                 ebx, dword ptr [esp + 8]
            //   c3                   | dec                 eax
            //   ff25????????         |                     
            //   ff25????????         |                     
            //   ff25????????         |                     
            //   ff25????????         |                     

        $sequence_6 = { e8???????? 48c7471000000000 eb09 c7471800000000 }
            // n = 4, score = 200
            //   e8????????           |                     
            //   48c7471000000000     | inc                 esp
            //   eb09                 | mov                 eax, dword ptr [esi + 0x50]
            //   c7471800000000       | inc                 esp

        $sequence_7 = { 44894648 49c1e003 488d5108 e8???????? }
            // n = 4, score = 200
            //   44894648             | movups              xmm2, xmmword ptr [ecx + edi*8]
            //   49c1e003             | xorps               xmm2, xmm0
            //   488d5108             | movups              xmm0, xmmword ptr [ecx + edi*8 + 0x10]
            //   e8????????           |                     

        $sequence_8 = { 4889c3 448b4650 4403464c 49c1e003 4889c1 31d2 e8???????? }
            // n = 7, score = 200
            //   4889c3               | ret                 
            //   448b4650             | dec                 eax
            //   4403464c             | add                 esp, 0x10
            //   49c1e003             | ret                 
            //   4889c1               | dec                 eax
            //   31d2                 | mov                 ebx, eax
            //   e8????????           |                     

        $sequence_9 = { 66448974247c 448874247e 4885c0 0f84d8010000 c744242037008900 c74424246300ec00 }
            // n = 6, score = 100
            //   66448974247c         | mov                 cl, byte ptr [eax + 2]
            //   448874247e           | inc                 ecx
            //   4885c0               | xor                 byte ptr [ecx + 2], cl
            //   0f84d8010000         | inc                 esp
            //   c744242037008900     | mov                 dword ptr [esi + 0x48], eax
            //   c74424246300ec00     | dec                 ecx

        $sequence_10 = { 33d2 c745979b00a000 c7459b81009200 33db c7459ff600a600 }
            // n = 5, score = 100
            //   33d2                 | mov                 dword ptr [esp + 0x60], 0x5a0064
            //   c745979b00a000       | mov                 dword ptr [esp + 0x64], 0x5a0058
            //   c7459b81009200       | movups              xmm0, xmmword ptr [esp + 0x58]
            //   33db                 | mov                 dword ptr [esp + 0x68], 0xa9002a
            //   c7459ff600a600       | mov                 ecx, 2

        $sequence_11 = { 48ffc0 664539644602 75f5 483bd8 }
            // n = 4, score = 100
            //   48ffc0               | test                eax, eax
            //   664539644602         | je                  0x1e6
            //   75f5                 | mov                 dword ptr [esp + 0x20], 0x890037
            //   483bd8               | mov                 dword ptr [esp + 0x24], 0xec0063

        $sequence_12 = { 488d4c2420 488d7d72 ff5008 488d4d72 }
            // n = 4, score = 100
            //   488d4c2420           | mov                 dword ptr [esp + 0x7c], esi
            //   488d7d72             | inc                 esp
            //   ff5008               | mov                 byte ptr [esp + 0x7e], dh
            //   488d4d72             | dec                 eax

        $sequence_13 = { 01c1 89ca c1ea1f c1f904 }
            // n = 4, score = 100
            //   01c1                 | mov                 edx, dword ptr [ebp + 0x2b0]
            //   89ca                 | mov                 byte ptr [eax + edx + 0xc], cl
            //   c1ea1f               | dec                 eax
            //   c1f904               | mov                 ecx, dword ptr [ebp + 0x2b0]

        $sequence_14 = { 00c2 488b8568020000 8854080c 488b85b0020000 }
            // n = 4, score = 100
            //   00c2                 | dec                 eax
            //   488b8568020000       | add                 esp, 0x10
            //   8854080c             | ret                 
            //   488b85b0020000       | dec                 eax

        $sequence_15 = { c744246064005a00 c744246458005a00 0f10442458 c74424682a00a900 }
            // n = 4, score = 100
            //   c744246064005a00     | shl                 eax, 3
            //   c744246458005a00     | dec                 eax
            //   0f10442458           | lea                 edx, [ecx + 8]
            //   c74424682a00a900     | je                  8

        $sequence_16 = { 00c1 488b8568020000 488b95b0020000 884c100c 488b85b0020000 488b85b0020000 488b85b0020000 }
            // n = 7, score = 100
            //   00c1                 | cmp                 dword ptr [esi + eax*2 + 2], esp
            //   488b8568020000       | jne                 0xfffffff7
            //   488b95b0020000       | dec                 eax
            //   884c100c             | cmp                 ebx, eax
            //   488b85b0020000       | xor                 edx, edx
            //   488b85b0020000       | mov                 dword ptr [ebp - 0x69], 0xa0009b
            //   488b85b0020000       | mov                 dword ptr [ebp - 0x65], 0x920081

        $sequence_17 = { 4881ecf0010000 488d05ed1e0000 4533ff 488d4c2420 4889442420 }
            // n = 5, score = 100
            //   4881ecf0010000       | cmp                 eax, ecx
            //   488d05ed1e0000       | jne                 0x2e4
            //   4533ff               | dec                 ecx
            //   488d4c2420           | mov                 edi, dword ptr [edi + 0x18]
            //   4889442420           | movups              xmmword ptr [ebp - 0x40], xmm0

        $sequence_18 = { 0f1145c0 c7442458b4000500 c744245cb800a900 c7442460fb00b500 c74424641500fe00 }
            // n = 5, score = 100
            //   0f1145c0             | ret                 
            //   c7442458b4000500     | inc                 esp
            //   c744245cb800a900     | mov                 esi, edx
            //   c7442460fb00b500     | and                 esi, 3
            //   c74424641500fe00     | inc                 sp

        $sequence_19 = { 01c3 69cbe8030000 81c130750000 4883ec20 }
            // n = 4, score = 100
            //   01c3                 | mov                 eax, dword ptr [ebp + 0x2b0]
            //   69cbe8030000         | add                 dl, al
            //   81c130750000         | dec                 eax
            //   4883ec20             | mov                 eax, dword ptr [ebp + 0x268]

        $sequence_20 = { e9???????? b902000000 3bc1 0f85dc020000 498b7f18 }
            // n = 5, score = 100
            //   e9????????           |                     
            //   b902000000           | mov                 eax, dword ptr [esp + 0x24]
            //   3bc1                 | jmp                 0x13
            //   0f85dc020000         | mov                 dword ptr [esp + 0x24], 0xffffffff
            //   498b7f18             | pop                 esi

        $sequence_21 = { 01d1 89ca c1e205 89cb }
            // n = 4, score = 100
            //   01d1                 | dec                 eax
            //   89ca                 | mov                 eax, dword ptr [ebp + 0x2b0]
            //   c1e205               | mov                 eax, dword ptr [ebp + 0x2c8]
            //   89cb                 | add                 dl, al

        $sequence_22 = { 052797fa04 351337a665 8945f4 488b4510 }
            // n = 4, score = 100
            //   052797fa04           | add                 ecx, eax
            //   351337a665           | mov                 edx, ecx
            //   8945f4               | shr                 edx, 0x1f
            //   488b4510             | sar                 ecx, 4

    condition:
        7 of them and filesize < 1115136
}