rule win_glupteba_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.glupteba."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.glupteba"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 ff15???????? 8d45d4 50 e8???????? 50 8d45d4 }
            // n = 7, score = 400
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8d45d4               | lea                 eax, [ebp - 0x2c]
            //   50                   | push                eax
            //   e8????????           |                     
            //   50                   | push                eax
            //   8d45d4               | lea                 eax, [ebp - 0x2c]

        $sequence_1 = { 0fb6c8 8bc1 c1e804 0bc1 40 d1f8 }
            // n = 6, score = 400
            //   0fb6c8               | movzx               ecx, al
            //   8bc1                 | mov                 eax, ecx
            //   c1e804               | shr                 eax, 4
            //   0bc1                 | or                  eax, ecx
            //   40                   | inc                 eax
            //   d1f8                 | sar                 eax, 1

        $sequence_2 = { 83c0fc 33c9 85c0 7e0e 813c310d0a0d0a 7409 }
            // n = 6, score = 400
            //   83c0fc               | add                 eax, -4
            //   33c9                 | xor                 ecx, ecx
            //   85c0                 | test                eax, eax
            //   7e0e                 | jle                 0x10
            //   813c310d0a0d0a       | cmp                 dword ptr [ecx + esi], 0xa0d0a0d
            //   7409                 | je                  0xb

        $sequence_3 = { ff15???????? ff75ee ff15???????? 830bff ff45fc 8b45fc }
            // n = 6, score = 400
            //   ff15????????         |                     
            //   ff75ee               | push                dword ptr [ebp - 0x12]
            //   ff15????????         |                     
            //   830bff               | or                  dword ptr [ebx], 0xffffffff
            //   ff45fc               | inc                 dword ptr [ebp - 4]
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]

        $sequence_4 = { 50 68???????? e8???????? 83c420 e8???????? 5f 5e }
            // n = 7, score = 400
            //   50                   | push                eax
            //   68????????           |                     
            //   e8????????           |                     
            //   83c420               | add                 esp, 0x20
            //   e8????????           |                     
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_5 = { eb02 8a03 8807 47 }
            // n = 4, score = 400
            //   eb02                 | jmp                 4
            //   8a03                 | mov                 al, byte ptr [ebx]
            //   8807                 | mov                 byte ptr [edi], al
            //   47                   | inc                 edi

        $sequence_6 = { 0bca 8b55fc c1ea07 c1e109 8d1c3f 0bd3 }
            // n = 6, score = 400
            //   0bca                 | or                  ecx, edx
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   c1ea07               | shr                 edx, 7
            //   c1e109               | shl                 ecx, 9
            //   8d1c3f               | lea                 ebx, [edi + edi]
            //   0bd3                 | or                  edx, ebx

        $sequence_7 = { c1eb08 33f3 8b5dfc 33df }
            // n = 4, score = 400
            //   c1eb08               | shr                 ebx, 8
            //   33f3                 | xor                 esi, ebx
            //   8b5dfc               | mov                 ebx, dword ptr [ebp - 4]
            //   33df                 | xor                 ebx, edi

        $sequence_8 = { 0106 830702 392e 75a0 }
            // n = 4, score = 100
            //   0106                 | add                 dword ptr [esi], eax
            //   830702               | add                 dword ptr [edi], 2
            //   392e                 | cmp                 dword ptr [esi], ebp
            //   75a0                 | jne                 0xffffffa2

        $sequence_9 = { 00cd 3e46 005e3e 46 }
            // n = 4, score = 100
            //   00cd                 | add                 ch, cl
            //   3e46                 | inc                 esi
            //   005e3e               | add                 byte ptr [esi + 0x3e], bl
            //   46                   | inc                 esi

        $sequence_10 = { 0012 3f 46 008bff558bec }
            // n = 4, score = 100
            //   0012                 | add                 byte ptr [edx], dl
            //   3f                   | aas                 
            //   46                   | inc                 esi
            //   008bff558bec         | add                 byte ptr [ebx - 0x1374aa01], cl

        $sequence_11 = { 0107 eb4d 8b02 89442418 }
            // n = 4, score = 100
            //   0107                 | add                 dword ptr [edi], eax
            //   eb4d                 | jmp                 0x4f
            //   8b02                 | mov                 eax, dword ptr [edx]
            //   89442418             | mov                 dword ptr [esp + 0x18], eax

        $sequence_12 = { 005e3e 46 00ff 3e46 }
            // n = 4, score = 100
            //   005e3e               | add                 byte ptr [esi + 0x3e], bl
            //   46                   | inc                 esi
            //   00ff                 | add                 bh, bh
            //   3e46                 | inc                 esi

        $sequence_13 = { 00ff 3e46 0012 3f }
            // n = 4, score = 100
            //   00ff                 | add                 bh, bh
            //   3e46                 | inc                 esi
            //   0012                 | add                 byte ptr [edx], dl
            //   3f                   | aas                 

        $sequence_14 = { 0101 03d3 8b4620 8bcb }
            // n = 4, score = 100
            //   0101                 | add                 dword ptr [ecx], eax
            //   03d3                 | add                 edx, ebx
            //   8b4620               | mov                 eax, dword ptr [esi + 0x20]
            //   8bcb                 | mov                 ecx, ebx

        $sequence_15 = { 00f1 3d46005e3e 46 00cd }
            // n = 4, score = 100
            //   00f1                 | add                 cl, dh
            //   3d46005e3e           | cmp                 eax, 0x3e5e0046
            //   46                   | inc                 esi
            //   00cd                 | add                 ch, cl

    condition:
        7 of them and filesize < 1417216
}