rule win_gpcode_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.gpcode."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.gpcode"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff35???????? ff35???????? e8???????? a1???????? a3???????? 6800001000 }
            // n = 6, score = 1400
            //   ff35????????         |                     
            //   ff35????????         |                     
            //   e8????????           |                     
            //   a1????????           |                     
            //   a3????????           |                     
            //   6800001000           | push                0x100000

        $sequence_1 = { c3 ff35???????? e8???????? e8???????? c705????????01000000 c3 55 }
            // n = 7, score = 1400
            //   c3                   | ret                 
            //   ff35????????         |                     
            //   e8????????           |                     
            //   e8????????           |                     
            //   c705????????01000000     |     
            //   c3                   | ret                 
            //   55                   | push                ebp

        $sequence_2 = { 68???????? e8???????? 91 6a00 }
            // n = 4, score = 1400
            //   68????????           |                     
            //   e8????????           |                     
            //   91                   | xchg                eax, ecx
            //   6a00                 | push                0

        $sequence_3 = { a1???????? a3???????? 6800001000 68???????? ff35???????? 6a00 }
            // n = 6, score = 1400
            //   a1????????           |                     
            //   a3????????           |                     
            //   6800001000           | push                0x100000
            //   68????????           |                     
            //   ff35????????         |                     
            //   6a00                 | push                0

        $sequence_4 = { 68f4010000 e8???????? 833d????????01 75ed e8???????? }
            // n = 5, score = 1200
            //   68f4010000           | push                0x1f4
            //   e8????????           |                     
            //   833d????????01       |                     
            //   75ed                 | jne                 0xffffffef
            //   e8????????           |                     

        $sequence_5 = { 53 a1???????? 6bc008 50 6a40 e8???????? 85c0 }
            // n = 7, score = 1100
            //   53                   | push                ebx
            //   a1????????           |                     
            //   6bc008               | imul                eax, eax, 8
            //   50                   | push                eax
            //   6a40                 | push                0x40
            //   e8????????           |                     
            //   85c0                 | test                eax, eax

        $sequence_6 = { f7f1 8bc8 bb???????? 51 6a41 53 }
            // n = 6, score = 1100
            //   f7f1                 | div                 ecx
            //   8bc8                 | mov                 ecx, eax
            //   bb????????           |                     
            //   51                   | push                ecx
            //   6a41                 | push                0x41
            //   53                   | push                ebx

        $sequence_7 = { e8???????? 03df eb0a c705????????00000000 8b0b }
            // n = 5, score = 1100
            //   e8????????           |                     
            //   03df                 | add                 ebx, edi
            //   eb0a                 | jmp                 0xc
            //   c705????????00000000     |     
            //   8b0b                 | mov                 ecx, dword ptr [ebx]

        $sequence_8 = { 53 8d4508 ff30 e8???????? 8bc8 8d5d08 }
            // n = 6, score = 1100
            //   53                   | push                ebx
            //   8d4508               | lea                 eax, [ebp + 8]
            //   ff30                 | push                dword ptr [eax]
            //   e8????????           |                     
            //   8bc8                 | mov                 ecx, eax
            //   8d5d08               | lea                 ebx, [ebp + 8]

        $sequence_9 = { ff75fc ff75ec e8???????? ff75f8 e8???????? 8b5dec 6a10 }
            // n = 7, score = 800
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   ff75ec               | push                dword ptr [ebp - 0x14]
            //   e8????????           |                     
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   e8????????           |                     
            //   8b5dec               | mov                 ebx, dword ptr [ebp - 0x14]
            //   6a10                 | push                0x10

        $sequence_10 = { 83c4ec 6800050000 68???????? 6a00 e8???????? 6a0a 68???????? }
            // n = 7, score = 800
            //   83c4ec               | add                 esp, -0x14
            //   6800050000           | push                0x500
            //   68????????           |                     
            //   6a00                 | push                0
            //   e8????????           |                     
            //   6a0a                 | push                0xa
            //   68????????           |                     

        $sequence_11 = { 2d???????? 50 8d85e8feffff 50 68???????? e8???????? }
            // n = 6, score = 800
            //   2d????????           |                     
            //   50                   | push                eax
            //   8d85e8feffff         | lea                 eax, [ebp - 0x118]
            //   50                   | push                eax
            //   68????????           |                     
            //   e8????????           |                     

        $sequence_12 = { 0005???????? 0fb605???????? 8ad3 8d80b8fee014 }
            // n = 4, score = 100
            //   0005????????         |                     
            //   0fb605????????       |                     
            //   8ad3                 | mov                 dl, bl
            //   8d80b8fee014         | lea                 eax, [eax + 0x14e0feb8]

        $sequence_13 = { 0106 eb94 55 8bec }
            // n = 4, score = 100
            //   0106                 | add                 dword ptr [esi], eax
            //   eb94                 | jmp                 0xffffff96
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp

        $sequence_14 = { 0016 40 3bc3 72de }
            // n = 4, score = 100
            //   0016                 | add                 byte ptr [esi], dl
            //   40                   | inc                 eax
            //   3bc3                 | cmp                 eax, ebx
            //   72de                 | jb                  0xffffffe0

        $sequence_15 = { 000c38 40 3b45f8 72e3 }
            // n = 4, score = 100
            //   000c38               | add                 byte ptr [eax + edi], cl
            //   40                   | inc                 eax
            //   3b45f8               | cmp                 eax, dword ptr [ebp - 8]
            //   72e3                 | jb                  0xffffffe5

        $sequence_16 = { 000e eb08 02c9 b2f9 }
            // n = 4, score = 100
            //   000e                 | add                 byte ptr [esi], cl
            //   eb08                 | jmp                 0xa
            //   02c9                 | add                 cl, cl
            //   b2f9                 | mov                 dl, 0xf9

        $sequence_17 = { 011c07 ebc3 91 668b01 }
            // n = 4, score = 100
            //   011c07               | add                 dword ptr [edi + eax], ebx
            //   ebc3                 | jmp                 0xffffffc5
            //   91                   | xchg                eax, ecx
            //   668b01               | mov                 ax, word ptr [ecx]

        $sequence_18 = { 001438 eb06 80c107 000c38 }
            // n = 4, score = 100
            //   001438               | add                 byte ptr [eax + edi], dl
            //   eb06                 | jmp                 8
            //   80c107               | add                 cl, 7
            //   000c38               | add                 byte ptr [eax + edi], cl

        $sequence_19 = { 0144240c 85f6 7fdd 33c0 }
            // n = 4, score = 100
            //   0144240c             | add                 dword ptr [esp + 0xc], eax
            //   85f6                 | test                esi, esi
            //   7fdd                 | jg                  0xffffffdf
            //   33c0                 | xor                 eax, eax

    condition:
        7 of them and filesize < 761856
}