rule win_graphican_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.graphican."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.graphican"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 57 894e08 8b15???????? 8d4610 53 50 89560c }
            // n = 7, score = 200
            //   57                   | push                edi
            //   894e08               | mov                 dword ptr [esi + 8], ecx
            //   8b15????????         |                     
            //   8d4610               | lea                 eax, [esi + 0x10]
            //   53                   | push                ebx
            //   50                   | push                eax
            //   89560c               | mov                 dword ptr [esi + 0xc], edx

        $sequence_1 = { b860200000 e8???????? a1???????? 33c5 8945fc 8b4508 }
            // n = 6, score = 200
            //   b860200000           | mov                 eax, 0x2060
            //   e8????????           |                     
            //   a1????????           |                     
            //   33c5                 | xor                 eax, ebp
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_2 = { 57 52 50 e8???????? 83c40c 8bc7 }
            // n = 6, score = 200
            //   57                   | push                edi
            //   52                   | push                edx
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8bc7                 | mov                 eax, edi

        $sequence_3 = { 750e 8b07 8b4808 ffd1 33c0 e9???????? 8b17 }
            // n = 7, score = 200
            //   750e                 | jne                 0x10
            //   8b07                 | mov                 eax, dword ptr [edi]
            //   8b4808               | mov                 ecx, dword ptr [eax + 8]
            //   ffd1                 | call                ecx
            //   33c0                 | xor                 eax, eax
            //   e9????????           |                     
            //   8b17                 | mov                 edx, dword ptr [edi]

        $sequence_4 = { 8d46e7 5e 8915???????? 5b e8???????? }
            // n = 5, score = 200
            //   8d46e7               | lea                 eax, [esi - 0x19]
            //   5e                   | pop                 esi
            //   8915????????         |                     
            //   5b                   | pop                 ebx
            //   e8????????           |                     

        $sequence_5 = { 8b450c 50 56 51 e8???????? }
            // n = 5, score = 200
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   50                   | push                eax
            //   56                   | push                esi
            //   51                   | push                ecx
            //   e8????????           |                     

        $sequence_6 = { 50 68???????? 6a00 e8???????? 8bc8 83c418 }
            // n = 6, score = 200
            //   50                   | push                eax
            //   68????????           |                     
            //   6a00                 | push                0
            //   e8????????           |                     
            //   8bc8                 | mov                 ecx, eax
            //   83c418               | add                 esp, 0x18

        $sequence_7 = { ffd1 83bde8efffff10 0f82f8000000 8b8dd4efffff }
            // n = 4, score = 200
            //   ffd1                 | call                ecx
            //   83bde8efffff10       | cmp                 dword ptr [ebp - 0x1018], 0x10
            //   0f82f8000000         | jb                  0xfe
            //   8b8dd4efffff         | mov                 ecx, dword ptr [ebp - 0x102c]

        $sequence_8 = { 51 50 ffd2 8bb5c4efffff 33ff 899dd0efffff 899dc8efffff }
            // n = 7, score = 200
            //   51                   | push                ecx
            //   50                   | push                eax
            //   ffd2                 | call                edx
            //   8bb5c4efffff         | mov                 esi, dword ptr [ebp - 0x103c]
            //   33ff                 | xor                 edi, edi
            //   899dd0efffff         | mov                 dword ptr [ebp - 0x1030], ebx
            //   899dc8efffff         | mov                 dword ptr [ebp - 0x1038], ebx

        $sequence_9 = { ddd8 897dc0 8b450c 8b55c4 8938 895004 }
            // n = 6, score = 200
            //   ddd8                 | fstp                st(0)
            //   897dc0               | mov                 dword ptr [ebp - 0x40], edi
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8b55c4               | mov                 edx, dword ptr [ebp - 0x3c]
            //   8938                 | mov                 dword ptr [eax], edi
            //   895004               | mov                 dword ptr [eax + 4], edx

    condition:
        7 of them and filesize < 362496
}