rule win_green_dispenser_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.green_dispenser."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.green_dispenser"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c60084 c6043884 03c7 03c7 b901000000 c60084 c6043884 }
            // n = 7, score = 100
            //   c60084               | mov                 byte ptr [eax], 0x84
            //   c6043884             | mov                 byte ptr [eax + edi], 0x84
            //   03c7                 | add                 eax, edi
            //   03c7                 | add                 eax, edi
            //   b901000000           | mov                 ecx, 1
            //   c60084               | mov                 byte ptr [eax], 0x84
            //   c6043884             | mov                 byte ptr [eax + edi], 0x84

        $sequence_1 = { 51 8bd7 8bc8 e8???????? 83c404 85c0 0f8503020000 }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   8bd7                 | mov                 edx, edi
            //   8bc8                 | mov                 ecx, eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   85c0                 | test                eax, eax
            //   0f8503020000         | jne                 0x209

        $sequence_2 = { c745fc00000000 897dc0 c745c400000000 e8???????? 8bcb e8???????? 6a01 }
            // n = 7, score = 100
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   897dc0               | mov                 dword ptr [ebp - 0x40], edi
            //   c745c400000000       | mov                 dword ptr [ebp - 0x3c], 0
            //   e8????????           |                     
            //   8bcb                 | mov                 ecx, ebx
            //   e8????????           |                     
            //   6a01                 | push                1

        $sequence_3 = { 53 8b5d14 56 8b7508 57 8b7d0c 81ff81000000 }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   8b5d14               | mov                 ebx, dword ptr [ebp + 0x14]
            //   56                   | push                esi
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   57                   | push                edi
            //   8b7d0c               | mov                 edi, dword ptr [ebp + 0xc]
            //   81ff81000000         | cmp                 edi, 0x81

        $sequence_4 = { c785d0fcffff0f000000 c785ccfcffff00000000 c685bcfcffff00 83bd64fdffff10 720e ffb550fdffff }
            // n = 6, score = 100
            //   c785d0fcffff0f000000     | mov    dword ptr [ebp - 0x330], 0xf
            //   c785ccfcffff00000000     | mov    dword ptr [ebp - 0x334], 0
            //   c685bcfcffff00       | mov                 byte ptr [ebp - 0x344], 0
            //   83bd64fdffff10       | cmp                 dword ptr [ebp - 0x29c], 0x10
            //   720e                 | jb                  0x10
            //   ffb550fdffff         | push                dword ptr [ebp - 0x2b0]

        $sequence_5 = { 51 53 8d048a 56 8b34c510e54200 57 8b3cc514e54200 }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   53                   | push                ebx
            //   8d048a               | lea                 eax, [edx + ecx*4]
            //   56                   | push                esi
            //   8b34c510e54200       | mov                 esi, dword ptr [eax*8 + 0x42e510]
            //   57                   | push                edi
            //   8b3cc514e54200       | mov                 edi, dword ptr [eax*8 + 0x42e514]

        $sequence_6 = { 8b049d50aa4500 8064302480 837d0800 5f 5e 5b 7507 }
            // n = 7, score = 100
            //   8b049d50aa4500       | mov                 eax, dword ptr [ebx*4 + 0x45aa50]
            //   8064302480           | and                 byte ptr [eax + esi + 0x24], 0x80
            //   837d0800             | cmp                 dword ptr [ebp + 8], 0
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   7507                 | jne                 9

        $sequence_7 = { 8bce e8???????? 8bf0 8b45fc ff7004 e8???????? ff75fc }
            // n = 7, score = 100
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   ff7004               | push                dword ptr [eax + 4]
            //   e8????????           |                     
            //   ff75fc               | push                dword ptr [ebp - 4]

        $sequence_8 = { e8???????? 8b45f8 83c40c 03fb 03f0 ff4df4 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   83c40c               | add                 esp, 0xc
            //   03fb                 | add                 edi, ebx
            //   03f0                 | add                 esi, eax
            //   ff4df4               | dec                 dword ptr [ebp - 0xc]

        $sequence_9 = { 894c240c 84c0 7404 660f57c4 8b7c2414 c644242025 }
            // n = 6, score = 100
            //   894c240c             | mov                 dword ptr [esp + 0xc], ecx
            //   84c0                 | test                al, al
            //   7404                 | je                  6
            //   660f57c4             | xorpd               xmm0, xmm4
            //   8b7c2414             | mov                 edi, dword ptr [esp + 0x14]
            //   c644242025           | mov                 byte ptr [esp + 0x20], 0x25

    condition:
        7 of them and filesize < 838656
}