rule win_grok_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.grok."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.grok"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b4dfc 8b55fc 03513c 8955ec 8b45ec 8b4850 }
            // n = 6, score = 400
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   03513c               | add                 edx, dword ptr [ecx + 0x3c]
            //   8955ec               | mov                 dword ptr [ebp - 0x14], edx
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   8b4850               | mov                 ecx, dword ptr [eax + 0x50]

        $sequence_1 = { 8b5110 8955d8 eb09 8b45fc 8b4808 }
            // n = 5, score = 400
            //   8b5110               | mov                 edx, dword ptr [ecx + 0x10]
            //   8955d8               | mov                 dword ptr [ebp - 0x28], edx
            //   eb09                 | jmp                 0xb
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b4808               | mov                 ecx, dword ptr [eax + 8]

        $sequence_2 = { bf44646b20 57 6a24 50 8b35???????? ffd6 }
            // n = 6, score = 400
            //   bf44646b20           | mov                 edi, 0x206b6444
            //   57                   | push                edi
            //   6a24                 | push                0x24
            //   50                   | push                eax
            //   8b35????????         |                     
            //   ffd6                 | call                esi

        $sequence_3 = { 895df8 0f84c2000000 8b7508 3bf3 0f84b7000000 8b7d10 3bfb }
            // n = 7, score = 400
            //   895df8               | mov                 dword ptr [ebp - 8], ebx
            //   0f84c2000000         | je                  0xc8
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   3bf3                 | cmp                 esi, ebx
            //   0f84b7000000         | je                  0xbd
            //   8b7d10               | mov                 edi, dword ptr [ebp + 0x10]
            //   3bfb                 | cmp                 edi, ebx

        $sequence_4 = { 3998dc010000 74a2 68???????? 8d45dc }
            // n = 4, score = 400
            //   3998dc010000         | cmp                 dword ptr [eax + 0x1dc], ebx
            //   74a2                 | je                  0xffffffa4
            //   68????????           |                     
            //   8d45dc               | lea                 eax, [ebp - 0x24]

        $sequence_5 = { 7313 8b4dfc 8b148d98940100 3b550c 7502 }
            // n = 5, score = 400
            //   7313                 | jae                 0x15
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   8b148d98940100       | mov                 edx, dword ptr [ecx*4 + 0x19498]
            //   3b550c               | cmp                 edx, dword ptr [ebp + 0xc]
            //   7502                 | jne                 4

        $sequence_6 = { e8???????? eb1d 83fe08 720c ff7004 }
            // n = 5, score = 400
            //   e8????????           |                     
            //   eb1d                 | jmp                 0x1f
            //   83fe08               | cmp                 esi, 8
            //   720c                 | jb                  0xe
            //   ff7004               | push                dword ptr [eax + 4]

        $sequence_7 = { e8???????? 8945ec 58 e8???????? 8945e8 837de800 750b }
            // n = 7, score = 400
            //   e8????????           |                     
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   58                   | pop                 eax
            //   e8????????           |                     
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   837de800             | cmp                 dword ptr [ebp - 0x18], 0
            //   750b                 | jne                 0xd

        $sequence_8 = { c685acfeffff63 c685adfeffff6b c685aefeffff50 c685affeffff61 c685b0feffff67 c685b1feffff65 c685b2feffff73 }
            // n = 7, score = 400
            //   c685acfeffff63       | mov                 byte ptr [ebp - 0x154], 0x63
            //   c685adfeffff6b       | mov                 byte ptr [ebp - 0x153], 0x6b
            //   c685aefeffff50       | mov                 byte ptr [ebp - 0x152], 0x50
            //   c685affeffff61       | mov                 byte ptr [ebp - 0x151], 0x61
            //   c685b0feffff67       | mov                 byte ptr [ebp - 0x150], 0x67
            //   c685b1feffff65       | mov                 byte ptr [ebp - 0x14f], 0x65
            //   c685b2feffff73       | mov                 byte ptr [ebp - 0x14e], 0x73

        $sequence_9 = { 53 ff30 ffd6 893d???????? 33c0 5e 5f }
            // n = 7, score = 400
            //   53                   | push                ebx
            //   ff30                 | push                dword ptr [eax]
            //   ffd6                 | call                esi
            //   893d????????         |                     
            //   33c0                 | xor                 eax, eax
            //   5e                   | pop                 esi
            //   5f                   | pop                 edi

    condition:
        7 of them and filesize < 84992
}