rule win_ground_peony_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.ground_peony."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ground_peony"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4883c308 488d0544f60000 483bd8 75d8 }
            // n = 4, score = 100
            //   4883c308             | inc                 esp
            //   488d0544f60000       | mov                 byte ptr [esp + 0x70], dh
            //   483bd8               | jmp                 0x46
            //   75d8                 | dec                 eax

        $sequence_1 = { e9???????? 488d0518d00000 4a8b04e8 42f644f83840 7405 803f1a 741f }
            // n = 7, score = 100
            //   e9????????           |                     
            //   488d0518d00000       | xor                 edx, eax
            //   4a8b04e8             | dec                 ebx
            //   42f644f83840         | xchg                dword ptr [esi + edi*8 + 0x16b50], edx
            //   7405                 | jmp                 0x28e
            //   803f1a               | mov                 eax, dword ptr [ecx]
            //   741f                 | inc                 edx

        $sequence_2 = { 3b1d???????? 736b 488bc3 488bf3 48c1fe06 4c8d2d36d30000 83e03f }
            // n = 7, score = 100
            //   3b1d????????         |                     
            //   736b                 | cmp                 ecx, dword ptr [edx]
            //   488bc3               | inc                 ecx
            //   488bf3               | mov                 edx, edx
            //   48c1fe06             | dec                 ebp
            //   4c8d2d36d30000       | test                eax, eax
            //   83e03f               | jle                 0x2c0

        $sequence_3 = { 4883ec20 488bf9 4c8d0d74970000 b904000000 4c8d0560970000 488d1561970000 e8???????? }
            // n = 7, score = 100
            //   4883ec20             | cmp                 ecx, 4
            //   488bf9               | dec                 eax
            //   4c8d0d74970000       | sub                 esi, edi
            //   b904000000           | dec                 eax
            //   4c8d0560970000       | lea                 ebx, [0xffff719f]
            //   488d1561970000       | mov                 al, byte ptr [esi + edi]
            //   e8????????           |                     

        $sequence_4 = { 57 4156 4881ec30090000 488b05???????? 4833c4 4889842420090000 }
            // n = 6, score = 100
            //   57                   | lea                 eax, [esp + 0x50]
            //   4156                 | dec                 eax
            //   4881ec30090000       | cmp                 eax, -2
            //   488b05????????       |                     
            //   4833c4               | jne                 0x21e
            //   4889842420090000     | dec                 eax

        $sequence_5 = { ff15???????? 488bc7 488b8c2450010000 4833cc e8???????? 488b9c2470010000 4881c460010000 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   488bc7               | lea                 ecx, [0x9d3]
            //   488b8c2450010000     | mov                 ecx, eax
            //   4833cc               | test                eax, eax
            //   e8????????           |                     
            //   488b9c2470010000     | dec                 eax
            //   4881c460010000       | lea                 ecx, [0x12cfd]

        $sequence_6 = { 4883c428 c3 488d15878e0000 488d0d808d0000 }
            // n = 4, score = 100
            //   4883c428             | mov                 dword ptr [esp + 0x20], ebx
            //   c3                   | dec                 eax
            //   488d15878e0000       | mov                 ecx, dword ptr [esp + 0x50]
            //   488d0d808d0000       | inc                 ebp

        $sequence_7 = { 488be9 4c8d0503710000 488d1504710000 b914000000 e8???????? }
            // n = 5, score = 100
            //   488be9               | inc                 esp
            //   4c8d0503710000       | mov                 esi, ecx
            //   488d1504710000       | dec                 ebp
            //   b914000000           | mov                 esp, ecx
            //   e8????????           |                     

        $sequence_8 = { 4053 4883ec20 33db 488d15e1350100 4533c0 }
            // n = 5, score = 100
            //   4053                 | dec                 esp
            //   4883ec20             | lea                 ecx, [0x9739]
            //   33db                 | mov                 ecx, 5
            //   488d15e1350100       | dec                 esp
            //   4533c0               | lea                 eax, [0x9725]

        $sequence_9 = { 488b5c2430 4883c420 5f c3 48897c2408 488d3da0f60000 }
            // n = 6, score = 100
            //   488b5c2430           | dec                 eax
            //   4883c420             | arpl                bx, ax
            //   5f                   | dec                 eax
            //   c3                   | lea                 edx, [edx + eax*4]
            //   48897c2408           | mov                 eax, dword ptr [edx]
            //   488d3da0f60000       | inc                 ecx

    condition:
        7 of them and filesize < 217088
}