rule win_hellokitty_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.hellokitty."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.hellokitty"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b45c8 0bf1 3345dc 33de 2345d0 33fa 3345c8 }
            // n = 7, score = 100
            //   8b45c8               | mov                 eax, dword ptr [ebp - 0x38]
            //   0bf1                 | or                  esi, ecx
            //   3345dc               | xor                 eax, dword ptr [ebp - 0x24]
            //   33de                 | xor                 ebx, esi
            //   2345d0               | and                 eax, dword ptr [ebp - 0x30]
            //   33fa                 | xor                 edi, edx
            //   3345c8               | xor                 eax, dword ptr [ebp - 0x38]

        $sequence_1 = { 66d3e0 0fb7c0 0bf0 8875fe 84f6 0f856effffff }
            // n = 6, score = 100
            //   66d3e0               | shl                 ax, cl
            //   0fb7c0               | movzx               eax, ax
            //   0bf0                 | or                  esi, eax
            //   8875fe               | mov                 byte ptr [ebp - 2], dh
            //   84f6                 | test                dh, dh
            //   0f856effffff         | jne                 0xffffff74

        $sequence_2 = { 8bcb c1c90b 33c8 8975c4 8bc3 89b560ffffff }
            // n = 6, score = 100
            //   8bcb                 | mov                 ecx, ebx
            //   c1c90b               | ror                 ecx, 0xb
            //   33c8                 | xor                 ecx, eax
            //   8975c4               | mov                 dword ptr [ebp - 0x3c], esi
            //   8bc3                 | mov                 eax, ebx
            //   89b560ffffff         | mov                 dword ptr [ebp - 0xa0], esi

        $sequence_3 = { 03f3 8b5df4 33d0 8bc1 03de c1c802 33d0 }
            // n = 7, score = 100
            //   03f3                 | add                 esi, ebx
            //   8b5df4               | mov                 ebx, dword ptr [ebp - 0xc]
            //   33d0                 | xor                 edx, eax
            //   8bc1                 | mov                 eax, ecx
            //   03de                 | add                 ebx, esi
            //   c1c802               | ror                 eax, 2
            //   33d0                 | xor                 edx, eax

        $sequence_4 = { c1c802 33d0 8b75b8 8bc1 03da c1c807 8bd1 }
            // n = 7, score = 100
            //   c1c802               | ror                 eax, 2
            //   33d0                 | xor                 edx, eax
            //   8b75b8               | mov                 esi, dword ptr [ebp - 0x48]
            //   8bc1                 | mov                 eax, ecx
            //   03da                 | add                 ebx, edx
            //   c1c807               | ror                 eax, 7
            //   8bd1                 | mov                 edx, ecx

        $sequence_5 = { 894df8 894de0 8955f4 0fb688303b4200 8b45e8 c1e818 0fb680303b4200 }
            // n = 7, score = 100
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   894de0               | mov                 dword ptr [ebp - 0x20], ecx
            //   8955f4               | mov                 dword ptr [ebp - 0xc], edx
            //   0fb688303b4200       | movzx               ecx, byte ptr [eax + 0x423b30]
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   c1e818               | shr                 eax, 0x18
            //   0fb680303b4200       | movzx               eax, byte ptr [eax + 0x423b30]

        $sequence_6 = { 50 56 8d4dd8 e8???????? 8b5de0 8b75dc }
            // n = 6, score = 100
            //   50                   | push                eax
            //   56                   | push                esi
            //   8d4dd8               | lea                 ecx, [ebp - 0x28]
            //   e8????????           |                     
            //   8b5de0               | mov                 ebx, dword ptr [ebp - 0x20]
            //   8b75dc               | mov                 esi, dword ptr [ebp - 0x24]

        $sequence_7 = { 8988a4000000 0fb6c9 0fb699303b4200 0fb688a7000000 c1e308 0fb689303b4200 33d9 }
            // n = 7, score = 100
            //   8988a4000000         | mov                 dword ptr [eax + 0xa4], ecx
            //   0fb6c9               | movzx               ecx, cl
            //   0fb699303b4200       | movzx               ebx, byte ptr [ecx + 0x423b30]
            //   0fb688a7000000       | movzx               ecx, byte ptr [eax + 0xa7]
            //   c1e308               | shl                 ebx, 8
            //   0fb689303b4200       | movzx               ecx, byte ptr [ecx + 0x423b30]
            //   33d9                 | xor                 ebx, ecx

        $sequence_8 = { ffd3 68???????? 8945e4 ffd3 8b55f8 8d75f0 56 }
            // n = 7, score = 100
            //   ffd3                 | call                ebx
            //   68????????           |                     
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   ffd3                 | call                ebx
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   8d75f0               | lea                 esi, [ebp - 0x10]
            //   56                   | push                esi

        $sequence_9 = { 33d2 6689544802 eb11 6a28 c645fc00 ff75fc }
            // n = 6, score = 100
            //   33d2                 | xor                 edx, edx
            //   6689544802           | mov                 word ptr [eax + ecx*2 + 2], dx
            //   eb11                 | jmp                 0x13
            //   6a28                 | push                0x28
            //   c645fc00             | mov                 byte ptr [ebp - 4], 0
            //   ff75fc               | push                dword ptr [ebp - 4]

    condition:
        7 of them and filesize < 319488
}