rule win_hesperbot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.hesperbot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.hesperbot"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33742438 33c7 23742430 8b7c2444 337c243c 33742440 237c2434 }
            // n = 7, score = 500
            //   33742438             | xor                 esi, dword ptr [esp + 0x38]
            //   33c7                 | xor                 eax, edi
            //   23742430             | and                 esi, dword ptr [esp + 0x30]
            //   8b7c2444             | mov                 edi, dword ptr [esp + 0x44]
            //   337c243c             | xor                 edi, dword ptr [esp + 0x3c]
            //   33742440             | xor                 esi, dword ptr [esp + 0x40]
            //   237c2434             | and                 edi, dword ptr [esp + 0x34]

        $sequence_1 = { 5e c9 c3 8b4a3c 33c0 8d8c1188000000 394104 }
            // n = 7, score = 500
            //   5e                   | pop                 esi
            //   c9                   | leave               
            //   c3                   | ret                 
            //   8b4a3c               | mov                 ecx, dword ptr [edx + 0x3c]
            //   33c0                 | xor                 eax, eax
            //   8d8c1188000000       | lea                 ecx, [ecx + edx + 0x88]
            //   394104               | cmp                 dword ptr [ecx + 4], eax

        $sequence_2 = { ff7608 6a00 e8???????? 83c410 8b36 3bf7 75e1 }
            // n = 7, score = 500
            //   ff7608               | push                dword ptr [esi + 8]
            //   6a00                 | push                0
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   8b36                 | mov                 esi, dword ptr [esi]
            //   3bf7                 | cmp                 esi, edi
            //   75e1                 | jne                 0xffffffe3

        $sequence_3 = { 8d7306 8d7b04 8903 e8???????? 85c0 7506 668907 }
            // n = 7, score = 500
            //   8d7306               | lea                 esi, [ebx + 6]
            //   8d7b04               | lea                 edi, [ebx + 4]
            //   8903                 | mov                 dword ptr [ebx], eax
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7506                 | jne                 8
            //   668907               | mov                 word ptr [edi], ax

        $sequence_4 = { e8???????? 53 8945fc e8???????? 83c414 5b 8b45fc }
            // n = 7, score = 500
            //   e8????????           |                     
            //   53                   | push                ebx
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   5b                   | pop                 ebx
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]

        $sequence_5 = { 56 8bb42404030000 8d442414 33c9 57 2bf0 8d440c18 }
            // n = 7, score = 500
            //   56                   | push                esi
            //   8bb42404030000       | mov                 esi, dword ptr [esp + 0x304]
            //   8d442414             | lea                 eax, [esp + 0x14]
            //   33c9                 | xor                 ecx, ecx
            //   57                   | push                edi
            //   2bf0                 | sub                 esi, eax
            //   8d440c18             | lea                 eax, [esp + ecx + 0x18]

        $sequence_6 = { 56 ff7514 33c0 50 6a01 8d4d10 51 }
            // n = 7, score = 500
            //   56                   | push                esi
            //   ff7514               | push                dword ptr [ebp + 0x14]
            //   33c0                 | xor                 eax, eax
            //   50                   | push                eax
            //   6a01                 | push                1
            //   8d4d10               | lea                 ecx, [ebp + 0x10]
            //   51                   | push                ecx

        $sequence_7 = { 8d45f8 99 52 50 8b4510 99 52 }
            // n = 7, score = 500
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   99                   | cdq                 
            //   52                   | push                edx
            //   50                   | push                eax
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   99                   | cdq                 
            //   52                   | push                edx

        $sequence_8 = { 8974242c 8b742448 8bde 8bef 0fa4dd17 8bc7 c1e317 }
            // n = 7, score = 500
            //   8974242c             | mov                 dword ptr [esp + 0x2c], esi
            //   8b742448             | mov                 esi, dword ptr [esp + 0x48]
            //   8bde                 | mov                 ebx, esi
            //   8bef                 | mov                 ebp, edi
            //   0fa4dd17             | shld                ebp, ebx, 0x17
            //   8bc7                 | mov                 eax, edi
            //   c1e317               | shl                 ebx, 0x17

        $sequence_9 = { 8902 894104 5f 33c0 40 5e c3 }
            // n = 7, score = 500
            //   8902                 | mov                 dword ptr [edx], eax
            //   894104               | mov                 dword ptr [ecx + 4], eax
            //   5f                   | pop                 edi
            //   33c0                 | xor                 eax, eax
            //   40                   | inc                 eax
            //   5e                   | pop                 esi
            //   c3                   | ret                 

    condition:
        7 of them and filesize < 188416
}