rule win_heyoka_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.heyoka."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.heyoka"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b550c 52 8b4508 50 e8???????? 83c40c 8985ecfbffff }
            // n = 7, score = 100
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   52                   | push                edx
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8985ecfbffff         | mov                 dword ptr [ebp - 0x414], eax

        $sequence_1 = { 52 8d85dcfdffff 50 e8???????? 83c404 8d8c05ddfdffff 51 }
            // n = 7, score = 100
            //   52                   | push                edx
            //   8d85dcfdffff         | lea                 eax, [ebp - 0x224]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8d8c05ddfdffff       | lea                 ecx, [ebp + eax - 0x223]
            //   51                   | push                ecx

        $sequence_2 = { 83c408 68???????? 8d85fcfbffff 50 e8???????? 83c408 6a0a }
            // n = 7, score = 100
            //   83c408               | add                 esp, 8
            //   68????????           |                     
            //   8d85fcfbffff         | lea                 eax, [ebp - 0x404]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   6a0a                 | push                0xa

        $sequence_3 = { 6a00 8d8dd0feffff 51 8b95dcfeffff 52 }
            // n = 5, score = 100
            //   6a00                 | push                0
            //   8d8dd0feffff         | lea                 ecx, [ebp - 0x130]
            //   51                   | push                ecx
            //   8b95dcfeffff         | mov                 edx, dword ptr [ebp - 0x124]
            //   52                   | push                edx

        $sequence_4 = { 6a0a 8d8df0f7ffff 51 8b5510 52 e8???????? }
            // n = 6, score = 100
            //   6a0a                 | push                0xa
            //   8d8df0f7ffff         | lea                 ecx, [ebp - 0x810]
            //   51                   | push                ecx
            //   8b5510               | mov                 edx, dword ptr [ebp + 0x10]
            //   52                   | push                edx
            //   e8????????           |                     

        $sequence_5 = { 8bec 83ec18 c745f8ffffffff c745fc01000000 6a00 }
            // n = 5, score = 100
            //   8bec                 | mov                 ebp, esp
            //   83ec18               | sub                 esp, 0x18
            //   c745f8ffffffff       | mov                 dword ptr [ebp - 8], 0xffffffff
            //   c745fc01000000       | mov                 dword ptr [ebp - 4], 1
            //   6a00                 | push                0

        $sequence_6 = { e8???????? 83c40c 8b9590d7feff 52 8b8584d7feff 50 8b8d8cd7feff }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8b9590d7feff         | mov                 edx, dword ptr [ebp - 0x12870]
            //   52                   | push                edx
            //   8b8584d7feff         | mov                 eax, dword ptr [ebp - 0x1287c]
            //   50                   | push                eax
            //   8b8d8cd7feff         | mov                 ecx, dword ptr [ebp - 0x12874]

        $sequence_7 = { 81c1c8000000 b810270000 99 f7f9 8b55f8 8b4df0 8b949124e80000 }
            // n = 7, score = 100
            //   81c1c8000000         | add                 ecx, 0xc8
            //   b810270000           | mov                 eax, 0x2710
            //   99                   | cdq                 
            //   f7f9                 | idiv                ecx
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   8b949124e80000       | mov                 edx, dword ptr [ecx + edx*4 + 0xe824]

        $sequence_8 = { 8b9168d40000 81ea00000100 8b45f0 899068d40000 8b4df0 8b916cd40000 }
            // n = 6, score = 100
            //   8b9168d40000         | mov                 edx, dword ptr [ecx + 0xd468]
            //   81ea00000100         | sub                 edx, 0x10000
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   899068d40000         | mov                 dword ptr [eax + 0xd468], edx
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   8b916cd40000         | mov                 edx, dword ptr [ecx + 0xd46c]

        $sequence_9 = { 8b4d08 894dfc 8b55fc 83c20c 8955f4 c645e400 }
            // n = 6, score = 100
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   83c20c               | add                 edx, 0xc
            //   8955f4               | mov                 dword ptr [ebp - 0xc], edx
            //   c645e400             | mov                 byte ptr [ebp - 0x1c], 0

    condition:
        7 of them and filesize < 270336
}