rule win_industroyer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.industroyer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.industroyer"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c745d404000000 e8???????? 50 8945e0 }
            // n = 4, score = 600
            //   c745d404000000       | mov                 dword ptr [ebp - 0x2c], 4
            //   e8????????           |                     
            //   50                   | push                eax
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax

        $sequence_1 = { 8b35???????? 83c014 894dec 034df4 034df0 }
            // n = 5, score = 600
            //   8b35????????         |                     
            //   83c014               | add                 eax, 0x14
            //   894dec               | mov                 dword ptr [ebp - 0x14], ecx
            //   034df4               | add                 ecx, dword ptr [ebp - 0xc]
            //   034df0               | add                 ecx, dword ptr [ebp - 0x10]

        $sequence_2 = { 56 6a03 ff7304 56 ff33 ff15???????? 85c0 }
            // n = 7, score = 600
            //   56                   | push                esi
            //   6a03                 | push                3
            //   ff7304               | push                dword ptr [ebx + 4]
            //   56                   | push                esi
            //   ff33                 | push                dword ptr [ebx]
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_3 = { 6a03 56 6a01 6800000080 8d85e8faffff 50 }
            // n = 6, score = 600
            //   6a03                 | push                3
            //   56                   | push                esi
            //   6a01                 | push                1
            //   6800000080           | push                0x80000000
            //   8d85e8faffff         | lea                 eax, [ebp - 0x518]
            //   50                   | push                eax

        $sequence_4 = { ff7508 33db 43 53 56 }
            // n = 5, score = 600
            //   ff7508               | push                dword ptr [ebp + 8]
            //   33db                 | xor                 ebx, ebx
            //   43                   | inc                 ebx
            //   53                   | push                ebx
            //   56                   | push                esi

        $sequence_5 = { 50 57 6805000020 53 c745f004000000 }
            // n = 5, score = 600
            //   50                   | push                eax
            //   57                   | push                edi
            //   6805000020           | push                0x20000005
            //   53                   | push                ebx
            //   c745f004000000       | mov                 dword ptr [ebp - 0x10], 4

        $sequence_6 = { ff7508 8d85f8fdffff 56 56 50 ff15???????? f7d8 }
            // n = 7, score = 600
            //   ff7508               | push                dword ptr [ebp + 8]
            //   8d85f8fdffff         | lea                 eax, [ebp - 0x208]
            //   56                   | push                esi
            //   56                   | push                esi
            //   50                   | push                eax
            //   ff15????????         |                     
            //   f7d8                 | neg                 eax

        $sequence_7 = { 8b450c 57 ff30 ff35???????? ffd6 }
            // n = 5, score = 600
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   57                   | push                edi
            //   ff30                 | push                dword ptr [eax]
            //   ff35????????         |                     
            //   ffd6                 | call                esi

        $sequence_8 = { ffb598f3ffff ffd7 6800020000 8d85a0fbffff 50 }
            // n = 5, score = 400
            //   ffb598f3ffff         | push                dword ptr [ebp - 0xc68]
            //   ffd7                 | call                edi
            //   6800020000           | push                0x200
            //   8d85a0fbffff         | lea                 eax, [ebp - 0x460]
            //   50                   | push                eax

        $sequence_9 = { 6a02 ff15???????? 8bd8 85db 0f849d000000 8d85d0fdffff }
            // n = 6, score = 400
            //   6a02                 | push                2
            //   ff15????????         |                     
            //   8bd8                 | mov                 ebx, eax
            //   85db                 | test                ebx, ebx
            //   0f849d000000         | je                  0xa3
            //   8d85d0fdffff         | lea                 eax, [ebp - 0x230]

        $sequence_10 = { 0f46f9 57 e8???????? 83c404 8bf0 8d45fc }
            // n = 6, score = 400
            //   0f46f9               | cmovbe              edi, ecx
            //   57                   | push                edi
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8bf0                 | mov                 esi, eax
            //   8d45fc               | lea                 eax, [ebp - 4]

        $sequence_11 = { b870100000 e8???????? a1???????? 33c5 8945fc 53 33db }
            // n = 7, score = 400
            //   b870100000           | mov                 eax, 0x1070
            //   e8????????           |                     
            //   a1????????           |                     
            //   33c5                 | xor                 eax, ebp
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   53                   | push                ebx
            //   33db                 | xor                 ebx, ebx

        $sequence_12 = { 0fb6db 8b859cefffff 0f44df 83c604 }
            // n = 4, score = 400
            //   0fb6db               | movzx               ebx, bl
            //   8b859cefffff         | mov                 eax, dword ptr [ebp - 0x1064]
            //   0f44df               | cmove               ebx, edi
            //   83c604               | add                 esi, 4

        $sequence_13 = { ff15???????? 8bf0 83feff 743c 6690 }
            // n = 5, score = 400
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   83feff               | cmp                 esi, -1
            //   743c                 | je                  0x3e
            //   6690                 | nop                 

        $sequence_14 = { 0f1145c0 50 0f1005???????? 6802000080 0f1145d0 ff15???????? }
            // n = 6, score = 400
            //   0f1145c0             | movups              xmmword ptr [ebp - 0x40], xmm0
            //   50                   | push                eax
            //   0f1005????????       |                     
            //   6802000080           | push                0x80000002
            //   0f1145d0             | movups              xmmword ptr [ebp - 0x30], xmm0
            //   ff15????????         |                     

        $sequence_15 = { 85c0 7431 ff35???????? 8d442448 50 ffd6 }
            // n = 6, score = 400
            //   85c0                 | test                eax, eax
            //   7431                 | je                  0x33
            //   ff35????????         |                     
            //   8d442448             | lea                 eax, [esp + 0x48]
            //   50                   | push                eax
            //   ffd6                 | call                esi

        $sequence_16 = { ffd7 59 e9???????? c745dc03000000 eb7c c745e0e0ff4000 }
            // n = 6, score = 200
            //   ffd7                 | call                edi
            //   59                   | pop                 ecx
            //   e9????????           |                     
            //   c745dc03000000       | mov                 dword ptr [ebp - 0x24], 3
            //   eb7c                 | jmp                 0x7e
            //   c745e0e0ff4000       | mov                 dword ptr [ebp - 0x20], 0x40ffe0

        $sequence_17 = { 898770020000 c70100000000 c7410400000000 c7410800000000 }
            // n = 4, score = 200
            //   898770020000         | mov                 dword ptr [edi + 0x270], eax
            //   c70100000000         | mov                 dword ptr [ecx], 0
            //   c7410400000000       | mov                 dword ptr [ecx + 4], 0
            //   c7410800000000       | mov                 dword ptr [ecx + 8], 0

        $sequence_18 = { 8bec 56 8bf1 57 8b7d08 57 8b0e }
            // n = 7, score = 200
            //   8bec                 | mov                 ebp, esp
            //   56                   | push                esi
            //   8bf1                 | mov                 esi, ecx
            //   57                   | push                edi
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   57                   | push                edi
            //   8b0e                 | mov                 ecx, dword ptr [esi]

        $sequence_19 = { ff542414 83c404 ff742414 ff15???????? 57 ff15???????? ff15???????? }
            // n = 7, score = 200
            //   ff542414             | call                dword ptr [esp + 0x14]
            //   83c404               | add                 esp, 4
            //   ff742414             | push                dword ptr [esp + 0x14]
            //   ff15????????         |                     
            //   57                   | push                edi
            //   ff15????????         |                     
            //   ff15????????         |                     

        $sequence_20 = { 83f81d 7cf1 eb07 8b0cc5dc084100 894de4 85c9 7455 }
            // n = 7, score = 200
            //   83f81d               | cmp                 eax, 0x1d
            //   7cf1                 | jl                  0xfffffff3
            //   eb07                 | jmp                 9
            //   8b0cc5dc084100       | mov                 ecx, dword ptr [eax*8 + 0x4108dc]
            //   894de4               | mov                 dword ptr [ebp - 0x1c], ecx
            //   85c9                 | test                ecx, ecx
            //   7455                 | je                  0x57

        $sequence_21 = { 7311 f30f7e0e 83e908 8d7608 660fd60f 8d7f08 8b048dc4ab4000 }
            // n = 7, score = 200
            //   7311                 | jae                 0x13
            //   f30f7e0e             | movq                xmm1, qword ptr [esi]
            //   83e908               | sub                 ecx, 8
            //   8d7608               | lea                 esi, [esi + 8]
            //   660fd60f             | movq                qword ptr [edi], xmm1
            //   8d7f08               | lea                 edi, [edi + 8]
            //   8b048dc4ab4000       | mov                 eax, dword ptr [ecx*4 + 0x40abc4]

        $sequence_22 = { 68???????? e8???????? 83c40c 8bb5f4efffff c6460101 }
            // n = 5, score = 200
            //   68????????           |                     
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8bb5f4efffff         | mov                 esi, dword ptr [ebp - 0x100c]
            //   c6460101             | mov                 byte ptr [esi + 1], 1

        $sequence_23 = { 6bc930 8b0485d01f0210 f644082801 7406 8b440818 5d }
            // n = 6, score = 200
            //   6bc930               | imul                ecx, ecx, 0x30
            //   8b0485d01f0210       | mov                 eax, dword ptr [eax*4 + 0x10021fd0]
            //   f644082801           | test                byte ptr [eax + ecx + 0x28], 1
            //   7406                 | je                  8
            //   8b440818             | mov                 eax, dword ptr [eax + ecx + 0x18]
            //   5d                   | pop                 ebp

        $sequence_24 = { 8b0d???????? 81c178020100 890d???????? 8b4df4 }
            // n = 4, score = 200
            //   8b0d????????         |                     
            //   81c178020100         | add                 ecx, 0x10278
            //   890d????????         |                     
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]

        $sequence_25 = { 0f851c0b0000 8d0d90fd4000 ba1b000000 e9???????? a900000080 }
            // n = 5, score = 200
            //   0f851c0b0000         | jne                 0xb22
            //   8d0d90fd4000         | lea                 ecx, [0x40fd90]
            //   ba1b000000           | mov                 edx, 0x1b
            //   e9????????           |                     
            //   a900000080           | test                eax, 0x80000000

        $sequence_26 = { e8???????? 8b4604 0fb64003 50 68???????? e8???????? }
            // n = 6, score = 200
            //   e8????????           |                     
            //   8b4604               | mov                 eax, dword ptr [esi + 4]
            //   0fb64003             | movzx               eax, byte ptr [eax + 3]
            //   50                   | push                eax
            //   68????????           |                     
            //   e8????????           |                     

        $sequence_27 = { 50 ff15???????? 85c0 7407 6a00 ffd0 83c404 }
            // n = 7, score = 200
            //   50                   | push                eax
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7407                 | je                  9
            //   6a00                 | push                0
            //   ffd0                 | call                eax
            //   83c404               | add                 esp, 4

        $sequence_28 = { eb55 8b1c9db8c14000 56 6800080000 }
            // n = 4, score = 200
            //   eb55                 | jmp                 0x57
            //   8b1c9db8c14000       | mov                 ebx, dword ptr [ebx*4 + 0x40c1b8]
            //   56                   | push                esi
            //   6800080000           | push                0x800

        $sequence_29 = { 68???????? ff15???????? 6880ee3600 ff15???????? }
            // n = 4, score = 200
            //   68????????           |                     
            //   ff15????????         |                     
            //   6880ee3600           | push                0x36ee80
            //   ff15????????         |                     

        $sequence_30 = { 8b04b8 03c6 50 51 8b4c2428 }
            // n = 5, score = 200
            //   8b04b8               | mov                 eax, dword ptr [eax + edi*4]
            //   03c6                 | add                 eax, esi
            //   50                   | push                eax
            //   51                   | push                ecx
            //   8b4c2428             | mov                 ecx, dword ptr [esp + 0x28]

        $sequence_31 = { 83e802 7506 80790504 7420 33c0 5e }
            // n = 6, score = 200
            //   83e802               | sub                 eax, 2
            //   7506                 | jne                 8
            //   80790504             | cmp                 byte ptr [ecx + 5], 4
            //   7420                 | je                  0x22
            //   33c0                 | xor                 eax, eax
            //   5e                   | pop                 esi

        $sequence_32 = { 017704 ebb5 8b4dec e8???????? 6a00 }
            // n = 5, score = 100
            //   017704               | add                 dword ptr [edi + 4], esi
            //   ebb5                 | jmp                 0xffffffb7
            //   8b4dec               | mov                 ecx, dword ptr [ebp - 0x14]
            //   e8????????           |                     
            //   6a00                 | push                0

        $sequence_33 = { 51 8d4b34 e8???????? 8b4338 894594 }
            // n = 5, score = 100
            //   51                   | push                ecx
            //   8d4b34               | lea                 ecx, [ebx + 0x34]
            //   e8????????           |                     
            //   8b4338               | mov                 eax, dword ptr [ebx + 0x38]
            //   894594               | mov                 dword ptr [ebp - 0x6c], eax

        $sequence_34 = { e9???????? 55 8bec 81ecec020000 a1???????? }
            // n = 5, score = 100
            //   e9????????           |                     
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   81ecec020000         | sub                 esp, 0x2ec
            //   a1????????           |                     

        $sequence_35 = { 8d8d98feffff ff30 e8???????? 8d8d7cfdffff 83fb04 0f86f7020000 }
            // n = 6, score = 100
            //   8d8d98feffff         | lea                 ecx, [ebp - 0x168]
            //   ff30                 | push                dword ptr [eax]
            //   e8????????           |                     
            //   8d8d7cfdffff         | lea                 ecx, [ebp - 0x284]
            //   83fb04               | cmp                 ebx, 4
            //   0f86f7020000         | jbe                 0x2fd

        $sequence_36 = { 50 ff36 e8???????? 83c40c 6b450830 }
            // n = 5, score = 100
            //   50                   | push                eax
            //   ff36                 | push                dword ptr [esi]
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   6b450830             | imul                eax, dword ptr [ebp + 8], 0x30

        $sequence_37 = { 57 8bfe 83e63f c1ff06 6bf630 8b04bd58984500 f644302880 }
            // n = 7, score = 100
            //   57                   | push                edi
            //   8bfe                 | mov                 edi, esi
            //   83e63f               | and                 esi, 0x3f
            //   c1ff06               | sar                 edi, 6
            //   6bf630               | imul                esi, esi, 0x30
            //   8b04bd58984500       | mov                 eax, dword ptr [edi*4 + 0x459858]
            //   f644302880           | test                byte ptr [eax + esi + 0x28], 0x80

        $sequence_38 = { 751b 8365e800 c745ec271b4100 8d4de0 e8???????? }
            // n = 5, score = 100
            //   751b                 | jne                 0x1d
            //   8365e800             | and                 dword ptr [ebp - 0x18], 0
            //   c745ec271b4100       | mov                 dword ptr [ebp - 0x14], 0x411b27
            //   8d4de0               | lea                 ecx, [ebp - 0x20]
            //   e8????????           |                     

        $sequence_39 = { 8d8424cc000000 50 57 e8???????? 6a30 }
            // n = 5, score = 100
            //   8d8424cc000000       | lea                 eax, [esp + 0xcc]
            //   50                   | push                eax
            //   57                   | push                edi
            //   e8????????           |                     
            //   6a30                 | push                0x30

    condition:
        7 of them and filesize < 983040
}