rule win_isfb_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.isfb."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.isfb"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 33c0 e8???????? 3bc7 740f }
            // n = 5, score = 2500
            //   50                   | push                dword ptr [ebp + 0xc]
            //   33c0                 | xor                 edi, edi
            //   e8????????           |                     
            //   3bc7                 | push                dword ptr [ebp + 8]
            //   740f                 | and                 dword ptr [ebp - 4], edi

        $sequence_1 = { 33c0 3bc7 741b 50 33c0 }
            // n = 5, score = 2500
            //   33c0                 | push                edi
            //   3bc7                 | push                dword ptr [ebp + 0xc]
            //   741b                 | push                ebx
            //   50                   | cmp                 edi, esi
            //   33c0                 | je                  0x17

        $sequence_2 = { 33c0 3bc7 7413 50 }
            // n = 4, score = 2400
            //   33c0                 | push                esi
            //   3bc7                 | xor                 esi, esi
            //   7413                 | cmp                 dword ptr [ebp - 4], esi
            //   50                   | je                  0x15

        $sequence_3 = { ff75f4 6822010000 e9???????? ff7508 }
            // n = 4, score = 2400
            //   ff75f4               | mov                 ebx, 1
            //   6822010000           | dec                 ecx
            //   e9????????           |                     
            //   ff7508               | mov                 ecx, esp

        $sequence_4 = { 6a10 58 e8???????? 3bc7 7406 50 e8???????? }
            // n = 7, score = 2400
            //   6a10                 | cmp                 edi, esi
            //   58                   | je                  0x13
            //   e8????????           |                     
            //   3bc7                 | mov                 esi, dword ptr [ebp + 8]
            //   7406                 | xor                 esi, esi
            //   50                   | cmp                 dword ptr [ebp - 4], esi
            //   e8????????           |                     

        $sequence_5 = { 51 57 50 e8???????? 83c40c e8???????? 3bc7 }
            // n = 7, score = 2200
            //   51                   | mov                 eax, ebp
            //   57                   | pop                 ebp
            //   50                   | pop                 ebx
            //   e8????????           |                     
            //   83c40c               | pop                 ecx
            //   e8????????           |                     
            //   3bc7                 | ret                 4

        $sequence_6 = { 6a64 ff15???????? a1???????? 85c0 7407 83ee64 }
            // n = 6, score = 2200
            //   6a64                 | push                ebx
            //   ff15????????         |                     
            //   a1????????           |                     
            //   85c0                 | mov                 ebx, 0xea60
            //   7407                 | push                ebx
            //   83ee64               | push                dword ptr [ebp + 0xc]

        $sequence_7 = { ff35???????? e8???????? 8bf0 3bf3 7443 6aff }
            // n = 6, score = 2200
            //   ff35????????         |                     
            //   e8????????           |                     
            //   8bf0                 | dec                 eax
            //   3bf3                 | mov                 ecx, edi
            //   7443                 | mov                 dword ptr [esp + 0x28], 0xea60
            //   6aff                 | dec                 esp

        $sequence_8 = { 50 e8???????? 3bdf 7414 }
            // n = 4, score = 2100
            //   50                   | push                eax
            //   e8????????           |                     
            //   3bdf                 | cmp                 ebx, edi
            //   7414                 | je                  0x16

        $sequence_9 = { ff35???????? ff15???????? 85c0 a3???????? 7402 ffe0 }
            // n = 6, score = 2100
            //   ff35????????         |                     
            //   ff15????????         |                     
            //   85c0                 | neg                 al
            //   a3????????           |                     
            //   7402                 | sbb                 eax, eax
            //   ffe0                 | mov                 dword ptr [esp + 0x28], 0xea60

        $sequence_10 = { 5b 59 c20400 8325????????00 }
            // n = 4, score = 2100
            //   5b                   | push                0xff676980
            //   59                   | push                eax
            //   c20400               | push                edi
            //   8325????????00       |                     

        $sequence_11 = { ff15???????? 3c05 7506 84e4 7704 3ac0 }
            // n = 6, score = 1800
            //   ff15????????         |                     
            //   3c05                 | mov                 ecx, 0x10e
            //   7506                 | inc                 ecx
            //   84e4                 | mov                 eax, 0x10000
            //   7704                 | dec                 eax
            //   3ac0                 | mov                 dword ptr [esp + 0x20], eax

        $sequence_12 = { 5b c20400 55 8bec 83ec0c a1???????? 8365f800 }
            // n = 7, score = 1800
            //   5b                   | jmp                 9
            //   c20400               | add                 ebx, 1
            //   55                   | dec                 eax
            //   8bec                 | lea                 ecx, [eax + 1]
            //   83ec0c               | mov                 dx, 0x20
            //   a1????????           |                     
            //   8365f800             | dec                 eax

        $sequence_13 = { 83451004 83c004 49 8917 75e9 8b4e10 83e103 }
            // n = 7, score = 1700
            //   83451004             | cmp                 eax, edi
            //   83c004               | je                  0xb
            //   49                   | pop                 eax
            //   8917                 | cmp                 eax, edi
            //   75e9                 | je                  0xa
            //   8b4e10               | push                eax
            //   83e103               | xor                 eax, eax

        $sequence_14 = { b8???????? 53 bb60ea0000 53 }
            // n = 4, score = 1700
            //   b8????????           |                     
            //   53                   | cmovne              ecx, eax
            //   bb60ea0000           | dec                 eax
            //   53                   | mov                 dword ptr [esp + 0x20], ebx

        $sequence_15 = { 75e9 8b4e10 83e103 740d 51 50 ff7510 }
            // n = 7, score = 1700
            //   75e9                 | cmp                 eax, edi
            //   8b4e10               | je                  0x19
            //   83e103               | jmp                 4
            //   740d                 | xor                 eax, eax
            //   51                   | cmp                 eax, edi
            //   50                   | je                  0x17
            //   ff7510               | push                eax

        $sequence_16 = { 3bc3 7512 e8???????? 3bc3 a3???????? }
            // n = 5, score = 1700
            //   3bc3                 | jne                 0x167
            //   7512                 | mov                 eax, dword ptr [ebx + 0x48]
            //   e8????????           |                     
            //   3bc3                 | je                  0x2e
            //   a3????????           |                     

        $sequence_17 = { 8b10 2b55fc 8b7d10 0155fc 83451004 83c004 49 }
            // n = 7, score = 1700
            //   8b10                 | jmp                 4
            //   2b55fc               | xor                 eax, eax
            //   8b7d10               | cmp                 eax, edi
            //   0155fc               | je                  0x21
            //   83451004             | push                eax
            //   83c004               | xor                 eax, eax
            //   49                   | cmp                 eax, edi

        $sequence_18 = { 51 50 ff7510 e8???????? 83c40c c745fc01000000 8b4610 }
            // n = 7, score = 1700
            //   51                   | je                  0x21
            //   50                   | push                eax
            //   ff7510               | xor                 eax, eax
            //   e8????????           |                     
            //   83c40c               | jmp                 4
            //   c745fc01000000       | xor                 eax, eax
            //   8b4610               | cmp                 eax, edi

        $sequence_19 = { ff37 ff15???????? 2b442414 50 }
            // n = 4, score = 1600
            //   ff37                 | xor                 eax, eax
            //   ff15????????         |                     
            //   2b442414             | cmp                 eax, edi
            //   50                   | je                  0x21

        $sequence_20 = { 8b4320 897324 897328 83c40c 8974240c c6401a00 8b44240c }
            // n = 7, score = 1600
            //   8b4320               | mov                 esp, edi
            //   897324               | jne                 0xffffffc6
            //   897328               | dec                 eax
            //   83c40c               | mov                 dword ptr [esi], ebp
            //   8974240c             | jmp                 9
            //   c6401a00             | xor                 ebx, ebx
            //   8b44240c             | mov                 byte ptr [esi + 8], bl

        $sequence_21 = { 57 8b3b 897c241c 760a 8b4b20 e8???????? eb02 }
            // n = 7, score = 1600
            //   57                   | dec                 eax
            //   8b3b                 | lea                 ecx, [eax + 1]
            //   897c241c             | mov                 ebx, 1
            //   760a                 | dec                 ecx
            //   8b4b20               | mov                 ecx, esp
            //   e8????????           |                     
            //   eb02                 | jmp                 0xc

        $sequence_22 = { 83631c00 894b34 8b4b24 2b4b28 894c2410 8b4b34 }
            // n = 6, score = 1600
            //   83631c00             | push                eax
            //   894b34               | xor                 eax, eax
            //   8b4b24               | cmp                 eax, edi
            //   2b4b28               | jmp                 4
            //   894c2410             | xor                 eax, eax
            //   8b4b34               | cmp                 eax, edi

        $sequence_23 = { 8a4604 2404 f6d8 1bc0 }
            // n = 4, score = 1600
            //   8a4604               | cmp                 dword ptr [ebp - 4], esi
            //   2404                 | je                  0x15
            //   f6d8                 | push                dword ptr [ebp - 4]
            //   1bc0                 | push                esi

        $sequence_24 = { 7520 ff37 50 ff35???????? ff15???????? 8b442414 }
            // n = 6, score = 1600
            //   7520                 | xor                 eax, eax
            //   ff37                 | cmp                 eax, edi
            //   50                   | je                  0x1d
            //   ff35????????         |                     
            //   ff15????????         |                     
            //   8b442414             | push                eax

        $sequence_25 = { 6a0d 58 e8???????? 85c0 740d 8906 }
            // n = 6, score = 1600
            //   6a0d                 | cmp                 ebp, 5
            //   58                   | jb                  0xffffffc3
            //   e8????????           |                     
            //   85c0                 | jmp                 0x10
            //   740d                 | mov                 ebx, 0x7f
            //   8906                 | jmp                 0x10

        $sequence_26 = { ff15???????? 8b442414 8b4c240c 8907 8b442418 894110 836334f9 }
            // n = 7, score = 1600
            //   ff15????????         |                     
            //   8b442414             | add                 ebx, 1
            //   8b4c240c             | xor                 ebx, ebx
            //   8907                 | mov                 dx, 0x20
            //   8b442418             | dec                 ecx
            //   894110               | mov                 ecx, esp
            //   836334f9             | dec                 esp

        $sequence_27 = { 8b07 03442418 50 56 ff5310 8b16 }
            // n = 6, score = 1600
            //   8b07                 | xor                 edx, edx
            //   03442418             | mov                 ebx, 1
            //   50                   | dec                 ecx
            //   56                   | mov                 ecx, esp
            //   ff5310               | jmp                 0x11
            //   8b16                 | add                 ebx, 1

        $sequence_28 = { ff35???????? 0fc8 50 a1???????? }
            // n = 4, score = 1600
            //   ff35????????         |                     
            //   0fc8                 | bswap               eax
            //   50                   | push                eax
            //   a1????????           |                     

        $sequence_29 = { 68???????? e8???????? 8b07 c6400731 8b74241c 8b1e 6a00 }
            // n = 7, score = 1600
            //   68????????           |                     
            //   e8????????           |                     
            //   8b07                 | add                 ebx, 1
            //   c6400731             | xor                 edx, edx
            //   8b74241c             | inc                 ecx
            //   8b1e                 | shl                 eax, 3
            //   6a00                 | dec                 eax

        $sequence_30 = { 837d1800 b8???????? 7505 b8???????? 53 }
            // n = 5, score = 1500
            //   837d1800             | dec                 eax
            //   b8????????           |                     
            //   7505                 | mov                 edx, dword ptr [esp + 0x48]
            //   b8????????           |                     
            //   53                   | mov                 dword ptr [esp + 0x30], ecx

        $sequence_31 = { 53 8bc6 e8???????? 85c0 7516 }
            // n = 5, score = 1500
            //   53                   | push                ebx
            //   8bc6                 | mov                 eax, esi
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7516                 | jne                 0x18

        $sequence_32 = { 752f 8b450c 8930 eb33 6a00 }
            // n = 5, score = 1500
            //   752f                 | jne                 0x31
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8930                 | mov                 dword ptr [eax], esi
            //   eb33                 | jmp                 0x35
            //   6a00                 | push                0

        $sequence_33 = { 8b4c240c 8911 eb07 6a0b eb02 }
            // n = 5, score = 1500
            //   8b4c240c             | je                  0x13
            //   8911                 | push                eax
            //   eb07                 | cmp                 eax, edi
            //   6a0b                 | je                  0x11
            //   eb02                 | push                eax

        $sequence_34 = { 488bcf c744242860ea0000 4c0f45c8 48895c2420 e8???????? }
            // n = 5, score = 1500
            //   488bcf               | je                  0x1f
            //   c744242860ea0000     | push                eax
            //   4c0f45c8             | xor                 eax, eax
            //   48895c2420           | jmp                 4
            //   e8????????           |                     

        $sequence_35 = { 3bc8 7415 8b5210 3bd0 740e }
            // n = 5, score = 1500
            //   3bc8                 | xor                 eax, eax
            //   7415                 | cmp                 eax, edi
            //   8b5210               | je                  0x16
            //   3bd0                 | push                eax
            //   740e                 | xor                 eax, eax

        $sequence_36 = { 3bd0 7420 8b4a0c 3bc8 7415 }
            // n = 5, score = 1500
            //   3bd0                 | cmp                 eax, edi
            //   7420                 | je                  0x11
            //   8b4a0c               | push                eax
            //   3bc8                 | je                  0x1d
            //   7415                 | push                eax

        $sequence_37 = { 50 8d4508 50 53 8bc6 }
            // n = 5, score = 1500
            //   50                   | push                eax
            //   8d4508               | lea                 eax, [ebp + 8]
            //   50                   | push                eax
            //   53                   | push                ebx
            //   8bc6                 | mov                 eax, esi

        $sequence_38 = { 74a3 33ff eb0b 33ff }
            // n = 4, score = 1500
            //   74a3                 | je                  0xffffffa5
            //   33ff                 | xor                 edi, edi
            //   eb0b                 | jmp                 0xd
            //   33ff                 | xor                 edi, edi

        $sequence_39 = { 750e 837d0800 7408 ff7508 e8???????? 8bc7 }
            // n = 6, score = 1500
            //   750e                 | jne                 0x10
            //   837d0800             | cmp                 dword ptr [ebp + 8], 0
            //   7408                 | je                  0xa
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   8bc7                 | mov                 eax, edi

        $sequence_40 = { c21000 55 8bec 83ec14 a1???????? 53 56 }
            // n = 7, score = 1400
            //   c21000               | test                eax, eax
            //   55                   | add                 ebx, 1
            //   8bec                 | dec                 eax
            //   83ec14               | test                edi, edi
            //   a1????????           |                     
            //   53                   | dec                 esp
            //   56                   | mov                 esp, edi

        $sequence_41 = { 57 6a01 ff75e0 68???????? }
            // n = 4, score = 1400
            //   57                   | mov                 ebx, eax
            //   6a01                 | xor                 edx, edx
            //   ff75e0               | dec                 ecx
            //   68????????           |                     

        $sequence_42 = { 4885ff 4c8be7 75c4 48892e eb02 33db 488b0d???????? }
            // n = 7, score = 1400
            //   4885ff               | pop                 ecx
            //   4c8be7               | ret                 4
            //   75c4                 | push                0
            //   48892e               | push                1
            //   eb02                 | pop                 ebp
            //   33db                 | pop                 ebx
            //   488b0d????????       |                     

        $sequence_43 = { 498bcc eb07 83c301 488d4801 66ba2000 ff15???????? 4885c0 }
            // n = 7, score = 1400
            //   498bcc               | add                 ebx, 1
            //   eb07                 | dec                 eax
            //   83c301               | test                edi, edi
            //   488d4801             | dec                 esp
            //   66ba2000             | mov                 esp, edi
            //   ff15????????         |                     
            //   4885c0               | jne                 0xffffffcc

        $sequence_44 = { e8???????? be01000000 8bc6 4883c440 }
            // n = 4, score = 1400
            //   e8????????           |                     
            //   be01000000           | pop                 ebp
            //   8bc6                 | ret                 8
            //   4883c440             | mov                 eax, dword ptr [ebx + 0x30]

        $sequence_45 = { 488bcf ff15???????? 4c8964dd00 83c301 }
            // n = 4, score = 1400
            //   488bcf               | pop                 ebp
            //   ff15????????         |                     
            //   4c8964dd00           | pop                 ebx
            //   83c301               | pop                 ecx

        $sequence_46 = { 33d2 41c1e003 ff15???????? 4885c0 488be8 7453 }
            // n = 6, score = 1400
            //   33d2                 | mov                 esi, dword ptr [ebx + 0x34]
            //   41c1e003             | push                dword ptr [ebp + 8]
            //   ff15????????         |                     
            //   4885c0               | push                dword ptr [ebp - 0x10]
            //   488be8               | push                dword ptr [ebp - 0xc]
            //   7453                 | push                0x122

        $sequence_47 = { 415c 5f 5e 5d 5b c3 8b4754 }
            // n = 7, score = 1400
            //   415c                 | je                  0xffffff60
            //   5f                   | mov                 eax, dword ptr [edi + 0xc]
            //   5e                   | ret                 8
            //   5d                   | mov                 eax, dword ptr [ebx + 0x30]
            //   5b                   | test                al, 4
            //   c3                   | je                  0xffffff5c
            //   8b4754               | mov                 eax, dword ptr [edi + 0xc]

        $sequence_48 = { e8???????? 85c0 742d ff75fc 6a0d }
            // n = 5, score = 1400
            //   e8????????           |                     
            //   85c0                 | pop                 esp
            //   742d                 | dec                 eax
            //   ff75fc               | mov                 ecx, edi
            //   6a0d                 | dec                 eax

        $sequence_49 = { 33db 66ba2000 498bcc ff15???????? 4885c0 }
            // n = 5, score = 1400
            //   33db                 | ret                 4
            //   66ba2000             | push                0
            //   498bcc               | pop                 esi
            //   ff15????????         |                     
            //   4885c0               | mov                 eax, ebp

        $sequence_50 = { 53 b800080000 50 56 ff35???????? }
            // n = 5, score = 1400
            //   53                   | push                eax
            //   b800080000           | push                ecx
            //   50                   | mov                 eax, esi
            //   56                   | mov                 eax, dword ptr [esi]
            //   ff35????????         |                     

        $sequence_51 = { 740f 488b0d???????? 33d2 ff15???????? bb01000000 498bcc eb07 }
            // n = 7, score = 1400
            //   740f                 | push                0
            //   488b0d????????       |                     
            //   33d2                 | pop                 ecx
            //   ff15????????         |                     
            //   bb01000000           | ret                 4
            //   498bcc               | push                0
            //   eb07                 | push                1

        $sequence_52 = { 498bcc ff15???????? 33db 66ba2000 }
            // n = 4, score = 1400
            //   498bcc               | add                 esi, 4
            //   ff15????????         |                     
            //   33db                 | cmp                 edi, ebx
            //   66ba2000             | je                  0x1b

        $sequence_53 = { a3???????? 7402 ffe0 c20400 55 8bec 83ec10 }
            // n = 7, score = 1300
            //   a3????????           |                     
            //   7402                 | lea                 ecx, [ebx + eax*8]
            //   ffe0                 | inc                 ecx
            //   c20400               | movzx               eax, byte ptr [ecx + 2]
            //   55                   | inc                 esp
            //   8bec                 | mov                 ebp, eax
            //   83ec10               | inc                 ecx

        $sequence_54 = { 53 ff35???????? c745f408000000 ff15???????? 3bc3 8945f8 }
            // n = 6, score = 1300
            //   53                   | dec                 eax
            //   ff35????????         |                     
            //   c745f408000000       | mov                 ebx, edi
            //   ff15????????         |                     
            //   3bc3                 | mov                 esi, edi
            //   8945f8               | dec                 eax

        $sequence_55 = { 8bd5 488bcf bb57000000 e8???????? }
            // n = 4, score = 1300
            //   8bd5                 | inc                 ecx
            //   488bcf               | shl                 eax, 3
            //   bb57000000           | dec                 eax
            //   e8????????           |                     

        $sequence_56 = { e8???????? 3bc3 740f 8b35???????? 50 83c604 e8???????? }
            // n = 7, score = 1300
            //   e8????????           |                     
            //   3bc3                 | push                1
            //   740f                 | push                dword ptr [ebp + 0x14]
            //   8b35????????         |                     
            //   50                   | push                dword ptr [ebp + 0xc]
            //   83c604               | push                ebx
            //   e8????????           |                     

        $sequence_57 = { ffd7 ff750c ff15???????? a810 }
            // n = 4, score = 1300
            //   ffd7                 | dec                 eax
            //   ff750c               | cmp                 ebx, edi
            //   ff15????????         |                     
            //   a810                 | jne                 0xf

        $sequence_58 = { 89450c ff15???????? 3bc3 8945f4 741a ff750c 668918 }
            // n = 7, score = 1300
            //   89450c               | xor                 edx, edx
            //   ff15????????         |                     
            //   3bc3                 | dec                 eax
            //   8945f4               | mov                 ebx, edi
            //   741a                 | mov                 esi, edi
            //   ff750c               | dec                 eax
            //   668918               | cmp                 ebx, edi

        $sequence_59 = { 50 83c604 e8???????? 3bfb 7414 a1???????? }
            // n = 6, score = 1300
            //   50                   | push                ebx
            //   83c604               | mov                 eax, 0x800
            //   e8????????           |                     
            //   3bfb                 | push                eax
            //   7414                 | push                esi
            //   a1????????           |                     

        $sequence_60 = { 8bd7 e8???????? eb02 33c0 3bc3 741b }
            // n = 6, score = 1300
            //   8bd7                 | push                dword ptr [ebp - 4]
            //   e8????????           |                     
            //   eb02                 | push                esi
            //   33c0                 | mov                 edi, eax
            //   3bc3                 | push                dword ptr [ebp + 0x10]
            //   741b                 | push                edi

        $sequence_61 = { 3bc3 7406 50 e8???????? 3bfb 7414 }
            // n = 6, score = 1300
            //   3bc3                 | je                  0x10
            //   7406                 | push                edi
            //   50                   | push                dword ptr [ebp + 0x10]
            //   e8????????           |                     
            //   3bfb                 | push                edi
            //   7414                 | push                dword ptr [ebp + 0xc]

        $sequence_62 = { 6641b85c00 33d2 488bcd ff15???????? }
            // n = 4, score = 1300
            //   6641b85c00           | mov                 esp, edi
            //   33d2                 | jne                 0xffffffc6
            //   488bcd               | dec                 eax
            //   ff15????????         |                     

        $sequence_63 = { ba08000000 b90e010000 41b800000100 4889442420 e8???????? e9???????? }
            // n = 6, score = 1300
            //   ba08000000           | je                  0x18
            //   b90e010000           | je                  0x1d
            //   41b800000100         | push                eax
            //   4889442420           | xor                 eax, eax
            //   e8????????           |                     
            //   e9????????           |                     

        $sequence_64 = { e8???????? 85db 7423 8b0d???????? }
            // n = 4, score = 1300
            //   e8????????           |                     
            //   85db                 | pop                 ebp
            //   7423                 | pop                 ebx
            //   8b0d????????         |                     

        $sequence_65 = { ff15???????? 488bdf 8bf7 483bdf 7508 }
            // n = 5, score = 1300
            //   ff15????????         |                     
            //   488bdf               | push                esi
            //   8bf7                 | mov                 dword ptr [ebp - 8], eax
            //   483bdf               | mov                 ebx, eax
            //   7508                 | mov                 eax, 0x800

        $sequence_66 = { 85c0 0f84dc000000 8b45e0 8d4de0 3bc1 0f84ce000000 eb03 }
            // n = 7, score = 1300
            //   85c0                 | cmp                 ebx, edi
            //   0f84dc000000         | dec                 esp
            //   8b45e0               | mov                 eax, ebx
            //   8d4de0               | xor                 edx, edx
            //   3bc1                 | dec                 eax
            //   0f84ce000000         | mov                 ebx, edi
            //   eb03                 | mov                 esi, edi

        $sequence_67 = { 4883c608 83fd05 72c1 eb0c bb7f000000 eb05 }
            // n = 6, score = 1300
            //   4883c608             | mov                 esi, edi
            //   83fd05               | dec                 eax
            //   72c1                 | cmp                 ebx, edi
            //   eb0c                 | jne                 0x14
            //   bb7f000000           | dec                 esp
            //   eb05                 | mov                 eax, ebx

        $sequence_68 = { 57 ff750c 53 e8???????? 3bfe 740e }
            // n = 6, score = 1200
            //   57                   | push                edi
            //   ff750c               | push                dword ptr [ebp + 0x10]
            //   53                   | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   3bfe                 | mov                 eax, esi
            //   740e                 | mov                 eax, dword ptr [esi]

        $sequence_69 = { 8b4330 a804 0f8451ffffff 8b470c }
            // n = 4, score = 1200
            //   8b4330               | push                esi
            //   a804                 | cmp                 edi, esi
            //   0f8451ffffff         | je                  0x10
            //   8b470c               | push                edi

        $sequence_70 = { e8???????? 85c0 0f8586000000 8b4720 8b4e04 6a00 }
            // n = 6, score = 1200
            //   e8????????           |                     
            //   85c0                 | dec                 eax
            //   0f8586000000         | mov                 eax, dword ptr [esi + 0x10]
            //   8b4720               | dec                 eax
            //   8b4e04               | mov                 dword ptr [edi + 0x18], eax
            //   6a00                 | dec                 eax

        $sequence_71 = { 0f84e2000000 8b7334 8d442418 50 8d442410 50 e8???????? }
            // n = 7, score = 1200
            //   0f84e2000000         | push                1
            //   8b7334               | push                1
            //   8d442418             | push                dword ptr [ebp + 0x14]
            //   50                   | push                eax
            //   8d442410             | push                esi
            //   50                   | mov                 dword ptr [ebp - 8], eax
            //   e8????????           |                     

        $sequence_72 = { 8b8c2490000000 83bc248800000000 4c8b442440 488b542448 }
            // n = 4, score = 1200
            //   8b8c2490000000       | cmp                 eax, edi
            //   83bc248800000000     | je                  0x21
            //   4c8b442440           | push                eax
            //   488b542448           | xor                 eax, eax

        $sequence_73 = { ff75fc 56 ff35???????? ff15???????? 53 56 }
            // n = 6, score = 1200
            //   ff75fc               | xor                 ebp, ebp
            //   56                   | push                edi
            //   ff35????????         |                     
            //   ff15????????         |                     
            //   53                   | cmp                 eax, ebp
            //   56                   | je                  0x11

        $sequence_74 = { 83632800 e9???????? 8b4330 a840 0f84e2000000 8b7334 }
            // n = 6, score = 1200
            //   83632800             | dec                 esp
            //   e9????????           |                     
            //   8b4330               | mov                 esp, edi
            //   a840                 | jne                 0xffffffd4
            //   0f84e2000000         | dec                 eax
            //   8b7334               | mov                 ecx, edi

        $sequence_75 = { 752e 53 e8???????? 6a01 }
            // n = 4, score = 1200
            //   752e                 | mov                 ecx, dword ptr [eax]
            //   53                   | push                ebx
            //   e8????????           |                     
            //   6a01                 | mov                 eax, edi

        $sequence_76 = { 8b7508 e8???????? 33f6 3975fc 7410 ff75fc }
            // n = 6, score = 1200
            //   8b7508               | mov                 eax, dword ptr [esi]
            //   e8????????           |                     
            //   33f6                 | mov                 ecx, dword ptr [eax]
            //   3975fc               | push                edi
            //   7410                 | mov                 eax, edi
            //   ff75fc               | lea                 eax, [esi + 0x18]

        $sequence_77 = { 0f854affffff 894330 e9???????? 55 }
            // n = 4, score = 1200
            //   0f854affffff         | mov                 ecx, edi
            //   894330               | dec                 esp
            //   e9????????           |                     
            //   55                   | mov                 dword ptr [ebp + ebx*8], esp

        $sequence_78 = { 85ff 0f845d010000 8b4730 a808 7412 }
            // n = 5, score = 1200
            //   85ff                 | dec                 eax
            //   0f845d010000         | arpl                word ptr [esi + 0x1c], ax
            //   8b4730               | sub                 ebp, dword ptr [esi + 0x1c]
            //   a808                 | dec                 esp
            //   7412                 | add                 ebp, eax

        $sequence_79 = { c744242000010000 ff15???????? 4883f8ff 488bf8 7442 }
            // n = 5, score = 1200
            //   c744242000010000     | push                eax
            //   ff15????????         |                     
            //   4883f8ff             | xor                 eax, eax
            //   488bf8               | cmp                 eax, edi
            //   7442                 | jmp                 4

        $sequence_80 = { ff35???????? 8945f8 ff15???????? 8bd8 3bde }
            // n = 5, score = 1200
            //   ff35????????         |                     
            //   8945f8               | push                ebp
            //   ff15????????         |                     
            //   8bd8                 | mov                 ebp, esp
            //   3bde                 | and                 esp, 0xfffffff8

        $sequence_81 = { e8???????? 3bfe 740e 57 56 ff35???????? ff15???????? }
            // n = 7, score = 1200
            //   e8????????           |                     
            //   3bfe                 | lea                 eax, [esi + 0x18]
            //   740e                 | mov                 ecx, dword ptr [eax]
            //   57                   | push                eax
            //   56                   | mov                 eax, edi
            //   ff35????????         |                     
            //   ff15????????         |                     

        $sequence_82 = { ff15???????? 53 56 ff35???????? ff15???????? 5b }
            // n = 6, score = 1200
            //   ff15????????         |                     
            //   53                   | lea                 eax, [esi + 0x18]
            //   56                   | mov                 ecx, dword ptr [eax]
            //   ff35????????         |                     
            //   ff15????????         |                     
            //   5b                   | push                eax

        $sequence_83 = { 53 e8???????? 85c0 0f8544010000 8b472c a801 }
            // n = 6, score = 1200
            //   53                   | dec                 eax
            //   e8????????           |                     
            //   85c0                 | mov                 dword ptr [edi + 0x18], eax
            //   0f8544010000         | dec                 eax
            //   8b472c               | and                 dword ptr [esi + 0x10], 0
            //   a801                 | sub                 ebp, dword ptr [esi + 0x1c]

        $sequence_84 = { ff5214 8bf7 8bfe e8???????? 5f 5e 5b }
            // n = 7, score = 1200
            //   ff5214               | push                esi
            //   8bf7                 | push                ebx
            //   8bfe                 | push                esi
            //   e8????????           |                     
            //   5f                   | pop                 ebx
            //   5e                   | test                byte ptr [eax + 4], 8
            //   5b                   | jne                 0x30

        $sequence_85 = { ff15???????? 4885db 740c 4c8b0d???????? e9???????? }
            // n = 5, score = 1100
            //   ff15????????         |                     
            //   4885db               | push                eax
            //   740c                 | push                edi
            //   4c8b0d????????       |                     
            //   e9????????           |                     

        $sequence_86 = { e8???????? 85c0 7507 33db 895d08 }
            // n = 5, score = 1100
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7507                 | jne                 9
            //   33db                 | xor                 ebx, ebx
            //   895d08               | mov                 dword ptr [ebp + 8], ebx

        $sequence_87 = { ff15???????? 488bcf 48870d???????? 483bcf 7405 e8???????? ba01000000 }
            // n = 7, score = 1100
            //   ff15????????         |                     
            //   488bcf               | mov                 esi, ecx
            //   48870d????????       |                     
            //   483bcf               | inc                 ecx
            //   7405                 | push                ebp
            //   e8????????           |                     
            //   ba01000000           | inc                 ecx

        $sequence_88 = { 33d2 ff15???????? 483bc3 4c8be8 }
            // n = 4, score = 1100
            //   33d2                 | mov                 dword ptr [esi], ebp
            //   ff15????????         |                     
            //   483bc3               | jmp                 9
            //   4c8be8               | xor                 ebx, ebx

        $sequence_89 = { 85d2 4d8bf1 458bf8 8bc2 }
            // n = 4, score = 1100
            //   85d2                 | xor                 ebx, ebx
            //   4d8bf1               | mov                 dx, 0x20
            //   458bf8               | dec                 ecx
            //   8bc2                 | mov                 ecx, esp

        $sequence_90 = { 50 57 e8???????? e9???????? 68???????? }
            // n = 5, score = 1100
            //   50                   | push                eax
            //   57                   | push                edi
            //   e8????????           |                     
            //   e9????????           |                     
            //   68????????           |                     

        $sequence_91 = { c9 c20400 51 56 ff74240c }
            // n = 5, score = 1100
            //   c9                   | leave               
            //   c20400               | ret                 4
            //   51                   | push                ecx
            //   56                   | push                esi
            //   ff74240c             | push                dword ptr [esp + 0xc]

        $sequence_92 = { 8a4b1c 488b4558 4c8b4d30 4c8b4510 }
            // n = 4, score = 1100
            //   8a4b1c               | jmp                 0x11
            //   488b4558             | add                 ebx, 1
            //   4c8b4d30             | dec                 ecx
            //   4c8b4510             | mov                 ecx, esp

        $sequence_93 = { e8???????? 8d45fc 50 8b4508 e8???????? 85c0 }
            // n = 6, score = 1100
            //   e8????????           |                     
            //   8d45fc               | xor                 edx, edx
            //   50                   | dec                 eax
            //   8b4508               | lea                 ecx, [ebx + eax*8]
            //   e8????????           |                     
            //   85c0                 | xor                 edx, edx

        $sequence_94 = { 33d2 498bcc 498bfd e8???????? 493bc5 7405 }
            // n = 6, score = 1100
            //   33d2                 | dec                 eax
            //   498bcc               | cmp                 ebx, edi
            //   498bfd               | jne                 0xf
            //   e8????????           |                     
            //   493bc5               | dec                 esp
            //   7405                 | mov                 eax, ebx

        $sequence_95 = { 33d2 ff15???????? 8b05???????? 418bdd }
            // n = 4, score = 1100
            //   33d2                 | mov                 esi, 1
            //   ff15????????         |                     
            //   8b05????????         |                     
            //   418bdd               | mov                 eax, esi

        $sequence_96 = { 410fb64101 33d2 488d0cc3 48890d???????? }
            // n = 4, score = 1100
            //   410fb64101           | and                 dword ptr [ebp - 8], 0
            //   33d2                 | push                edi
            //   488d0cc3             | lea                 eax, [ebp - 8]
            //   48890d????????       |                     

        $sequence_97 = { 6a00 ff35???????? ff15???????? 33db 6a01 e8???????? }
            // n = 6, score = 1100
            //   6a00                 | cmova               eax, dword ptr [ebx + 8]
            //   ff35????????         |                     
            //   ff15????????         |                     
            //   33db                 | inc                 ecx
            //   6a01                 | movzx               eax, byte ptr [ecx + 3]
            //   e8????????           |                     

        $sequence_98 = { 448be8 418b4310 41394308 410f474308 }
            // n = 4, score = 1100
            //   448be8               | push                ebx
            //   418b4310             | mov                 ebx, 0xea60
            //   41394308             | push                ebx
            //   410f474308           | jne                 7

        $sequence_99 = { 48890d???????? 410fb64102 488d0cc3 48890d???????? }
            // n = 4, score = 1100
            //   48890d????????       |                     
            //   410fb64102           | push                dword ptr [ebp + 8]
            //   488d0cc3             | push                ebx
            //   48890d????????       |                     

        $sequence_100 = { 488bce ff15???????? 488b0d???????? 33d2 4c63c0 }
            // n = 5, score = 1100
            //   488bce               | push                esi
            //   ff15????????         |                     
            //   488b0d????????       |                     
            //   33d2                 | pop                 ebx
            //   4c63c0               | push                dword ptr [ebp + 0xc]

        $sequence_101 = { c3 418bd8 4803df 410fb64101 }
            // n = 4, score = 1100
            //   c3                   | ret                 4
            //   418bd8               | push                ebp
            //   4803df               | mov                 ebp, esp
            //   410fb64101           | sub                 esp, 0xc

        $sequence_102 = { 48890d???????? 410fb64103 488d0cc3 48890d???????? }
            // n = 4, score = 1100
            //   48890d????????       |                     
            //   410fb64103           | push                ebx
            //   488d0cc3             | mov                 ebx, 0xea60
            //   48890d????????       |                     

        $sequence_103 = { 33db 895d08 eb03 8b5d08 }
            // n = 4, score = 1100
            //   33db                 | xor                 ebx, ebx
            //   895d08               | mov                 dword ptr [ebp + 8], ebx
            //   eb03                 | jmp                 5
            //   8b5d08               | mov                 ebx, dword ptr [ebp + 8]

        $sequence_104 = { 5b c3 a1???????? 83c040 50 ff15???????? }
            // n = 6, score = 1000
            //   5b                   | dec                 eax
            //   c3                   | mov                 dword ptr [esi], ebp
            //   a1????????           |                     
            //   83c040               | xor                 ebx, ebx
            //   50                   | mov                 dx, 0x20
            //   ff15????????         |                     

        $sequence_105 = { 33442410 8bf0 8932 83c204 ff4c240c 75e6 }
            // n = 6, score = 1000
            //   33442410             | xor                 eax, dword ptr [esp + 0x10]
            //   8bf0                 | mov                 esi, eax
            //   8932                 | mov                 dword ptr [edx], esi
            //   83c204               | add                 edx, 4
            //   ff4c240c             | dec                 dword ptr [esp + 0xc]
            //   75e6                 | jne                 0xffffffe8

        $sequence_106 = { 8bf1 05fefeffff 33db 33c9 }
            // n = 4, score = 1000
            //   8bf1                 | mov                 dword ptr [eax], esi
            //   05fefeffff           | jmp                 0x3a
            //   33db                 | push                0
            //   33c9                 | mov                 eax, dword ptr [ebp + 0xc]

        $sequence_107 = { ff15???????? 8ac3 5b c9 c20400 53 }
            // n = 6, score = 1000
            //   ff15????????         |                     
            //   8ac3                 | mov                 dword ptr [ebp + ebx*8], esp
            //   5b                   | add                 ebx, 1
            //   c9                   | dec                 eax
            //   c20400               | test                edi, edi
            //   53                   | dec                 esp

        $sequence_108 = { 0f8386000000 488b18 8364245800 33c0 21442450 }
            // n = 5, score = 1000
            //   0f8386000000         | xor                 eax, eax
            //   488b18               | cmp                 eax, edi
            //   8364245800           | je                  0x21
            //   33c0                 | push                eax
            //   21442450             | xor                 eax, eax

        $sequence_109 = { 53 53 53 53 ff7614 }
            // n = 5, score = 1000
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   ff7614               | push                dword ptr [esi + 0x14]

        $sequence_110 = { 8b02 43 8acb d3c0 33c6 33442410 8bf0 }
            // n = 7, score = 1000
            //   8b02                 | mov                 eax, dword ptr [edx]
            //   43                   | inc                 ebx
            //   8acb                 | mov                 cl, bl
            //   d3c0                 | rol                 eax, cl
            //   33c6                 | xor                 eax, esi
            //   33442410             | xor                 eax, dword ptr [esp + 0x10]
            //   8bf0                 | mov                 esi, eax

        $sequence_111 = { 8b3d???????? 56 ffd7 53 56 }
            // n = 5, score = 1000
            //   8b3d????????         |                     
            //   56                   | dec                 eax
            //   ffd7                 | test                eax, eax
            //   53                   | dec                 esp
            //   56                   | mov                 dword ptr [ebp + ebx*8], esp

        $sequence_112 = { c9 c20400 53 56 8bf0 8a06 }
            // n = 6, score = 1000
            //   c9                   | jmp                 7
            //   c20400               | xor                 ebx, ebx
            //   53                   | mov                 byte ptr [esi + 8], bl
            //   56                   | xor                 edx, edx
            //   8bf0                 | inc                 ecx
            //   8a06                 | shl                 eax, 3

        $sequence_113 = { 83c204 ff4c240c 75e6 5e 5b c20800 }
            // n = 6, score = 1000
            //   83c204               | add                 edx, 4
            //   ff4c240c             | dec                 dword ptr [esp + 0xc]
            //   75e6                 | jne                 0xffffffe8
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   c20800               | ret                 8

        $sequence_114 = { 41b905000000 488bd8 ff15???????? 488bcb }
            // n = 4, score = 900
            //   41b905000000         | dec                 esp
            //   488bd8               | mov                 eax, edi
            //   ff15????????         |                     
            //   488bcb               | dec                 eax

        $sequence_115 = { 741d 3dd2100000 7416 a1???????? 83c004 }
            // n = 5, score = 900
            //   741d                 | dec                 eax
            //   3dd2100000           | lea                 ecx, [eax + 1]
            //   7416                 | mov                 ebx, 1
            //   a1????????           |                     
            //   83c004               | dec                 ecx

        $sequence_116 = { 6a00 ff35???????? ffd3 8bd8 85db 7476 }
            // n = 6, score = 900
            //   6a00                 | dec                 eax
            //   ff35????????         |                     
            //   ffd3                 | test                eax, eax
            //   8bd8                 | dec                 eax
            //   85db                 | mov                 ebp, eax
            //   7476                 | je                  0x5f

        $sequence_117 = { 754f 488d4c246c 66ba2e00 ff15???????? 488bf0 }
            // n = 5, score = 900
            //   754f                 | mov                 byte ptr [esi + 8], bl
            //   488d4c246c           | mov                 ebx, 1
            //   66ba2e00             | dec                 ecx
            //   ff15????????         |                     
            //   488bf0               | mov                 ecx, esp

        $sequence_118 = { e9???????? 33c9 bb26040000 48870d???????? 4885c9 }
            // n = 5, score = 900
            //   e9????????           |                     
            //   33c9                 | mov                 ebx, eax
            //   bb26040000           | dec                 esp
            //   48870d????????       |                     
            //   4885c9               | mov                 eax, edi

        $sequence_119 = { 488bce ff15???????? 4c8d4c2450 4c8d442458 }
            // n = 4, score = 900
            //   488bce               | push                esi
            //   ff15????????         |                     
            //   4c8d4c2450           | pop                 ebx
            //   4c8d442458           | push                ebx

        $sequence_120 = { ff15???????? 488d542440 488bcd ff15???????? 4883f8ff 4c8be0 }
            // n = 6, score = 900
            //   ff15????????         |                     
            //   488d542440           | add                 ebx, 1
            //   488bcd               | dec                 eax
            //   ff15????????         |                     
            //   4883f8ff             | test                edi, edi
            //   4c8be0               | dec                 esp

        $sequence_121 = { 33d2 ff15???????? 33ff 4885ff }
            // n = 4, score = 900
            //   33d2                 | push                ebx
            //   ff15????????         |                     
            //   33ff                 | cmp                 edi, esi
            //   4885ff               | push                edi

        $sequence_122 = { 4c8d442458 8d5001 488bce e8???????? 85c0 }
            // n = 5, score = 900
            //   4c8d442458           | push                dword ptr [ebp + 0xc]
            //   8d5001               | push                ebx
            //   488bce               | cmp                 edi, esi
            //   e8????????           |                     
            //   85c0                 | cmp                 edi, esi

        $sequence_123 = { 4533c9 4889442428 215c2420 4533c0 }
            // n = 4, score = 900
            //   4533c9               | mov                 ebx, eax
            //   4889442428           | jne                 0xc
            //   215c2420             | dec                 eax
            //   4533c0               | mov                 ecx, edi

        $sequence_124 = { ff15???????? 488bf0 488d44246c 2bf0 443bf3 8bc3 7408 }
            // n = 7, score = 900
            //   ff15????????         |                     
            //   488bf0               | dec                 eax
            //   488d44246c           | lea                 ecx, [eax + 1]
            //   2bf0                 | inc                 esp
            //   443bf3               | mov                 eax, ebx
            //   8bc3                 | xor                 edx, edx
            //   7408                 | inc                 ecx

        $sequence_125 = { 8d442430 50 8d442428 50 8d442428 50 }
            // n = 6, score = 900
            //   8d442430             | mov                 dx, 0x20
            //   50                   | dec                 ecx
            //   8d442428             | mov                 ecx, esp
            //   50                   | mov                 byte ptr [eax], 0
            //   8d442428             | dec                 eax
            //   50                   | mov                 ecx, edi

        $sequence_126 = { 4883f8ff 4c8be0 0f8583000000 488b0d???????? }
            // n = 4, score = 900
            //   4883f8ff             | dec                 ecx
            //   4c8be0               | mov                 ecx, esp
            //   0f8583000000         | dec                 eax
            //   488b0d????????       |                     

        $sequence_127 = { 488bd6 ff15???????? eb14 488b0d???????? }
            // n = 4, score = 900
            //   488bd6               | je                  0x10
            //   ff15????????         |                     
            //   eb14                 | push                edi
            //   488b0d????????       |                     

        $sequence_128 = { 3bc3 7fbd 83c701 e9???????? 488b8424c8010000 498bcc bb01000000 }
            // n = 7, score = 900
            //   3bc3                 | mov                 dx, 0x20
            //   7fbd                 | xor                 ebx, ebx
            //   83c701               | mov                 dx, 0x20
            //   e9????????           |                     
            //   488b8424c8010000     | dec                 ecx
            //   498bcc               | mov                 ecx, esp
            //   bb01000000           | dec                 eax

        $sequence_129 = { 458be0 bb08000000 e8???????? 85c0 }
            // n = 4, score = 900
            //   458be0               | dec                 eax
            //   bb08000000           | mov                 ecx, edi
            //   e8????????           |                     
            //   85c0                 | mov                 ebx, eax

        $sequence_130 = { b922010000 e9???????? b90a010000 e9???????? }
            // n = 4, score = 800
            //   b922010000           | push                eax
            //   e9????????           |                     
            //   b90a010000           | mov                 edx, edi
            //   e9????????           |                     

        $sequence_131 = { 53 56 8bf1 05fefeffff }
            // n = 4, score = 800
            //   53                   | je                  0x10
            //   56                   | push                dword ptr [ebp + 8]
            //   8bf1                 | test                edi, edi
            //   05fefeffff           | jne                 0x10

        $sequence_132 = { 215c2420 4533c9 4533c0 33d2 ff15???????? 85c0 7511 }
            // n = 7, score = 800
            //   215c2420             | add                 eax, 0xc
            //   4533c9               | dec                 esp
            //   4533c0               | arpl                ax, ax
            //   33d2                 | xor                 edx, edx
            //   ff15????????         |                     
            //   85c0                 | dec                 ecx
            //   7511                 | add                 eax, 0xc

        $sequence_133 = { 803f2a 750b 4883c701 83c3ff }
            // n = 4, score = 800
            //   803f2a               | cmovne              ecx, eax
            //   750b                 | dec                 eax
            //   4883c701             | mov                 dword ptr [esp + 0x20], ebx
            //   83c3ff               | test                eax, eax

        $sequence_134 = { e9???????? 488bcb ff15???????? a810 }
            // n = 4, score = 800
            //   e9????????           |                     
            //   488bcb               | add                 eax, 0xc
            //   ff15????????         |                     
            //   a810                 | dec                 esp

        $sequence_135 = { 458bc4 418bcd e8???????? e9???????? b909010000 e9???????? }
            // n = 6, score = 800
            //   458bc4               | je                  0x18
            //   418bcd               | push                eax
            //   e8????????           |                     
            //   e9????????           |                     
            //   b909010000           | mov                 edx, edi
            //   e9????????           |                     

        $sequence_136 = { 488bc8 ff15???????? 8b05???????? 3d2caedb8b }
            // n = 4, score = 800
            //   488bc8               | cmp                 eax, ebx
            //   ff15????????         |                     
            //   8b05????????         |                     
            //   3d2caedb8b           | je                  0x23

        $sequence_137 = { a1???????? 25efff0000 0bc2 e9???????? }
            // n = 4, score = 800
            //   a1????????           |                     
            //   25efff0000           | and                 eax, 0xffef
            //   0bc2                 | or                  eax, edx
            //   e9????????           |                     

        $sequence_138 = { 41be01000000 33c9 418bd6 ff15???????? }
            // n = 4, score = 800
            //   41be01000000         | inc                 ebp
            //   33c9                 | xor                 ecx, ecx
            //   418bd6               | inc                 ebp
            //   ff15????????         |                     

        $sequence_139 = { 4c63c0 33d2 4983c00c ff15???????? }
            // n = 4, score = 800
            //   4c63c0               | dec                 eax
            //   33d2                 | add                 esp, 0x40
            //   4983c00c             | inc                 ecx
            //   ff15????????         |                     

        $sequence_140 = { 895df4 895df0 c745f857000000 bf19010000 }
            // n = 4, score = 800
            //   895df4               | cmp                 dword ptr [ebp + 8], 0
            //   895df0               | je                  0xa
            //   c745f857000000       | push                dword ptr [ebp + 8]
            //   bf19010000           | mov                 eax, edi

        $sequence_141 = { 7520 41390424 741a 498d4c2401 }
            // n = 4, score = 800
            //   7520                 | je                  0x13
            //   41390424             | push                eax
            //   741a                 | push                esi
            //   498d4c2401           | mov                 dword ptr [ebp - 8], eax

        $sequence_142 = { ff15???????? 488b0d???????? 448bc0 8bd8 33d2 4983c001 }
            // n = 6, score = 800
            //   ff15????????         |                     
            //   488b0d????????       |                     
            //   448bc0               | mov                 dword ptr [esp + 0x28], 0xea60
            //   8bd8                 | dec                 esp
            //   33d2                 | cmovne              ecx, eax
            //   4983c001             | dec                 eax

        $sequence_143 = { 6a03 8935???????? 8935???????? 8935???????? }
            // n = 4, score = 800
            //   6a03                 | push                3
            //   8935????????         |                     
            //   8935????????         |                     
            //   8935????????         |                     

        $sequence_144 = { 5f c20400 55 8bec 83e4f8 81ec9c000000 }
            // n = 6, score = 700
            //   5f                   | xor                 ecx, ecx
            //   c20400               | push                ebx
            //   55                   | push                esi
            //   8bec                 | mov                 esi, ecx
            //   83e4f8               | add                 eax, 0xfffffefe
            //   81ec9c000000         | push                ebx

        $sequence_145 = { 53 8bc7 e8???????? 8d4618 8b08 50 }
            // n = 6, score = 700
            //   53                   | push                ebx
            //   8bc7                 | mov                 eax, edi
            //   e8????????           |                     
            //   8d4618               | lea                 eax, [esi + 0x18]
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   50                   | push                eax

        $sequence_146 = { 5e 33c0 c9 c20400 55 8bec 51 }
            // n = 7, score = 700
            //   5e                   | add                 eax, 0xfffffefe
            //   33c0                 | xor                 ebx, ebx
            //   c9                   | xor                 ecx, ecx
            //   c20400               | push                esi
            //   55                   | mov                 esi, ecx
            //   8bec                 | add                 eax, 0xfffffefe
            //   51                   | xor                 ebx, ebx

        $sequence_147 = { 44892d???????? e9???????? 4533c0 33d2 33c9 e8???????? e9???????? }
            // n = 7, score = 700
            //   44892d????????       |                     
            //   e9????????           |                     
            //   4533c0               | push                eax
            //   33d2                 | add                 esi, 4
            //   33c9                 | cmp                 edi, ebx
            //   e8????????           |                     
            //   e9????????           |                     

        $sequence_148 = { 750a 488bcf e8???????? 8bd8 488b0d???????? }
            // n = 5, score = 700
            //   750a                 | mov                 esi, 1
            //   488bcf               | xor                 ecx, ecx
            //   e8????????           |                     
            //   8bd8                 | inc                 ecx
            //   488b0d????????       |                     

        $sequence_149 = { 488d542438 488bcb e8???????? eb02 }
            // n = 4, score = 700
            //   488d542438           | mov                 edx, edi
            //   488bcb               | jmp                 6
            //   e8????????           |                     
            //   eb02                 | xor                 eax, eax

        $sequence_150 = { 57 4154 4155 4156 4883ec50 488bf1 }
            // n = 6, score = 700
            //   57                   | inc                 ebp
            //   4154                 | xor                 eax, eax
            //   4155                 | xor                 edx, edx
            //   4156                 | and                 dword ptr [esp + 0x20], ebx
            //   4883ec50             | inc                 ebp
            //   488bf1               | xor                 ecx, ecx

        $sequence_151 = { ff7508 8bc6 e8???????? 8b06 8b08 57 }
            // n = 6, score = 700
            //   ff7508               | mov                 eax, esi
            //   8bc6                 | test                eax, eax
            //   e8????????           |                     
            //   8b06                 | jne                 0x1d
            //   8b08                 | jne                 0x10
            //   57                   | cmp                 dword ptr [ebp + 8], 0

        $sequence_152 = { 488b0d???????? 4889040f 4883c708 492bf6 }
            // n = 4, score = 700
            //   488b0d????????       |                     
            //   4889040f             | inc                 ecx
            //   4883c708             | mov                 edx, esi
            //   492bf6               | push                edi

        $sequence_153 = { 6a20 40 50 ffd6 }
            // n = 4, score = 700
            //   6a20                 | mov                 dword ptr [ebp - 8], 0x57
            //   40                   | push                ebx
            //   50                   | push                esi
            //   ffd6                 | mov                 esi, ecx

        $sequence_154 = { 488bcb ff15???????? 8bc8 ff15???????? 21b42410020000 }
            // n = 5, score = 600
            //   488bcb               | je                  0xea
            //   ff15????????         |                     
            //   8bc8                 | mov                 esi, dword ptr [ebx + 0x34]
            //   ff15????????         |                     
            //   21b42410020000       | lea                 eax, [esp + 0x18]

        $sequence_155 = { c3 488d82204a0000 488982284a0000 488900 }
            // n = 4, score = 600
            //   c3                   | mov                 ebx, edi
            //   488d82204a0000       | mov                 esi, edi
            //   488982284a0000       | dec                 eax
            //   488900               | cmp                 ebx, edi

        $sequence_156 = { 458bc4 418bcd e8???????? 8b842410020000 4c8d9c24f0010000 498b5b28 }
            // n = 6, score = 600
            //   458bc4               | pop                 eax
            //   418bcd               | cmp                 eax, edi
            //   e8????????           |                     
            //   8b842410020000       | pop                 eax
            //   4c8d9c24f0010000     | cmp                 eax, edi
            //   498b5b28             | je                  8

        $sequence_157 = { 21442428 488b8c2428020000 488364242000 448d4803 4533c0 488bd3 }
            // n = 6, score = 600
            //   21442428             | push                eax
            //   488b8c2428020000     | push                esi
            //   488364242000         | call                dword ptr [edx + 0x14]
            //   448d4803             | mov                 esi, edi
            //   4533c0               | mov                 edi, esi
            //   488bd3               | pop                 edi

        $sequence_158 = { 33d2 ff15???????? 83bc241002000000 7416 488d942410020000 }
            // n = 5, score = 600
            //   33d2                 | push                0x10
            //   ff15????????         |                     
            //   83bc241002000000     | pop                 eax
            //   7416                 | cmp                 eax, edi
            //   488d942410020000     | je                  0xe

        $sequence_159 = { 7424 3d5c80689f 740c 44892d???????? e9???????? }
            // n = 5, score = 600
            //   7424                 | je                  0x18
            //   3d5c80689f           | cmp                 eax, edi
            //   740c                 | je                  0x1d
            //   44892d????????       |                     
            //   e9????????           |                     

        $sequence_160 = { 7417 4863461c 2b6e1c 4c03e8 488b4610 48894718 4883661000 }
            // n = 7, score = 600
            //   7417                 | call                dword ptr [edx + 0x14]
            //   4863461c             | mov                 esi, edi
            //   2b6e1c               | mov                 edi, esi
            //   4c03e8               | pop                 edi
            //   488b4610             | pop                 esi
            //   48894718             | pop                 ebx
            //   4883661000           | mov                 esp, ebp

        $sequence_161 = { 7412 ff7508 e8???????? eb03 33c0 }
            // n = 5, score = 600
            //   7412                 | lea                 eax, [esi + 0x18]
            //   ff7508               | mov                 ecx, dword ptr [eax]
            //   e8????????           |                     
            //   eb03                 | push                eax
            //   33c0                 | push                dword ptr [ebp + 8]

        $sequence_162 = { 33ed 57 3bc5 740c }
            // n = 4, score = 600
            //   33ed                 | mov                 eax, esi
            //   57                   | mov                 eax, dword ptr [esi]
            //   3bc5                 | mov                 ecx, dword ptr [eax]
            //   740c                 | push                edi

        $sequence_163 = { 7405 e8???????? 4883c428 c3 488d82204a0000 }
            // n = 5, score = 600
            //   7405                 | dec                 esp
            //   e8????????           |                     
            //   4883c428             | cmovne              ecx, eax
            //   c3                   | dec                 eax
            //   488d82204a0000       | mov                 dword ptr [esp + 0x20], ebx

        $sequence_164 = { 4155 4881ecf0010000 33f6 33c0 }
            // n = 4, score = 600
            //   4155                 | mov                 eax, dword ptr [ebx + 0x30]
            //   4881ecf0010000       | test                al, 0x40
            //   33f6                 | je                  0xea
            //   33c0                 | mov                 esi, dword ptr [ebx + 0x34]

        $sequence_165 = { 4533c0 488bd3 ff15???????? 488b8c2428020000 }
            // n = 4, score = 600
            //   4533c0               | mov                 eax, dword ptr [ebx + 0x30]
            //   488bd3               | test                al, 0x40
            //   ff15????????         |                     
            //   488b8c2428020000     | je                  0xea

        $sequence_166 = { e8???????? 85c0 0f85e8000000 488b4608 488b0e 4533c9 }
            // n = 6, score = 500
            //   e8????????           |                     
            //   85c0                 | shl                 eax, 3
            //   0f85e8000000         | dec                 eax
            //   488b4608             | test                eax, eax
            //   488b0e               | dec                 eax
            //   4533c9               | mov                 ebp, eax

        $sequence_167 = { e8???????? 488b0d???????? 4c8bc3 33d2 ff15???????? 488b0d???????? 4c8bc7 }
            // n = 7, score = 500
            //   e8????????           |                     
            //   488b0d????????       |                     
            //   4c8bc3               | mov                 eax, dword ptr [esp + 0x40]
            //   33d2                 | dec                 eax
            //   ff15????????         |                     
            //   488b0d????????       |                     
            //   4c8bc7               | mov                 edx, dword ptr [esp + 0x48]

        $sequence_168 = { 84c0 0f89a3000000 8b434c a804 }
            // n = 4, score = 500
            //   84c0                 | inc                 esp
            //   0f89a3000000         | mov                 eax, ebx
            //   8b434c               | xor                 edx, edx
            //   a804                 | inc                 ecx

        $sequence_169 = { 488d4c2430 448bcf 4533c0 e8???????? 483bc3 488905???????? 0f8403010000 }
            // n = 7, score = 500
            //   488d4c2430           | mov                 dword ptr [esp + 0x30], ecx
            //   448bcf               | mov                 ecx, dword ptr [esp + 0x90]
            //   4533c0               | cmp                 dword ptr [esp + 0x88], 0
            //   e8????????           |                     
            //   483bc3               | dec                 esp
            //   488905????????       |                     
            //   0f8403010000         | mov                 eax, dword ptr [esp + 0x40]

        $sequence_170 = { 85c0 0f8561010000 8b4348 a801 742c 488b0b }
            // n = 6, score = 500
            //   85c0                 | pop                 eax
            //   0f8561010000         | cmp                 eax, edi
            //   8b4348               | xor                 eax, eax
            //   a801                 | cmp                 eax, edi
            //   742c                 | je                  0x17
            //   488b0b               | push                eax

        $sequence_171 = { e8???????? 85c0 0f859b000000 4863533c 488b4608 488b0e 48035334 }
            // n = 7, score = 500
            //   e8????????           |                     
            //   85c0                 | push                eax
            //   0f859b000000         | push                0x10
            //   4863533c             | pop                 eax
            //   488b4608             | je                  0x15
            //   488b0e               | push                eax
            //   48035334             | push                0x10

        $sequence_172 = { 33d2 33c9 e8???????? 85c0 0f8561010000 8b4348 }
            // n = 6, score = 500
            //   33d2                 | cmp                 eax, edi
            //   33c9                 | je                  0x19
            //   e8????????           |                     
            //   85c0                 | cmp                 eax, edi
            //   0f8561010000         | je                  0x15
            //   8b4348               | push                eax

        $sequence_173 = { 217b3c eb0b 8b434c 84c0 0f89a3000000 }
            // n = 5, score = 500
            //   217b3c               | je                  0x1d
            //   eb0b                 | push                eax
            //   8b434c               | xor                 eax, eax
            //   84c0                 | jmp                 4
            //   0f89a3000000         | xor                 eax, eax

        $sequence_174 = { ffc1 807c043000 7531 8bd3 }
            // n = 4, score = 500
            //   ffc1                 | inc                 ecx
            //   807c043000           | push                ebp
            //   7531                 | inc                 ecx
            //   8bd3                 | push                esi

        $sequence_175 = { ba10000000 488bc8 e8???????? 48898424e0010000 }
            // n = 4, score = 400
            //   ba10000000           | add                 esp, 0x40
            //   488bc8               | mov                 esi, 1
            //   e8????????           |                     
            //   48898424e0010000     | mov                 eax, esi

        $sequence_176 = { 488bf8 4885c0 7427 488d542420 }
            // n = 4, score = 400
            //   488bf8               | pop                 esi
            //   4885c0               | mov                 esi, 1
            //   7427                 | mov                 eax, esi
            //   488d542420           | dec                 eax

        $sequence_177 = { 8bd8 85c0 0f85f3010000 4c8b842418020000 8d5808 488d8c24b0000000 }
            // n = 6, score = 400
            //   8bd8                 | dec                 eax
            //   85c0                 | mov                 ebx, edi
            //   0f85f3010000         | mov                 esi, edi
            //   4c8b842418020000     | dec                 eax
            //   8d5808               | cmp                 ebx, edi
            //   488d8c24b0000000     | dec                 esp

        $sequence_178 = { 488d542420 b901020000 ff15???????? 85c0 }
            // n = 4, score = 400
            //   488d542420           | dec                 eax
            //   b901020000           | add                 esp, 0x40
            //   ff15????????         |                     
            //   85c0                 | inc                 ecx

        $sequence_179 = { 488bcd 89442428 488b842410020000 4889442420 e8???????? 8bd8 }
            // n = 6, score = 400
            //   488bcd               | mov                 ebx, edi
            //   89442428             | mov                 esi, edi
            //   488b842410020000     | dec                 eax
            //   4889442420           | cmp                 ebx, edi
            //   e8????????           |                     
            //   8bd8                 | jne                 0xf

        $sequence_180 = { 488d542448 488bc8 458bf9 33ff e8???????? 4c8be8 4885c0 }
            // n = 7, score = 400
            //   488d542448           | mov                 eax, ebx
            //   488bc8               | xor                 edx, edx
            //   458bf9               | dec                 eax
            //   33ff                 | mov                 ebx, edi
            //   e8????????           |                     
            //   4c8be8               | mov                 esi, edi
            //   4885c0               | dec                 eax

        $sequence_181 = { 4c89642448 ff15???????? 8bd8 83f8ff }
            // n = 4, score = 400
            //   4c89642448           | mov                 esi, 1
            //   ff15????????         |                     
            //   8bd8                 | mov                 eax, esi
            //   83f8ff               | dec                 eax

        $sequence_182 = { 4c8be8 4885c0 7508 8d5f08 e9???????? 8b842420020000 4c8b442440 }
            // n = 7, score = 400
            //   4c8be8               | dec                 eax
            //   4885c0               | mov                 ebx, edi
            //   7508                 | mov                 esi, edi
            //   8d5f08               | dec                 eax
            //   e9????????           |                     
            //   8b842420020000       | cmp                 ebx, edi
            //   4c8b442440           | jne                 0x12

        $sequence_183 = { 7451 0fb70b 0fb76b02 0fb7d1 01f2 6683f9ff 896c2428 }
            // n = 7, score = 300
            //   7451                 | dec                 eax
            //   0fb70b               | lea                 ecx, [ebx + eax*8]
            //   0fb76b02             | xor                 edx, edx
            //   0fb7d1               | dec                 eax
            //   01f2                 | test                ebx, ebx
            //   6683f9ff             | je                  0x11
            //   896c2428             | dec                 eax

        $sequence_184 = { 896c2428 7508 8b5304 83c304 01f2 8b4c241c }
            // n = 6, score = 300
            //   896c2428             | lea                 ecx, [ebx + eax*8]
            //   7508                 | inc                 ecx
            //   8b5304               | movzx               eax, byte ptr [ecx + 2]
            //   83c304               | dec                 eax
            //   01f2                 | lea                 ecx, [ebx + eax*8]
            //   8b4c241c             | dec                 eax

        $sequence_185 = { 40 c1ca08 e2e4 c9 c20c00 83ec10 53 }
            // n = 7, score = 300
            //   40                   | movzx               eax, byte ptr [ecx + 3]
            //   c1ca08               | dec                 eax
            //   e2e4                 | lea                 ecx, [ebx + eax*8]
            //   c9                   | dec                 eax
            //   c20c00               | lea                 ecx, [ebx + eax*8]
            //   83ec10               | inc                 ecx
            //   53                   | movzx               eax, byte ptr [ecx + 3]

        $sequence_186 = { 0fb6ca 01cb 30c9 eb59 8b4c242c 0fb6d0 01d1 }
            // n = 7, score = 300
            //   0fb6ca               | add                 ebx, edi
            //   01cb                 | inc                 ecx
            //   30c9                 | movzx               eax, byte ptr [ecx + 1]
            //   eb59                 | xor                 edx, edx
            //   8b4c242c             | dec                 eax
            //   0fb6d0               | lea                 ecx, [ebx + eax*8]
            //   01d1                 | inc                 ecx

        $sequence_187 = { 56 90 57 51 8b742420 8b7c241c }
            // n = 6, score = 300
            //   56                   | dec                 eax
            //   90                   | lea                 ecx, [ebx + eax*8]
            //   57                   | inc                 ecx
            //   51                   | movzx               eax, byte ptr [ecx + 3]
            //   8b742420             | dec                 eax
            //   8b7c241c             | lea                 ecx, [ebx + eax*8]

        $sequence_188 = { 56 57 51 90 8b742428 8b7c2424 8b4c2420 }
            // n = 7, score = 300
            //   56                   | dec                 eax
            //   57                   | lea                 ecx, [ebx + eax*8]
            //   51                   | inc                 ecx
            //   90                   | movzx               eax, byte ptr [ecx + 2]
            //   8b742428             | dec                 eax
            //   8b7c2424             | lea                 ecx, [ebx + eax*8]
            //   8b4c2420             | inc                 ecx

        $sequence_189 = { 01d5 01d3 b101 3b5c2428 0f8266ffffff }
            // n = 5, score = 300
            //   01d5                 | movzx               eax, byte ptr [ecx + 1]
            //   01d3                 | xor                 edx, edx
            //   b101                 | dec                 eax
            //   3b5c2428             | lea                 ecx, [ebx + eax*8]
            //   0f8266ffffff         | inc                 ecx

        $sequence_190 = { 83e603 750c 8b5d10 6601da }
            // n = 4, score = 300
            //   83e603               | movzx               eax, byte ptr [ecx + 2]
            //   750c                 | dec                 eax
            //   8b5d10               | lea                 ecx, [ebx + eax*8]
            //   6601da               | inc                 ecx

    condition:
        7 of them and filesize < 2940928
}