rule win_kagent_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.kagent."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.kagent"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d45f4 64a300000000 8bf9 833d????????00 7516 32c0 8b4df4 }
            // n = 7, score = 400
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   64a300000000         | mov                 dword ptr fs:[0], eax
            //   8bf9                 | mov                 edi, ecx
            //   833d????????00       |                     
            //   7516                 | jne                 0x18
            //   32c0                 | xor                 al, al
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]

        $sequence_1 = { 50 e8???????? 83c404 897e40 8b4604 3bc7 }
            // n = 6, score = 400
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   897e40               | mov                 dword ptr [esi + 0x40], edi
            //   8b4604               | mov                 eax, dword ptr [esi + 4]
            //   3bc7                 | cmp                 eax, edi

        $sequence_2 = { 8bcb e8???????? 8343180c 33c0 33f6 3903 }
            // n = 6, score = 400
            //   8bcb                 | mov                 ecx, ebx
            //   e8????????           |                     
            //   8343180c             | add                 dword ptr [ebx + 0x18], 0xc
            //   33c0                 | xor                 eax, eax
            //   33f6                 | xor                 esi, esi
            //   3903                 | cmp                 dword ptr [ebx], eax

        $sequence_3 = { 50 50 52 e8???????? 8b45ec 50 }
            // n = 6, score = 400
            //   50                   | push                eax
            //   50                   | push                eax
            //   52                   | push                edx
            //   e8????????           |                     
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   50                   | push                eax

        $sequence_4 = { 8bcf ffd2 8b4508 5f 895e04 8906 5b }
            // n = 7, score = 400
            //   8bcf                 | mov                 ecx, edi
            //   ffd2                 | call                edx
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   5f                   | pop                 edi
            //   895e04               | mov                 dword ptr [esi + 4], ebx
            //   8906                 | mov                 dword ptr [esi], eax
            //   5b                   | pop                 ebx

        $sequence_5 = { 2bc7 d1f8 8d1442 5f 895614 5e b83f000000 }
            // n = 7, score = 400
            //   2bc7                 | sub                 eax, edi
            //   d1f8                 | sar                 eax, 1
            //   8d1442               | lea                 edx, [edx + eax*2]
            //   5f                   | pop                 edi
            //   895614               | mov                 dword ptr [esi + 0x14], edx
            //   5e                   | pop                 esi
            //   b83f000000           | mov                 eax, 0x3f

        $sequence_6 = { e8???????? 89435c c6436001 8b4b5c }
            // n = 4, score = 400
            //   e8????????           |                     
            //   89435c               | mov                 dword ptr [ebx + 0x5c], eax
            //   c6436001             | mov                 byte ptr [ebx + 0x60], 1
            //   8b4b5c               | mov                 ecx, dword ptr [ebx + 0x5c]

        $sequence_7 = { 83ff3a 0f84b2030000 83ff3b 0f84a9030000 66833857 0f85f9020000 668378023b }
            // n = 7, score = 400
            //   83ff3a               | cmp                 edi, 0x3a
            //   0f84b2030000         | je                  0x3b8
            //   83ff3b               | cmp                 edi, 0x3b
            //   0f84a9030000         | je                  0x3af
            //   66833857             | cmp                 word ptr [eax], 0x57
            //   0f85f9020000         | jne                 0x2ff
            //   668378023b           | cmp                 word ptr [eax + 2], 0x3b

        $sequence_8 = { 2bc8 8bf9 897da4 eb0a c745a400000000 8b7da4 8b5214 }
            // n = 7, score = 400
            //   2bc8                 | sub                 ecx, eax
            //   8bf9                 | mov                 edi, ecx
            //   897da4               | mov                 dword ptr [ebp - 0x5c], edi
            //   eb0a                 | jmp                 0xc
            //   c745a400000000       | mov                 dword ptr [ebp - 0x5c], 0
            //   8b7da4               | mov                 edi, dword ptr [ebp - 0x5c]
            //   8b5214               | mov                 edx, dword ptr [edx + 0x14]

        $sequence_9 = { 8b45f0 83e3fd 85c0 7409 50 e8???????? 83c404 }
            // n = 7, score = 400
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   83e3fd               | and                 ebx, 0xfffffffd
            //   85c0                 | test                eax, eax
            //   7409                 | je                  0xb
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

    condition:
        7 of them and filesize < 4972544
}