rule win_koadic_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.koadic."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.koadic"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 42 895114 e8???????? 8901 833900 7407 8b01 }
            // n = 7, score = 100
            //   42                   | inc                 edx
            //   895114               | mov                 dword ptr [ecx + 0x14], edx
            //   e8????????           |                     
            //   8901                 | mov                 dword ptr [ecx], eax
            //   833900               | cmp                 dword ptr [ecx], 0
            //   7407                 | je                  9
            //   8b01                 | mov                 eax, dword ptr [ecx]

        $sequence_1 = { 7419 0fb608 33ce 81e1ff000000 c1ee08 33348d48154100 40 }
            // n = 7, score = 100
            //   7419                 | je                  0x1b
            //   0fb608               | movzx               ecx, byte ptr [eax]
            //   33ce                 | xor                 ecx, esi
            //   81e1ff000000         | and                 ecx, 0xff
            //   c1ee08               | shr                 esi, 8
            //   33348d48154100       | xor                 esi, dword ptr [ecx*4 + 0x411548]
            //   40                   | inc                 eax

        $sequence_2 = { 83c201 8955f8 8b4508 0fb64801 81e1c0000000 81f980000000 }
            // n = 6, score = 100
            //   83c201               | add                 edx, 1
            //   8955f8               | mov                 dword ptr [ebp - 8], edx
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   0fb64801             | movzx               ecx, byte ptr [eax + 1]
            //   81e1c0000000         | and                 ecx, 0xc0
            //   81f980000000         | cmp                 ecx, 0x80

        $sequence_3 = { 52 8b1401 52 ff15???????? 85c0 0f8e08010000 8b0f }
            // n = 7, score = 100
            //   52                   | push                edx
            //   8b1401               | mov                 edx, dword ptr [ecx + eax]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f8e08010000         | jle                 0x10e
            //   8b0f                 | mov                 ecx, dword ptr [edi]

        $sequence_4 = { 894804 5b 83c40c c3 0f8ed6000000 8bc7 99 }
            // n = 7, score = 100
            //   894804               | mov                 dword ptr [eax + 4], ecx
            //   5b                   | pop                 ebx
            //   83c40c               | add                 esp, 0xc
            //   c3                   | ret                 
            //   0f8ed6000000         | jle                 0xdc
            //   8bc7                 | mov                 eax, edi
            //   99                   | cdq                 

        $sequence_5 = { e8???????? 8b4c2410 5f c6040e00 5e 59 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]
            //   5f                   | pop                 edi
            //   c6040e00             | mov                 byte ptr [esi + ecx], 0
            //   5e                   | pop                 esi
            //   59                   | pop                 ecx

        $sequence_6 = { 58 894514 8b442404 50 58 894518 8d44240c }
            // n = 7, score = 100
            //   58                   | pop                 eax
            //   894514               | mov                 dword ptr [ebp + 0x14], eax
            //   8b442404             | mov                 eax, dword ptr [esp + 4]
            //   50                   | push                eax
            //   58                   | pop                 eax
            //   894518               | mov                 dword ptr [ebp + 0x18], eax
            //   8d44240c             | lea                 eax, [esp + 0xc]

        $sequence_7 = { 3b442404 7c54 ff742404 8b6c2420 }
            // n = 4, score = 100
            //   3b442404             | cmp                 eax, dword ptr [esp + 4]
            //   7c54                 | jl                  0x56
            //   ff742404             | push                dword ptr [esp + 4]
            //   8b6c2420             | mov                 ebp, dword ptr [esp + 0x20]

        $sequence_8 = { 57 8d45f8 50 56 53 ff750c ff15???????? }
            // n = 7, score = 100
            //   57                   | push                edi
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   50                   | push                eax
            //   56                   | push                esi
            //   53                   | push                ebx
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   ff15????????         |                     

        $sequence_9 = { ff15???????? 8bf8 8d5f01 53 6a00 }
            // n = 5, score = 100
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax
            //   8d5f01               | lea                 ebx, [edi + 1]
            //   53                   | push                ebx
            //   6a00                 | push                0

    condition:
        7 of them and filesize < 180224
}