rule win_konni_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.konni."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.konni"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0fb609 0fb6d2 03ca 81e1ff000080 }
            // n = 4, score = 800
            //   0fb609               | movzx               ecx, byte ptr [ecx]
            //   0fb6d2               | movzx               edx, dl
            //   03ca                 | add                 ecx, edx
            //   81e1ff000080         | and                 ecx, 0x800000ff

        $sequence_1 = { 83f801 7508 66c745f50000 eb09 83f802 7504 }
            // n = 6, score = 800
            //   83f801               | cmp                 eax, 1
            //   7508                 | jne                 0xa
            //   66c745f50000         | mov                 word ptr [ebp - 0xb], 0
            //   eb09                 | jmp                 0xb
            //   83f802               | cmp                 eax, 2
            //   7504                 | jne                 6

        $sequence_2 = { 0fbef1 83e601 8970f0 d0f9 0fbef1 }
            // n = 5, score = 800
            //   0fbef1               | movsx               esi, cl
            //   83e601               | and                 esi, 1
            //   8970f0               | mov                 dword ptr [eax - 0x10], esi
            //   d0f9                 | sar                 cl, 1
            //   0fbef1               | movsx               esi, cl

        $sequence_3 = { c745e0f4010000 890d???????? 8815???????? ff15???????? 85c0 7552 }
            // n = 6, score = 800
            //   c745e0f4010000       | mov                 dword ptr [ebp - 0x20], 0x1f4
            //   890d????????         |                     
            //   8815????????         |                     
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7552                 | jne                 0x54

        $sequence_4 = { 83c410 85c0 0f850fffffff 6a3d 68???????? 53 }
            // n = 6, score = 800
            //   83c410               | add                 esp, 0x10
            //   85c0                 | test                eax, eax
            //   0f850fffffff         | jne                 0xffffff15
            //   6a3d                 | push                0x3d
            //   68????????           |                     
            //   53                   | push                ebx

        $sequence_5 = { 8970fc d0f9 0fbef1 83e601 8970f8 }
            // n = 5, score = 800
            //   8970fc               | mov                 dword ptr [eax - 4], esi
            //   d0f9                 | sar                 cl, 1
            //   0fbef1               | movsx               esi, cl
            //   83e601               | and                 esi, 1
            //   8970f8               | mov                 dword ptr [eax - 8], esi

        $sequence_6 = { 81e6ff000080 7908 4e 81ce00ffffff 46 8a9c35f8feffff }
            // n = 6, score = 800
            //   81e6ff000080         | and                 esi, 0x800000ff
            //   7908                 | jns                 0xa
            //   4e                   | dec                 esi
            //   81ce00ffffff         | or                  esi, 0xffffff00
            //   46                   | inc                 esi
            //   8a9c35f8feffff       | mov                 bl, byte ptr [ebp + esi - 0x108]

        $sequence_7 = { 49 81c900ffffff 41 8a940df8feffff 8d8c0df8feffff 0fb6da 03f3 }
            // n = 7, score = 800
            //   49                   | dec                 ecx
            //   81c900ffffff         | or                  ecx, 0xffffff00
            //   41                   | inc                 ecx
            //   8a940df8feffff       | mov                 dl, byte ptr [ebp + ecx - 0x108]
            //   8d8c0df8feffff       | lea                 ecx, [ebp + ecx - 0x108]
            //   0fb6da               | movzx               ebx, dl
            //   03f3                 | add                 esi, ebx

        $sequence_8 = { 83f804 740f c705????????02000000 83f801 750a c705????????01000000 890d???????? }
            // n = 7, score = 500
            //   83f804               | cmp                 eax, 4
            //   740f                 | je                  0x11
            //   c705????????02000000     |     
            //   83f801               | cmp                 eax, 1
            //   750a                 | jne                 0xc
            //   c705????????01000000     |     
            //   890d????????         |                     

        $sequence_9 = { 6a01 ff15???????? 50 a3???????? }
            // n = 4, score = 500
            //   6a01                 | push                1
            //   ff15????????         |                     
            //   50                   | push                eax
            //   a3????????           |                     

        $sequence_10 = { 33c9 83f802 7508 890d???????? eb1e 83f804 }
            // n = 6, score = 500
            //   33c9                 | xor                 ecx, ecx
            //   83f802               | cmp                 eax, 2
            //   7508                 | jne                 0xa
            //   890d????????         |                     
            //   eb1e                 | jmp                 0x20
            //   83f804               | cmp                 eax, 4

        $sequence_11 = { 68b6030000 6a0d 50 ff15???????? }
            // n = 4, score = 500
            //   68b6030000           | push                0x3b6
            //   6a0d                 | push                0xd
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_12 = { 8d4801 eb02 33c9 e8???????? 8bf8 }
            // n = 5, score = 400
            //   8d4801               | cmp                 eax, 1
            //   eb02                 | jne                 0xc
            //   33c9                 | jmp                 0x20
            //   e8????????           |                     
            //   8bf8                 | cmp                 eax, 4

        $sequence_13 = { 8d85eafbffff 33d2 57 50 668995e8fbffff e8???????? 6a40 }
            // n = 7, score = 300
            //   8d85eafbffff         | je                  0x14
            //   33d2                 | cmp                 eax, 1
            //   57                   | je                  0x11
            //   50                   | cmp                 eax, 1
            //   668995e8fbffff       | jne                 0xf
            //   e8????????           |                     
            //   6a40                 | lea                 ecx, [eax + 1]

        $sequence_14 = { 51 e8???????? 83c408 be???????? 85c0 7513 }
            // n = 6, score = 300
            //   51                   | mov                 edi, eax
            //   e8????????           |                     
            //   83c408               | jne                 7
            //   be????????           |                     
            //   85c0                 | lea                 ecx, [eax + 1]
            //   7513                 | jmp                 7

        $sequence_15 = { 8bd9 33ff 8d8df2fdffff 33c0 57 51 668985f0fdffff }
            // n = 7, score = 300
            //   8bd9                 | jmp                 4
            //   33ff                 | xor                 ecx, ecx
            //   8d8df2fdffff         | mov                 edi, eax
            //   33c0                 | jne                 7
            //   57                   | lea                 ecx, [eax + 1]
            //   51                   | jmp                 7
            //   668985f0fdffff       | xor                 ecx, ecx

        $sequence_16 = { 745d 8d95f0fdffff 52 6804010000 ff15???????? }
            // n = 5, score = 300
            //   745d                 | xor                 ecx, ecx
            //   8d95f0fdffff         | test                eax, eax
            //   52                   | jne                 7
            //   6804010000           | lea                 ecx, [eax + 1]
            //   ff15????????         |                     

        $sequence_17 = { 8b35???????? ffd6 8b85d0fbffff 50 ffd6 57 ffd6 }
            // n = 7, score = 300
            //   8b35????????         |                     
            //   ffd6                 | jmp                 9
            //   8b85d0fbffff         | xor                 ecx, ecx
            //   50                   | jmp                 4
            //   ffd6                 | xor                 ecx, ecx
            //   57                   | mov                 edi, eax
            //   ffd6                 | test                eax, eax

        $sequence_18 = { 0f1f840000000000 0fb601 4883c104 48ffca 0fb60418 8841fc 75ed }
            // n = 7, score = 200
            //   0f1f840000000000     | movzx               ecx, byte ptr [ebp - 0x47]
            //   0fb601               | inc                 esi
            //   4883c104             | lea                 esi, [edx + eax]
            //   48ffca               | not                 ecx
            //   0fb60418             | inc                 esp
            //   8841fc               | mov                 eax, ebx
            //   75ed                 | inc                 ecx

        $sequence_19 = { 81eb00200200 83bd9404000000 899d94040000 0f85d7030000 8d85a0040000 }
            // n = 5, score = 200
            //   81eb00200200         | sub                 ebx, 0x22000
            //   83bd9404000000       | cmp                 dword ptr [ebp + 0x494], 0
            //   899d94040000         | mov                 dword ptr [ebp + 0x494], ebx
            //   0f85d7030000         | jne                 0x3dd
            //   8d85a0040000         | lea                 eax, [ebp + 0x4a0]

        $sequence_20 = { 8916 56 e8???????? 8a8c30dec44600 }
            // n = 4, score = 200
            //   8916                 | mov                 dword ptr [esi], edx
            //   56                   | push                esi
            //   e8????????           |                     
            //   8a8c30dec44600       | mov                 cl, byte ptr [eax + esi + 0x46c4de]

        $sequence_21 = { 41b850000000 4533c9 488bd3 488bc8 c744242803000000 }
            // n = 5, score = 200
            //   41b850000000         | mov                 word ptr [ebp - 0x418], dx
            //   4533c9               | push                0x40
            //   488bd3               | mov                 ebx, ecx
            //   488bc8               | xor                 edi, edi
            //   c744242803000000     | lea                 ecx, [ebp - 0x20e]

        $sequence_22 = { 8d85f0fcffff 50 68???????? ff15???????? 85c0 741c 6a00 }
            // n = 7, score = 200
            //   8d85f0fcffff         | lea                 eax, [ebp - 0x310]
            //   50                   | push                eax
            //   68????????           |                     
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   741c                 | je                  0x1e
            //   6a00                 | push                0

        $sequence_23 = { 52 6a00 6a00 ff15???????? 68d0070000 ff15???????? }
            // n = 6, score = 200
            //   52                   | push                edx
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   68d0070000           | push                0x7d0
            //   ff15????????         |                     

        $sequence_24 = { 488bcd c744242880000000 4c89642450 4889442458 4889442460 c744242003000000 ff15???????? }
            // n = 7, score = 200
            //   488bcd               | mov                 dword ptr [ebp - 0x45], 0x6a09e667
            //   c744242880000000     | lea                 edi, [eax + 8]
            //   4c89642450           | dec                 eax
            //   4889442458           | mov                 dword ptr [ebp - 0x51], eax
            //   4889442460           | dec                 ecx
            //   c744242003000000     | inc                 eax
            //   ff15????????         |                     

        $sequence_25 = { 4c89742420 ff15???????? 488bd8 4885c0 744f }
            // n = 5, score = 200
            //   4c89742420           | dec                 esp
            //   ff15????????         |                     
            //   488bd8               | mov                 dword ptr [esp + 0x20], esi
            //   4885c0               | dec                 eax
            //   744f                 | mov                 ebx, eax

        $sequence_26 = { 33d2 56 e8???????? 8a9435dec44600 5e 84c0 8bfa }
            // n = 7, score = 200
            //   33d2                 | xor                 edx, edx
            //   56                   | push                esi
            //   e8????????           |                     
            //   8a9435dec44600       | mov                 dl, byte ptr [ebp + esi + 0x46c4de]
            //   5e                   | pop                 esi
            //   84c0                 | test                al, al
            //   8bfa                 | mov                 edi, edx

        $sequence_27 = { 6804010000 8d95f8feffff 52 50 ff15???????? 8d85f8feffff 50 }
            // n = 7, score = 200
            //   6804010000           | push                0x104
            //   8d95f8feffff         | lea                 edx, [ebp - 0x108]
            //   52                   | push                edx
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8d85f8feffff         | lea                 eax, [ebp - 0x108]
            //   50                   | push                eax

        $sequence_28 = { 49ffc0 49ffc9 75d5 0fb645bd }
            // n = 4, score = 200
            //   49ffc0               | dec                 eax
            //   49ffc9               | test                eax, eax
            //   75d5                 | je                  0x51
            //   0fb645bd             | dec                 ecx

        $sequence_29 = { 4c895df7 4c895dff 4c895d07 c745bb67e6096a 8d7808 488945af }
            // n = 6, score = 200
            //   4c895df7             | xor                 edx, eax
            //   4c895dff             | inc                 ecx
            //   4c895d07             | inc                 ebx
            //   c745bb67e6096a       | shl                 ecx, 3
            //   8d7808               | shr                 eax, cl
            //   488945af             | mov                 byte ptr [edx - 5], al

        $sequence_30 = { ffd6 68???????? 8d8df8feffff 51 ffd6 }
            // n = 5, score = 200
            //   ffd6                 | call                esi
            //   68????????           |                     
            //   8d8df8feffff         | lea                 ecx, [ebp - 0x108]
            //   51                   | push                ecx
            //   ffd6                 | call                esi

        $sequence_31 = { e8???????? 8a8c30dec44600 5e bb01000000 }
            // n = 4, score = 200
            //   e8????????           |                     
            //   8a8c30dec44600       | mov                 cl, byte ptr [eax + esi + 0x46c4de]
            //   5e                   | pop                 esi
            //   bb01000000           | mov                 ebx, 1

        $sequence_32 = { 83e203 83f908 7229 f3a5 ff2495f0444000 8bc7 ba03000000 }
            // n = 7, score = 200
            //   83e203               | and                 edx, 3
            //   83f908               | cmp                 ecx, 8
            //   7229                 | jb                  0x2b
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   ff2495f0444000       | jmp                 dword ptr [edx*4 + 0x4044f0]
            //   8bc7                 | mov                 eax, edi
            //   ba03000000           | mov                 edx, 3

        $sequence_33 = { 4c8b5da8 4533c9 420fb6440db8 49ffc2 }
            // n = 4, score = 200
            //   4c8b5da8             | dec                 ecx
            //   4533c9               | dec                 ecx
            //   420fb6440db8         | jne                 0xffffffda
            //   49ffc2               | movzx               eax, byte ptr [ebp - 0x43]

        $sequence_34 = { 8d95f8feffff 52 ffd6 6804010000 }
            // n = 4, score = 200
            //   8d95f8feffff         | lea                 edx, [ebp - 0x108]
            //   52                   | push                edx
            //   ffd6                 | call                esi
            //   6804010000           | push                0x104

        $sequence_35 = { 00644440 0023 d18a0688078a 46 }
            // n = 4, score = 200
            //   00644440             | add                 byte ptr [esp + eax*2 + 0x40], ah
            //   0023                 | add                 byte ptr [ebx], ah
            //   d18a0688078a         | ror                 dword ptr [edx - 0x75f877fa], 1
            //   46                   | inc                 esi

        $sequence_36 = { 33db 56 e8???????? 8a9c30c2c44600 5e }
            // n = 5, score = 200
            //   33db                 | xor                 ebx, ebx
            //   56                   | push                esi
            //   e8????????           |                     
            //   8a9c30c2c44600       | mov                 bl, byte ptr [eax + esi + 0x46c4c2]
            //   5e                   | pop                 esi

        $sequence_37 = { 59 0bc9 89851a040000 61 7508 }
            // n = 5, score = 200
            //   59                   | pop                 ecx
            //   0bc9                 | or                  ecx, ecx
            //   89851a040000         | mov                 dword ptr [ebp + 0x41a], eax
            //   61                   | popal               
            //   7508                 | jne                 0xa

        $sequence_38 = { 5d bbedffffff 03dd 81eb00200200 83bd9404000000 }
            // n = 5, score = 200
            //   5d                   | pop                 ebp
            //   bbedffffff           | mov                 ebx, 0xffffffed
            //   03dd                 | add                 ebx, ebp
            //   81eb00200200         | sub                 ebx, 0x22000
            //   83bd9404000000       | cmp                 dword ptr [ebp + 0x494], 0

        $sequence_39 = { 33c9 56 e8???????? 8a8c30a6c44600 5e }
            // n = 5, score = 200
            //   33c9                 | xor                 ecx, ecx
            //   56                   | push                esi
            //   e8????????           |                     
            //   8a8c30a6c44600       | mov                 cl, byte ptr [eax + esi + 0x46c4a6]
            //   5e                   | pop                 esi

        $sequence_40 = { ff15???????? 8d95f8feffff 52 ff15???????? 8b3d???????? be0a000000 }
            // n = 6, score = 200
            //   ff15????????         |                     
            //   8d95f8feffff         | lea                 edx, [ebp - 0x108]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   8b3d????????         |                     
            //   be0a000000           | mov                 esi, 0xa

        $sequence_41 = { c3 8b442404 c7405030880010 c7401401000000 c3 }
            // n = 5, score = 100
            //   c3                   | ret                 
            //   8b442404             | mov                 eax, dword ptr [esp + 4]
            //   c7405030880010       | mov                 dword ptr [eax + 0x50], 0x10008830
            //   c7401401000000       | mov                 dword ptr [eax + 0x14], 1
            //   c3                   | ret                 

        $sequence_42 = { 59 3bc7 59 a3???????? 741e 68???????? 68???????? }
            // n = 7, score = 100
            //   59                   | pop                 ecx
            //   3bc7                 | cmp                 eax, edi
            //   59                   | pop                 ecx
            //   a3????????           |                     
            //   741e                 | je                  0x20
            //   68????????           |                     
            //   68????????           |                     

        $sequence_43 = { 42888401d0fa0100 ffc7 ebde 488b05???????? f0ff08 }
            // n = 5, score = 100
            //   42888401d0fa0100     | push                edx
            //   ffc7                 | push                0x104
            //   ebde                 | call                esi
            //   488b05????????       |                     
            //   f0ff08               | mov                 eax, dword ptr [ebp - 0x430]

        $sequence_44 = { f2ae 488d442440 33d2 48f7d1 894c2428 }
            // n = 5, score = 100
            //   f2ae                 | inc                 ecx
            //   488d442440           | mov                 eax, 0x50
            //   33d2                 | inc                 ebp
            //   48f7d1               | xor                 ecx, ecx
            //   894c2428             | dec                 eax

        $sequence_45 = { 56 e8???????? 80a0c798001000 80b8????????5c 59 }
            // n = 5, score = 100
            //   56                   | push                esi
            //   e8????????           |                     
            //   80a0c798001000       | and                 byte ptr [eax + 0x100098c7], 0
            //   80b8????????5c       |                     
            //   59                   | pop                 ecx

        $sequence_46 = { 4c8d05c7650100 488d15d8060100 488d4c2420 e8???????? }
            // n = 4, score = 100
            //   4c8d05c7650100       | dec                 eax
            //   488d15d8060100       | test                eax, eax
            //   488d4c2420           | je                  0x57
            //   e8????????           |                     

        $sequence_47 = { 8a4c303a 413ac8 741d 85db 7419 880a 4b8b84f9a02e0200 }
            // n = 7, score = 100
            //   8a4c303a             | add                 esp, 8
            //   413ac8               | dec                 edi
            //   741d                 | jne                 0xfffffff2
            //   85db                 | dec                 esp
            //   7419                 | mov                 dword ptr [esp + 0x20], esi
            //   880a                 | dec                 eax
            //   4b8b84f9a02e0200     | mov                 ebx, eax

        $sequence_48 = { 83e00f eb02 33c0 0fbe84c608710010 }
            // n = 4, score = 100
            //   83e00f               | and                 eax, 0xf
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax
            //   0fbe84c608710010     | movsx               eax, byte ptr [esi + eax*8 + 0x10007108]

        $sequence_49 = { 742e 85f6 7419 0fb6da f683a1a2001004 7406 8816 }
            // n = 7, score = 100
            //   742e                 | je                  0x30
            //   85f6                 | test                esi, esi
            //   7419                 | je                  0x1b
            //   0fb6da               | movzx               ebx, dl
            //   f683a1a2001004       | test                byte ptr [ebx + 0x1000a2a1], 4
            //   7406                 | je                  8
            //   8816                 | mov                 byte ptr [esi], dl

        $sequence_50 = { 0f85a3010000 8b7510 53 817e0402010000 0f850f010000 66833d????????01 }
            // n = 6, score = 100
            //   0f85a3010000         | jne                 0x1a9
            //   8b7510               | mov                 esi, dword ptr [ebp + 0x10]
            //   53                   | push                ebx
            //   817e0402010000       | cmp                 dword ptr [esi + 4], 0x102
            //   0f850f010000         | jne                 0x115
            //   66833d????????01     |                     

        $sequence_51 = { 80794000 0f857e010000 48897c2450 4183f901 753b 48895108 }
            // n = 6, score = 100
            //   80794000             | push                eax
            //   0f857e010000         | call                esi
            //   48897c2450           | push                edi
            //   4183f901             | call                esi
            //   753b                 | lea                 eax, [esp + 0x18]
            //   48895108             | push                eax

        $sequence_52 = { 41f7d1 488d3d99550100 4983f808 0f82ec000000 48895c2410 498bd8 }
            // n = 6, score = 100
            //   41f7d1               | push                ecx
            //   488d3d99550100       | add                 esp, 8
            //   4983f808             | test                eax, eax
            //   0f82ec000000         | jne                 0x1a
            //   48895c2410           | je                  0x5f
            //   498bd8               | lea                 edx, [ebp - 0x210]

    condition:
        7 of them and filesize < 2361344
}