rule win_kpot_stealer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.kpot_stealer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.kpot_stealer"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0bc1 0fb64f04 c1e208 0bca 0fb65707 c1e208 0bd6 }
            // n = 7, score = 500
            //   0bc1                 | or                  eax, ecx
            //   0fb64f04             | movzx               ecx, byte ptr [edi + 4]
            //   c1e208               | shl                 edx, 8
            //   0bca                 | or                  ecx, edx
            //   0fb65707             | movzx               edx, byte ptr [edi + 7]
            //   c1e208               | shl                 edx, 8
            //   0bd6                 | or                  edx, esi

        $sequence_1 = { 83f80f 7703 6a0f 58 3d00e00100 7605 83c8ff }
            // n = 7, score = 500
            //   83f80f               | cmp                 eax, 0xf
            //   7703                 | ja                  5
            //   6a0f                 | push                0xf
            //   58                   | pop                 eax
            //   3d00e00100           | cmp                 eax, 0x1e000
            //   7605                 | jbe                 7
            //   83c8ff               | or                  eax, 0xffffffff

        $sequence_2 = { 8b08 50 ff5108 832600 b001 c3 }
            // n = 6, score = 500
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   50                   | push                eax
            //   ff5108               | call                dword ptr [ecx + 8]
            //   832600               | and                 dword ptr [esi], 0
            //   b001                 | mov                 al, 1
            //   c3                   | ret                 

        $sequence_3 = { 884b04 8bc1 c1e808 884305 8bc1 c1e810 884306 }
            // n = 7, score = 500
            //   884b04               | mov                 byte ptr [ebx + 4], cl
            //   8bc1                 | mov                 eax, ecx
            //   c1e808               | shr                 eax, 8
            //   884305               | mov                 byte ptr [ebx + 5], al
            //   8bc1                 | mov                 eax, ecx
            //   c1e810               | shr                 eax, 0x10
            //   884306               | mov                 byte ptr [ebx + 6], al

        $sequence_4 = { 8ac3 e8???????? 84c0 7505 8b55f0 }
            // n = 5, score = 500
            //   8ac3                 | mov                 al, bl
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   7505                 | jne                 7
            //   8b55f0               | mov                 edx, dword ptr [ebp - 0x10]

        $sequence_5 = { 56 57 8bf8 8d4701 50 8bf1 ff15???????? }
            // n = 7, score = 500
            //   56                   | push                esi
            //   57                   | push                edi
            //   8bf8                 | mov                 edi, eax
            //   8d4701               | lea                 eax, [edi + 1]
            //   50                   | push                eax
            //   8bf1                 | mov                 esi, ecx
            //   ff15????????         |                     

        $sequence_6 = { 8bf2 81e600001000 0bce c1e914 81e300000600 8bf2 81e600e00100 }
            // n = 7, score = 500
            //   8bf2                 | mov                 esi, edx
            //   81e600001000         | and                 esi, 0x100000
            //   0bce                 | or                  ecx, esi
            //   c1e914               | shr                 ecx, 0x14
            //   81e300000600         | and                 ebx, 0x60000
            //   8bf2                 | mov                 esi, edx
            //   81e600e00100         | and                 esi, 0x1e000

        $sequence_7 = { 8bf0 7504 33c0 eb31 83feff 750a 8b4d08 }
            // n = 7, score = 500
            //   8bf0                 | mov                 esi, eax
            //   7504                 | jne                 6
            //   33c0                 | xor                 eax, eax
            //   eb31                 | jmp                 0x33
            //   83feff               | cmp                 esi, -1
            //   750a                 | jne                 0xc
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]

        $sequence_8 = { 5a 0f8418010000 83c708 c7450c08000000 8b47fc }
            // n = 5, score = 500
            //   5a                   | pop                 edx
            //   0f8418010000         | je                  0x11e
            //   83c708               | add                 edi, 8
            //   c7450c08000000       | mov                 dword ptr [ebp + 0xc], 8
            //   8b47fc               | mov                 eax, dword ptr [edi - 4]

        $sequence_9 = { c1e108 ff7514 0bc1 0fb64f02 ff7510 c1e110 }
            // n = 6, score = 500
            //   c1e108               | shl                 ecx, 8
            //   ff7514               | push                dword ptr [ebp + 0x14]
            //   0bc1                 | or                  eax, ecx
            //   0fb64f02             | movzx               ecx, byte ptr [edi + 2]
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   c1e110               | shl                 ecx, 0x10

    condition:
        7 of them and filesize < 219136
}