rule win_kuaibu8_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.kuaibu8."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.kuaibu8"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 83c404 58 8be5 5d c26400 55 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   58                   | pop                 eax
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c26400               | ret                 0x64
            //   55                   | push                ebp

        $sequence_1 = { 0f84b2000000 6804000080 6a00 68???????? 6801000000 bb98010000 e8???????? }
            // n = 7, score = 100
            //   0f84b2000000         | je                  0xb8
            //   6804000080           | push                0x80000004
            //   6a00                 | push                0
            //   68????????           |                     
            //   6801000000           | push                1
            //   bb98010000           | mov                 ebx, 0x198
            //   e8????????           |                     

        $sequence_2 = { 7409 53 e8???????? 83c404 8b45c4 e9???????? 6802000080 }
            // n = 7, score = 100
            //   7409                 | je                  0xb
            //   53                   | push                ebx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8b45c4               | mov                 eax, dword ptr [ebp - 0x3c]
            //   e9????????           |                     
            //   6802000080           | push                0x80000002

        $sequence_3 = { c745e400000000 b8???????? 8945e0 8d45e0 50 e8???????? 8945dc }
            // n = 7, score = 100
            //   c745e400000000       | mov                 dword ptr [ebp - 0x1c], 0
            //   b8????????           |                     
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax
            //   8d45e0               | lea                 eax, [ebp - 0x20]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8945dc               | mov                 dword ptr [ebp - 0x24], eax

        $sequence_4 = { 7d0d 56 e8???????? 33c0 5e 83c410 c3 }
            // n = 7, score = 100
            //   7d0d                 | jge                 0xf
            //   56                   | push                esi
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   5e                   | pop                 esi
            //   83c410               | add                 esp, 0x10
            //   c3                   | ret                 

        $sequence_5 = { 5e 81c410010000 c3 8d442410 50 56 }
            // n = 6, score = 100
            //   5e                   | pop                 esi
            //   81c410010000         | add                 esp, 0x110
            //   c3                   | ret                 
            //   8d442410             | lea                 eax, [esp + 0x10]
            //   50                   | push                eax
            //   56                   | push                esi

        $sequence_6 = { 68???????? ff75d4 68???????? ff75f4 68???????? b905000000 e8???????? }
            // n = 7, score = 100
            //   68????????           |                     
            //   ff75d4               | push                dword ptr [ebp - 0x2c]
            //   68????????           |                     
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   68????????           |                     
            //   b905000000           | mov                 ecx, 5
            //   e8????????           |                     

        $sequence_7 = { 83c40c 8945e8 6802000080 6a00 6800000000 6a00 }
            // n = 6, score = 100
            //   83c40c               | add                 esp, 0xc
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   6802000080           | push                0x80000002
            //   6a00                 | push                0
            //   6800000000           | push                0
            //   6a00                 | push                0

        $sequence_8 = { ff75f4 68???????? 6800000000 6800000000 ff15???????? 90 90 }
            // n = 7, score = 100
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   68????????           |                     
            //   6800000000           | push                0
            //   6800000000           | push                0
            //   ff15????????         |                     
            //   90                   | nop                 
            //   90                   | nop                 

        $sequence_9 = { 8b5dec e8???????? 33c9 50 8d45f4 8bd8 58 }
            // n = 7, score = 100
            //   8b5dec               | mov                 ebx, dword ptr [ebp - 0x14]
            //   e8????????           |                     
            //   33c9                 | xor                 ecx, ecx
            //   50                   | push                eax
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   8bd8                 | mov                 ebx, eax
            //   58                   | pop                 eax

    condition:
        7 of them and filesize < 737280
}