rule win_lamdelin_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2018-11-23"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator 0.1a"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lamdelin"
        malpedia_version = "20180607"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using yara-signator.
     * The code and documentation / approach will be published in the near future here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */

    strings:
        $sequence_0 = { e6ff 0000 e6ff 59 }
            // n = 4, score = 1000
            //   e6ff                 | out                 0xff, al
            //   0000                 | add                 byte ptr [eax], al
            //   e6ff                 | out                 0xff, al
            //   59                   | pop                 ecx

        $sequence_1 = { f5 f5 fb fff3 }
            // n = 4, score = 1000
            //   f5                   | cmc                 
            //   f5                   | cmc                 
            //   fb                   | sti                 
            //   fff3                 | push                ebx

        $sequence_2 = { 0200 e6ff 0100 e6ff }
            // n = 4, score = 1000
            //   0200                 | add                 al, byte ptr [eax]
            //   e6ff                 | out                 0xff, al
            //   0100                 | add                 dword ptr [eax], eax
            //   e6ff                 | out                 0xff, al

        $sequence_3 = { 00e6 ff02 00e6 ff01 }
            // n = 4, score = 1000
            //   00e6                 | add                 dh, ah
            //   ff02                 | inc                 dword ptr [edx]
            //   00e6                 | add                 dh, ah
            //   ff01                 | inc                 dword ptr [ecx]

        $sequence_4 = { 0100 e6ff 0000 e6ff }
            // n = 4, score = 1000
            //   0100                 | add                 dword ptr [eax], eax
            //   e6ff                 | out                 0xff, al
            //   0000                 | add                 byte ptr [eax], al
            //   e6ff                 | out                 0xff, al

        $sequence_5 = { 0200 e6ff 0200 e6ff }
            // n = 4, score = 1000
            //   0200                 | add                 al, byte ptr [eax]
            //   e6ff                 | out                 0xff, al
            //   0200                 | add                 al, byte ptr [eax]
            //   e6ff                 | out                 0xff, al

        $sequence_6 = { f6f1 ff8ab57cff84 b171 ff5692 }
            // n = 4, score = 1000
            //   f6f1                 | div                 cl
            //   ff8ab57cff84         | dec                 dword ptr [edx - 0x7b00834b]
            //   b171                 | mov                 cl, 0x71
            //   ff5692               | call                dword ptr [esi - 0x6e]

        $sequence_7 = { fff3 f6f1 ff8ab57cff84 b171 }
            // n = 4, score = 1000
            //   fff3                 | push                ebx
            //   f6f1                 | div                 cl
            //   ff8ab57cff84         | dec                 dword ptr [edx - 0x7b00834b]
            //   b171                 | mov                 cl, 0x71

        $sequence_8 = { e6ff 0100 e6ff 0000 }
            // n = 4, score = 1000
            //   e6ff                 | out                 0xff, al
            //   0100                 | add                 dword ptr [eax], eax
            //   e6ff                 | out                 0xff, al
            //   0000                 | add                 byte ptr [eax], al

        $sequence_9 = { e6ff 0200 e6ff 0100 }
            // n = 4, score = 1000
            //   e6ff                 | out                 0xff, al
            //   0200                 | add                 al, byte ptr [eax]
            //   e6ff                 | out                 0xff, al
            //   0100                 | add                 dword ptr [eax], eax

    condition:
        7 of them
}