rule win_liteduke_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.liteduke."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.liteduke"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b4df8 e30b 0175f8 01f1 66c741fe0000 89f3 }
            // n = 6, score = 200
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   e30b                 | jecxz               0xd
            //   0175f8               | add                 dword ptr [ebp - 8], esi
            //   01f1                 | add                 ecx, esi
            //   66c741fe0000         | mov                 word ptr [ecx - 2], 0
            //   89f3                 | mov                 ebx, esi

        $sequence_1 = { ff7508 e8???????? a3???????? 014d08 }
            // n = 4, score = 200
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   a3????????           |                     
            //   014d08               | add                 dword ptr [ebp + 8], ecx

        $sequence_2 = { ff750c ff7508 e8???????? 85c0 750e 8b4508 ff30 }
            // n = 7, score = 200
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   750e                 | jne                 0x10
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   ff30                 | push                dword ptr [eax]

        $sequence_3 = { 0f31 a3???????? 58 5a c3 52 }
            // n = 6, score = 200
            //   0f31                 | rdtsc               
            //   a3????????           |                     
            //   58                   | pop                 eax
            //   5a                   | pop                 edx
            //   c3                   | ret                 
            //   52                   | push                edx

        $sequence_4 = { ff7508 ff15???????? ff75fc ff15???????? 6a00 ff15???????? 5b }
            // n = 7, score = 200
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ff15????????         |                     
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   ff15????????         |                     
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   5b                   | pop                 ebx

        $sequence_5 = { 83ec30 c745ec00000000 c745fc00000000 57 }
            // n = 4, score = 200
            //   83ec30               | sub                 esp, 0x30
            //   c745ec00000000       | mov                 dword ptr [ebp - 0x14], 0
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   57                   | push                edi

        $sequence_6 = { b900010000 8dbd00fcffff f3a5 61 }
            // n = 4, score = 200
            //   b900010000           | mov                 ecx, 0x100
            //   8dbd00fcffff         | lea                 edi, [ebp - 0x400]
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   61                   | popal               

        $sequence_7 = { f3a4 b000 aa 58 014508 e9???????? ff7508 }
            // n = 7, score = 200
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   b000                 | mov                 al, 0
            //   aa                   | stosb               byte ptr es:[edi], al
            //   58                   | pop                 eax
            //   014508               | add                 dword ptr [ebp + 8], eax
            //   e9????????           |                     
            //   ff7508               | push                dword ptr [ebp + 8]

        $sequence_8 = { b801000000 c9 c20c00 55 89e5 6a00 }
            // n = 6, score = 200
            //   b801000000           | mov                 eax, 1
            //   c9                   | leave               
            //   c20c00               | ret                 0xc
            //   55                   | push                ebp
            //   89e5                 | mov                 ebp, esp
            //   6a00                 | push                0

        $sequence_9 = { 5a 31c0 8a02 52 50 6a03 e8???????? }
            // n = 7, score = 200
            //   5a                   | pop                 edx
            //   31c0                 | xor                 eax, eax
            //   8a02                 | mov                 al, byte ptr [edx]
            //   52                   | push                edx
            //   50                   | push                eax
            //   6a03                 | push                3
            //   e8????????           |                     

    condition:
        7 of them and filesize < 1171456
}