rule win_lookback_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.lookback."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lookback"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 32d9 881c38 40 fec2 }
            // n = 4, score = 200
            //   32d9                 | xor                 bl, cl
            //   881c38               | mov                 byte ptr [eax + edi], bl
            //   40                   | inc                 eax
            //   fec2                 | inc                 dl

        $sequence_1 = { 50 55 896b04 e8???????? 8b4c242c 8b542430 }
            // n = 6, score = 200
            //   50                   | push                eax
            //   55                   | push                ebp
            //   896b04               | mov                 dword ptr [ebx + 4], ebp
            //   e8????????           |                     
            //   8b4c242c             | mov                 ecx, dword ptr [esp + 0x2c]
            //   8b542430             | mov                 edx, dword ptr [esp + 0x30]

        $sequence_2 = { ffd3 393d???????? 75af eb24 8b0d???????? 51 eb0f }
            // n = 7, score = 200
            //   ffd3                 | call                ebx
            //   393d????????         |                     
            //   75af                 | jne                 0xffffffb1
            //   eb24                 | jmp                 0x26
            //   8b0d????????         |                     
            //   51                   | push                ecx
            //   eb0f                 | jmp                 0x11

        $sequence_3 = { 81fe00300000 7512 8b31 25ff0f0000 03c6 8bf7 }
            // n = 6, score = 200
            //   81fe00300000         | cmp                 esi, 0x3000
            //   7512                 | jne                 0x14
            //   8b31                 | mov                 esi, dword ptr [ecx]
            //   25ff0f0000           | and                 eax, 0xfff
            //   03c6                 | add                 eax, esi
            //   8bf7                 | mov                 esi, edi

        $sequence_4 = { c644240800 88442415 e8???????? 8d4c240c 89442408 51 }
            // n = 6, score = 200
            //   c644240800           | mov                 byte ptr [esp + 8], 0
            //   88442415             | mov                 byte ptr [esp + 0x15], al
            //   e8????????           |                     
            //   8d4c240c             | lea                 ecx, [esp + 0xc]
            //   89442408             | mov                 dword ptr [esp + 8], eax
            //   51                   | push                ecx

        $sequence_5 = { 56 ff15???????? 817c240c1c010000 7515 8bbc2438020000 }
            // n = 5, score = 200
            //   56                   | push                esi
            //   ff15????????         |                     
            //   817c240c1c010000     | cmp                 dword ptr [esp + 0xc], 0x11c
            //   7515                 | jne                 0x17
            //   8bbc2438020000       | mov                 edi, dword ptr [esp + 0x238]

        $sequence_6 = { 0f8407020000 8b35???????? 57 57 57 57 ffd6 }
            // n = 7, score = 200
            //   0f8407020000         | je                  0x20d
            //   8b35????????         |                     
            //   57                   | push                edi
            //   57                   | push                edi
            //   57                   | push                edi
            //   57                   | push                edi
            //   ffd6                 | call                esi

        $sequence_7 = { 52 8d442418 57 50 68???????? 57 57 }
            // n = 7, score = 200
            //   52                   | push                edx
            //   8d442418             | lea                 eax, [esp + 0x18]
            //   57                   | push                edi
            //   50                   | push                eax
            //   68????????           |                     
            //   57                   | push                edi
            //   57                   | push                edi

        $sequence_8 = { 55 8bec 51 53 c745fc00000000 b801000000 0fa2 }
            // n = 7, score = 200
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   51                   | push                ecx
            //   53                   | push                ebx
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   b801000000           | mov                 eax, 1
            //   0fa2                 | cpuid               

        $sequence_9 = { 56 57 6880020000 8901 c744241480020000 66894104 e8???????? }
            // n = 7, score = 200
            //   56                   | push                esi
            //   57                   | push                edi
            //   6880020000           | push                0x280
            //   8901                 | mov                 dword ptr [ecx], eax
            //   c744241480020000     | mov                 dword ptr [esp + 0x14], 0x280
            //   66894104             | mov                 word ptr [ecx + 4], ax
            //   e8????????           |                     

    condition:
        7 of them and filesize < 131072
}