rule win_lowball_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.lowball."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lowball"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bcb 8d94243c090000 83e103 f3a4 83c9ff 8dbc2424030000 }
            // n = 6, score = 100
            //   8bcb                 | mov                 ecx, ebx
            //   8d94243c090000       | lea                 edx, [esp + 0x93c]
            //   83e103               | and                 ecx, 3
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   83c9ff               | or                  ecx, 0xffffffff
            //   8dbc2424030000       | lea                 edi, [esp + 0x324]

        $sequence_1 = { f3a5 8d842428020000 8bcb 50 83e103 }
            // n = 5, score = 100
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   8d842428020000       | lea                 eax, [esp + 0x228]
            //   8bcb                 | mov                 ecx, ebx
            //   50                   | push                eax
            //   83e103               | and                 ecx, 3

        $sequence_2 = { 881c10 40 3bc6 7cf3 5b 5f }
            // n = 6, score = 100
            //   881c10               | mov                 byte ptr [eax + edx], bl
            //   40                   | inc                 eax
            //   3bc6                 | cmp                 eax, esi
            //   7cf3                 | jl                  0xfffffff5
            //   5b                   | pop                 ebx
            //   5f                   | pop                 edi

        $sequence_3 = { 8bd8 3bdd 895c2418 0f84db000000 8b94242c020000 55 }
            // n = 6, score = 100
            //   8bd8                 | mov                 ebx, eax
            //   3bdd                 | cmp                 ebx, ebp
            //   895c2418             | mov                 dword ptr [esp + 0x18], ebx
            //   0f84db000000         | je                  0xe1
            //   8b94242c020000       | mov                 edx, dword ptr [esp + 0x22c]
            //   55                   | push                ebp

        $sequence_4 = { 55 50 ff15???????? 8bf0 3bf5 8974241c }
            // n = 6, score = 100
            //   55                   | push                ebp
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   3bf5                 | cmp                 esi, ebp
            //   8974241c             | mov                 dword ptr [esp + 0x1c], esi

        $sequence_5 = { 4f c1e902 f3a5 8bcb 8d942430060000 83e103 f3a4 }
            // n = 7, score = 100
            //   4f                   | dec                 edi
            //   c1e902               | shr                 ecx, 2
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   8bcb                 | mov                 ecx, ebx
            //   8d942430060000       | lea                 edx, [esp + 0x630]
            //   83e103               | and                 ecx, 3
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]

        $sequence_6 = { 8b3d???????? 68???????? 53 ffd7 8bf0 83c408 85f6 }
            // n = 7, score = 100
            //   8b3d????????         |                     
            //   68????????           |                     
            //   53                   | push                ebx
            //   ffd7                 | call                edi
            //   8bf0                 | mov                 esi, eax
            //   83c408               | add                 esp, 8
            //   85f6                 | test                esi, esi

        $sequence_7 = { c1e902 f3a5 8bcb 8d84243c090000 }
            // n = 4, score = 100
            //   c1e902               | shr                 ecx, 2
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   8bcb                 | mov                 ecx, ebx
            //   8d84243c090000       | lea                 eax, [esp + 0x93c]

        $sequence_8 = { 33c0 8d7c241d 8d54241c f3ab }
            // n = 4, score = 100
            //   33c0                 | xor                 eax, eax
            //   8d7c241d             | lea                 edi, [esp + 0x1d]
            //   8d54241c             | lea                 edx, [esp + 0x1c]
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax

        $sequence_9 = { 6a00 6a00 6a00 8d442428 6a00 50 ff15???????? }
            // n = 7, score = 100
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   8d442428             | lea                 eax, [esp + 0x28]
            //   6a00                 | push                0
            //   50                   | push                eax
            //   ff15????????         |                     

    condition:
        7 of them and filesize < 40960
}