rule win_luca_stealer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.luca_stealer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.luca_stealer"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 83a4248800000000 4c8d842488000000 4c8bcf 488d4c2430 488bd0 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83a4248800000000     | inc                 ebp
            //   4c8d842488000000     | xor                 edx, edx
            //   4c8bcf               | inc                 esp
            //   488d4c2430           | mov                 ecx, dword ptr [esp + 0x60]
            //   488bd0               | dec                 eax
            //   e8????????           |                     

        $sequence_1 = { e8???????? 488d8d60110000 4889f2 4c8b85a01c0000 e8???????? 488b03 4885c0 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488d8d60110000       | lea                 eax, [ebx + 1]
            //   4889f2               | dec                 esp
            //   4c8b85a01c0000       | cmp                 eax, eax
            //   e8????????           |                     
            //   488b03               | mov                 edi, edx
            //   4885c0               | dec                 eax

        $sequence_2 = { e8???????? 48c70702000000 4883fb01 740e 89d8 83e002 4885c0 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   48c70702000000       | inc                 dword ptr [ebx + 0x10]
            //   4883fb01             | mov                 al, byte ptr [esp + 0x62]
            //   740e                 | jmp                 0x9c9
            //   89d8                 | mov                 byte ptr [esp + 0x388], 0
            //   83e002               | inc                 ebp
            //   4885c0               | xor                 edi, edi

        $sequence_3 = { e8???????? 80385d 750b 8b4b58 394804 7503 897004 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   80385d               | add                 esi, 0x20
            //   750b                 | mov                 dword ptr [ebp + 0x78], ecx
            //   8b4b58               | mov                 edx, dword ptr [edi + 0x38]
            //   394804               | inc                 esp
            //   7503                 | cmp                 ebp, edx
            //   897004               | mov                 ecx, dword ptr [ebp + 0x78]

        $sequence_4 = { e8???????? 488d8d801e0000 e8???????? 0f28742470 0f287c2460 440f28442450 4881c488000000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488d8d801e0000       | add                 al, 0x3c
            //   e8????????           |                     
            //   0f28742470           | not                 cl
            //   0f287c2460           | add                 cl, 0x3c
            //   440f28442450         | not                 dl
            //   4881c488000000       | movzx               esi, dl

        $sequence_5 = { e8???????? 4c8d442450 488bd0 488bce 488be8 e8???????? 8bf8 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   4c8d442450           | dec                 esp
            //   488bd0               | arpl                word ptr [ebx], ax
            //   488bce               | mov                 dword ptr [esp + 0x40], eax
            //   488be8               | mov                 eax, dword ptr [edi + 8]
            //   e8????????           |                     
            //   8bf8                 | mov                 dword ptr [edi + 0x70], eax

        $sequence_6 = { e9???????? 4d892e e8???????? 85c0 0f84e9040000 4d85ff 0f84e0040000 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   4d892e               | dec                 eax
            //   e8????????           |                     
            //   85c0                 | add                 ecx, 8
            //   0f84e9040000         | inc                 ecx
            //   4d85ff               | push                edi
            //   0f84e0040000         | nop                 

        $sequence_7 = { eb0e 44894c2434 498bf0 4983f8ff 7448 488b9778010000 458bc7 }
            // n = 7, score = 100
            //   eb0e                 | mov                 ecx, 0x10870
            //   44894c2434           | mov                 ecx, 0x1086a
            //   498bf0               | mov                 eax, ebx
            //   4983f8ff             | mov                 byte ptr [esi + edi + 6], bl
            //   7448                 | sub                 ebx, ecx
            //   488b9778010000       | mov                 ecx, 0x1870
            //   458bc7               | mov                 edx, 8

        $sequence_8 = { eb34 4585c9 7407 b9180a0100 eb28 3bd7 7607 }
            // n = 7, score = 100
            //   eb34                 | dec                 eax
            //   4585c9               | mov                 ecx, edi
            //   7407                 | dec                 eax
            //   b9180a0100           | mov                 esi, eax
            //   eb28                 | dec                 eax
            //   3bd7                 | test                eax, eax
            //   7607                 | mov                 ebx, 0x1b

        $sequence_9 = { eb02 31c0 4883c428 c3 488b01 488b4808 8b4010 }
            // n = 7, score = 100
            //   eb02                 | inc                 esp
            //   31c0                 | mov                 dword ptr [edi + 0x58], ebp
            //   4883c428             | xor                 eax, eax
            //   c3                   | inc                 esp
            //   488b01               | lea                 ebp, [esi + 0xa]
            //   488b4808             | dec                 eax
            //   8b4010               | cmp                 dword ptr [edi + 0x38], eax

    condition:
        7 of them and filesize < 9285632
}