rule win_manitsme_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.manitsme."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.manitsme"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85c0 7586 50 ff15???????? }
            // n = 4, score = 100
            //   85c0                 | test                eax, eax
            //   7586                 | jne                 0xffffff88
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_1 = { 89742424 89742420 89742434 89742430 8974242c 89742428 6689742448 }
            // n = 7, score = 100
            //   89742424             | mov                 dword ptr [esp + 0x24], esi
            //   89742420             | mov                 dword ptr [esp + 0x20], esi
            //   89742434             | mov                 dword ptr [esp + 0x34], esi
            //   89742430             | mov                 dword ptr [esp + 0x30], esi
            //   8974242c             | mov                 dword ptr [esp + 0x2c], esi
            //   89742428             | mov                 dword ptr [esp + 0x28], esi
            //   6689742448           | mov                 word ptr [esp + 0x48], si

        $sequence_2 = { 8b94243c010000 83c40c 89542418 8d842434010000 8d5001 }
            // n = 5, score = 100
            //   8b94243c010000       | mov                 edx, dword ptr [esp + 0x13c]
            //   83c40c               | add                 esp, 0xc
            //   89542418             | mov                 dword ptr [esp + 0x18], edx
            //   8d842434010000       | lea                 eax, [esp + 0x134]
            //   8d5001               | lea                 edx, [eax + 1]

        $sequence_3 = { 51 c744243810000000 896c2440 897c2444 897c2448 }
            // n = 5, score = 100
            //   51                   | push                ecx
            //   c744243810000000     | mov                 dword ptr [esp + 0x38], 0x10
            //   896c2440             | mov                 dword ptr [esp + 0x40], ebp
            //   897c2444             | mov                 dword ptr [esp + 0x44], edi
            //   897c2448             | mov                 dword ptr [esp + 0x48], edi

        $sequence_4 = { 6a00 51 e8???????? b941000000 }
            // n = 4, score = 100
            //   6a00                 | push                0
            //   51                   | push                ecx
            //   e8????????           |                     
            //   b941000000           | mov                 ecx, 0x41

        $sequence_5 = { 8d442418 50 68fc030000 8d4c2424 }
            // n = 4, score = 100
            //   8d442418             | lea                 eax, [esp + 0x18]
            //   50                   | push                eax
            //   68fc030000           | push                0x3fc
            //   8d4c2424             | lea                 ecx, [esp + 0x24]

        $sequence_6 = { 68ffff0000 52 ff15???????? 8b3d???????? 6a02 68???????? be0b000000 }
            // n = 7, score = 100
            //   68ffff0000           | push                0xffff
            //   52                   | push                edx
            //   ff15????????         |                     
            //   8b3d????????         |                     
            //   6a02                 | push                2
            //   68????????           |                     
            //   be0b000000           | mov                 esi, 0xb

        $sequence_7 = { 6bf628 03348540580110 8b45e4 8b00 8906 }
            // n = 5, score = 100
            //   6bf628               | imul                esi, esi, 0x28
            //   03348540580110       | add                 esi, dword ptr [eax*4 + 0x10015840]
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   8906                 | mov                 dword ptr [esi], eax

        $sequence_8 = { 5d c3 56 57 33ff 8db7403e0110 ff36 }
            // n = 7, score = 100
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   56                   | push                esi
            //   57                   | push                edi
            //   33ff                 | xor                 edi, edi
            //   8db7403e0110         | lea                 esi, [edi + 0x10013e40]
            //   ff36                 | push                dword ptr [esi]

        $sequence_9 = { 896c2440 897c2444 897c2448 897c244c 895c2450 ffd6 }
            // n = 6, score = 100
            //   896c2440             | mov                 dword ptr [esp + 0x40], ebp
            //   897c2444             | mov                 dword ptr [esp + 0x44], edi
            //   897c2448             | mov                 dword ptr [esp + 0x48], edi
            //   897c244c             | mov                 dword ptr [esp + 0x4c], edi
            //   895c2450             | mov                 dword ptr [esp + 0x50], ebx
            //   ffd6                 | call                esi

    condition:
        7 of them and filesize < 212992
}