rule win_matanbuchus_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.matanbuchus."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.matanbuchus"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33c0 e9???????? 8b45e8 8b4d08 03483c }
            // n = 5, score = 500
            //   33c0                 | xor                 eax, eax
            //   e9????????           |                     
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   03483c               | add                 ecx, dword ptr [eax + 0x3c]

        $sequence_1 = { 035120 8955dc 8b45f4 8b4d08 03481c 894dcc c745f000000000 }
            // n = 7, score = 500
            //   035120               | add                 edx, dword ptr [ecx + 0x20]
            //   8955dc               | mov                 dword ptr [ebp - 0x24], edx
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   03481c               | add                 ecx, dword ptr [eax + 0x1c]
            //   894dcc               | mov                 dword ptr [ebp - 0x34], ecx
            //   c745f000000000       | mov                 dword ptr [ebp - 0x10], 0

        $sequence_2 = { 8b55f0 8b4214 8945e8 33c9 66894dfc }
            // n = 5, score = 500
            //   8b55f0               | mov                 edx, dword ptr [ebp - 0x10]
            //   8b4214               | mov                 eax, dword ptr [edx + 0x14]
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   33c9                 | xor                 ecx, ecx
            //   66894dfc             | mov                 word ptr [ebp - 4], cx

        $sequence_3 = { 8b55ec 813a50450000 7407 33c0 e9???????? 8b45ec }
            // n = 6, score = 500
            //   8b55ec               | mov                 edx, dword ptr [ebp - 0x14]
            //   813a50450000         | cmp                 dword ptr [edx], 0x4550
            //   7407                 | je                  9
            //   33c0                 | xor                 eax, eax
            //   e9????????           |                     
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]

        $sequence_4 = { 8b45e8 8b4d08 03483c 894dec 8b55ec }
            // n = 5, score = 500
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   03483c               | add                 ecx, dword ptr [eax + 0x3c]
            //   894dec               | mov                 dword ptr [ebp - 0x14], ecx
            //   8b55ec               | mov                 edx, dword ptr [ebp - 0x14]

        $sequence_5 = { 8b4508 8945f8 8b4df8 8b513c 035508 }
            // n = 5, score = 500
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   8b513c               | mov                 edx, dword ptr [ecx + 0x3c]
            //   035508               | add                 edx, dword ptr [ebp + 8]

        $sequence_6 = { 69c293010001 50 b901000000 c1e100 034d08 51 e8???????? }
            // n = 7, score = 500
            //   69c293010001         | imul                eax, edx, 0x1000193
            //   50                   | push                eax
            //   b901000000           | mov                 ecx, 1
            //   c1e100               | shl                 ecx, 0
            //   034d08               | add                 ecx, dword ptr [ebp + 8]
            //   51                   | push                ecx
            //   e8????????           |                     

        $sequence_7 = { 034508 8945e0 8b4de0 8b5178 035508 8955f0 8b45f0 }
            // n = 7, score = 500
            //   034508               | add                 eax, dword ptr [ebp + 8]
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax
            //   8b4de0               | mov                 ecx, dword ptr [ebp - 0x20]
            //   8b5178               | mov                 edx, dword ptr [ecx + 0x78]
            //   035508               | add                 edx, dword ptr [ebp + 8]
            //   8955f0               | mov                 dword ptr [ebp - 0x10], edx
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]

        $sequence_8 = { 8955f4 8b45f4 83780400 0f84a6000000 8b4df4 }
            // n = 5, score = 500
            //   8955f4               | mov                 dword ptr [ebp - 0xc], edx
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   83780400             | cmp                 dword ptr [eax + 4], 0
            //   0f84a6000000         | je                  0xac
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]

        $sequence_9 = { 894dec 8b55ec 813a50450000 7407 }
            // n = 4, score = 500
            //   894dec               | mov                 dword ptr [ebp - 0x14], ecx
            //   8b55ec               | mov                 edx, dword ptr [ebp - 0x14]
            //   813a50450000         | cmp                 dword ptr [edx], 0x4550
            //   7407                 | je                  9

    condition:
        7 of them and filesize < 13077504
}