rule win_mekotio_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mekotio"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e9???????? 8d8d00ffffff 33d2 a1???????? 8b38 ff570c 8b8500ffffff }
            // n = 7, score = 100
            //   e9????????           |                     
            //   8d8d00ffffff         | lea                 ecx, [ebp - 0x100]
            //   33d2                 | xor                 edx, edx
            //   a1????????           |                     
            //   8b38                 | mov                 edi, dword ptr [eax]
            //   ff570c               | call                dword ptr [edi + 0xc]
            //   8b8500ffffff         | mov                 eax, dword ptr [ebp - 0x100]

        $sequence_1 = { ff00 8d4dcc 33d2 8bc3 8b18 ff530c 8b45cc }
            // n = 7, score = 100
            //   ff00                 | inc                 dword ptr [eax]
            //   8d4dcc               | lea                 ecx, [ebp - 0x34]
            //   33d2                 | xor                 edx, edx
            //   8bc3                 | mov                 eax, ebx
            //   8b18                 | mov                 ebx, dword ptr [eax]
            //   ff530c               | call                dword ptr [ebx + 0xc]
            //   8b45cc               | mov                 eax, dword ptr [ebp - 0x34]

        $sequence_2 = { 8b45fc e8???????? 85c0 7507 b380 e9???????? ba???????? }
            // n = 7, score = 100
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7507                 | jne                 9
            //   b380                 | mov                 bl, 0x80
            //   e9????????           |                     
            //   ba????????           |                     

        $sequence_3 = { b8???????? e8???????? ffb544ffffff a1???????? ff30 8d9540ffffff b8???????? }
            // n = 7, score = 100
            //   b8????????           |                     
            //   e8????????           |                     
            //   ffb544ffffff         | push                dword ptr [ebp - 0xbc]
            //   a1????????           |                     
            //   ff30                 | push                dword ptr [eax]
            //   8d9540ffffff         | lea                 edx, [ebp - 0xc0]
            //   b8????????           |                     

        $sequence_4 = { 8b18 ff530c 8b85ecfbffff 50 8d95e8fbffff b8???????? }
            // n = 6, score = 100
            //   8b18                 | mov                 ebx, dword ptr [eax]
            //   ff530c               | call                dword ptr [ebx + 0xc]
            //   8b85ecfbffff         | mov                 eax, dword ptr [ebp - 0x414]
            //   50                   | push                eax
            //   8d95e8fbffff         | lea                 edx, [ebp - 0x418]
            //   b8????????           |                     

        $sequence_5 = { c7471844275602 a1???????? 89470c 8d4724 8bd6 e8???????? 837f2400 }
            // n = 7, score = 100
            //   c7471844275602       | mov                 dword ptr [edi + 0x18], 0x2562744
            //   a1????????           |                     
            //   89470c               | mov                 dword ptr [edi + 0xc], eax
            //   8d4724               | lea                 eax, [edi + 0x24]
            //   8bd6                 | mov                 edx, esi
            //   e8????????           |                     
            //   837f2400             | cmp                 dword ptr [edi + 0x24], 0

        $sequence_6 = { 751a 6a00 8b85d8fdffff 50 6a00 6a01 e8???????? }
            // n = 7, score = 100
            //   751a                 | jne                 0x1c
            //   6a00                 | push                0
            //   8b85d8fdffff         | mov                 eax, dword ptr [ebp - 0x228]
            //   50                   | push                eax
            //   6a00                 | push                0
            //   6a01                 | push                1
            //   e8????????           |                     

        $sequence_7 = { 33d2 a1???????? 8b18 ff530c 8b8568fbffff 50 8d9564fbffff }
            // n = 7, score = 100
            //   33d2                 | xor                 edx, edx
            //   a1????????           |                     
            //   8b18                 | mov                 ebx, dword ptr [eax]
            //   ff530c               | call                dword ptr [ebx + 0xc]
            //   8b8568fbffff         | mov                 eax, dword ptr [ebp - 0x498]
            //   50                   | push                eax
            //   8d9564fbffff         | lea                 edx, [ebp - 0x49c]

        $sequence_8 = { 8b15???????? 8902 8d8d70fbffff ba03000000 a1???????? 8b18 }
            // n = 6, score = 100
            //   8b15????????         |                     
            //   8902                 | mov                 dword ptr [edx], eax
            //   8d8d70fbffff         | lea                 ecx, [ebp - 0x490]
            //   ba03000000           | mov                 edx, 3
            //   a1????????           |                     
            //   8b18                 | mov                 ebx, dword ptr [eax]

        $sequence_9 = { 83e804 8b00 83f806 7d56 a1???????? 8b00 33d2 }
            // n = 7, score = 100
            //   83e804               | sub                 eax, 4
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   83f806               | cmp                 eax, 6
            //   7d56                 | jge                 0x58
            //   a1????????           |                     
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   33d2                 | xor                 edx, edx

    condition:
        7 of them and filesize < 9904128
}