rule win_milkmaid_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.milkmaid."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.milkmaid"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 64892500000000 83ec08 56 68???????? 8d4c2408 c744240c00000000 }
            // n = 6, score = 100
            //   64892500000000       | mov                 dword ptr fs:[0], esp
            //   83ec08               | sub                 esp, 8
            //   56                   | push                esi
            //   68????????           |                     
            //   8d4c2408             | lea                 ecx, [esp + 8]
            //   c744240c00000000     | mov                 dword ptr [esp + 0xc], 0

        $sequence_1 = { c68424dc28010002 e8???????? 8d4c2410 c68424dc28010001 }
            // n = 4, score = 100
            //   c68424dc28010002     | mov                 byte ptr [esp + 0x128dc], 2
            //   e8????????           |                     
            //   8d4c2410             | lea                 ecx, [esp + 0x10]
            //   c68424dc28010001     | mov                 byte ptr [esp + 0x128dc], 1

        $sequence_2 = { 68???????? 50 b8c8280100 64892500000000 e8???????? }
            // n = 5, score = 100
            //   68????????           |                     
            //   50                   | push                eax
            //   b8c8280100           | mov                 eax, 0x128c8
            //   64892500000000       | mov                 dword ptr fs:[0], esp
            //   e8????????           |                     

        $sequence_3 = { 8b4c240c 50 51 8d8c2480000000 }
            // n = 4, score = 100
            //   8b4c240c             | mov                 ecx, dword ptr [esp + 0xc]
            //   50                   | push                eax
            //   51                   | push                ecx
            //   8d8c2480000000       | lea                 ecx, [esp + 0x80]

        $sequence_4 = { 6a1a 6a00 ff15???????? 6aff 8d4c2408 }
            // n = 5, score = 100
            //   6a1a                 | push                0x1a
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   6aff                 | push                -1
            //   8d4c2408             | lea                 ecx, [esp + 8]

        $sequence_5 = { e8???????? 8d4c240c c78424dc280100ffffffff e8???????? 33c0 8b8c24d4280100 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   8d4c240c             | lea                 ecx, [esp + 0xc]
            //   c78424dc280100ffffffff     | mov    dword ptr [esp + 0x128dc], 0xffffffff
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   8b8c24d4280100       | mov                 ecx, dword ptr [esp + 0x128d4]

        $sequence_6 = { 33d2 eb05 8b5708 2bd1 8b5c2428 }
            // n = 5, score = 100
            //   33d2                 | xor                 edx, edx
            //   eb05                 | jmp                 7
            //   8b5708               | mov                 edx, dword ptr [edi + 8]
            //   2bd1                 | sub                 edx, ecx
            //   8b5c2428             | mov                 ebx, dword ptr [esp + 0x28]

        $sequence_7 = { c744240c00000000 e8???????? 6800010000 8d4c2408 c744241801000000 }
            // n = 5, score = 100
            //   c744240c00000000     | mov                 dword ptr [esp + 0xc], 0
            //   e8????????           |                     
            //   6800010000           | push                0x100
            //   8d4c2408             | lea                 ecx, [esp + 8]
            //   c744241801000000     | mov                 dword ptr [esp + 0x18], 1

    condition:
        7 of them and filesize < 65536
}