rule win_multigrain_pos_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.multigrain_pos."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.multigrain_pos"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 83c404 33c0 837dd408 c745bc07000000 c745b800000000 }
            // n = 6, score = 200
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   33c0                 | xor                 eax, eax
            //   837dd408             | cmp                 dword ptr [ebp - 0x2c], 8
            //   c745bc07000000       | mov                 dword ptr [ebp - 0x44], 7
            //   c745b800000000       | mov                 dword ptr [ebp - 0x48], 0

        $sequence_1 = { 50 6a00 6a02 6a10 68120000a0 }
            // n = 5, score = 200
            //   50                   | push                eax
            //   6a00                 | push                0
            //   6a02                 | push                2
            //   6a10                 | push                0x10
            //   68120000a0           | push                0xa0000012

        $sequence_2 = { 730d 0fb64c1e01 c1e905 894df4 }
            // n = 4, score = 200
            //   730d                 | jae                 0xf
            //   0fb64c1e01           | movzx               ecx, byte ptr [esi + ebx + 1]
            //   c1e905               | shr                 ecx, 5
            //   894df4               | mov                 dword ptr [ebp - 0xc], ecx

        $sequence_3 = { c745f400000000 c645e400 e8???????? 57 e8???????? 83c404 8d45e4 }
            // n = 7, score = 200
            //   c745f400000000       | mov                 dword ptr [ebp - 0xc], 0
            //   c645e400             | mov                 byte ptr [ebp - 0x1c], 0
            //   e8????????           |                     
            //   57                   | push                edi
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8d45e4               | lea                 eax, [ebp - 0x1c]

        $sequence_4 = { 8b8760040000 50 ff30 8d45fc 50 8d8f60040000 }
            // n = 6, score = 200
            //   8b8760040000         | mov                 eax, dword ptr [edi + 0x460]
            //   50                   | push                eax
            //   ff30                 | push                dword ptr [eax]
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax
            //   8d8f60040000         | lea                 ecx, [edi + 0x460]

        $sequence_5 = { 3b01 0f823efeffff 8b55f8 5f }
            // n = 4, score = 200
            //   3b01                 | cmp                 eax, dword ptr [ecx]
            //   0f823efeffff         | jb                  0xfffffe44
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   5f                   | pop                 edi

        $sequence_6 = { 8bf1 8b4710 3bc3 0f82e8000000 8b4d14 8b5610 2bc3 }
            // n = 7, score = 200
            //   8bf1                 | mov                 esi, ecx
            //   8b4710               | mov                 eax, dword ptr [edi + 0x10]
            //   3bc3                 | cmp                 eax, ebx
            //   0f82e8000000         | jb                  0xee
            //   8b4d14               | mov                 ecx, dword ptr [ebp + 0x14]
            //   8b5610               | mov                 edx, dword ptr [esi + 0x10]
            //   2bc3                 | sub                 eax, ebx

        $sequence_7 = { 1bc0 f7d8 5e 5d c20800 85f6 750f }
            // n = 7, score = 200
            //   1bc0                 | sbb                 eax, eax
            //   f7d8                 | neg                 eax
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   c20800               | ret                 8
            //   85f6                 | test                esi, esi
            //   750f                 | jne                 0x11

        $sequence_8 = { 83ec10 894df8 8bca 56 33c0 33f6 8955fc }
            // n = 7, score = 200
            //   83ec10               | sub                 esp, 0x10
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   8bca                 | mov                 ecx, edx
            //   56                   | push                esi
            //   33c0                 | xor                 eax, eax
            //   33f6                 | xor                 esi, esi
            //   8955fc               | mov                 dword ptr [ebp - 4], edx

        $sequence_9 = { c7461000000000 c7461400000000 e8???????? 894610 6800040000 8d4618 }
            // n = 6, score = 200
            //   c7461000000000       | mov                 dword ptr [esi + 0x10], 0
            //   c7461400000000       | mov                 dword ptr [esi + 0x14], 0
            //   e8????????           |                     
            //   894610               | mov                 dword ptr [esi + 0x10], eax
            //   6800040000           | push                0x400
            //   8d4618               | lea                 eax, [esi + 0x18]

    condition:
        7 of them and filesize < 286720
}