rule win_mutabaha_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.mutabaha."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mutabaha"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 68???????? 8d8d9cfdffff c645fc01 e8???????? 68???????? 8d8db4fdffff c645fc02 }
            // n = 7, score = 100
            //   68????????           |                     
            //   8d8d9cfdffff         | lea                 ecx, [ebp - 0x264]
            //   c645fc01             | mov                 byte ptr [ebp - 4], 1
            //   e8????????           |                     
            //   68????????           |                     
            //   8d8db4fdffff         | lea                 ecx, [ebp - 0x24c]
            //   c645fc02             | mov                 byte ptr [ebp - 4], 2

        $sequence_1 = { 8d45b8 50 6a00 6a16 ff15???????? 8bbd7cfdffff 8d45b8 }
            // n = 7, score = 100
            //   8d45b8               | lea                 eax, [ebp - 0x48]
            //   50                   | push                eax
            //   6a00                 | push                0
            //   6a16                 | push                0x16
            //   ff15????????         |                     
            //   8bbd7cfdffff         | mov                 edi, dword ptr [ebp - 0x284]
            //   8d45b8               | lea                 eax, [ebp - 0x48]

        $sequence_2 = { 83c40c 8d85f8f3ffff 6800040000 6a00 50 e8???????? 83c40c }
            // n = 7, score = 100
            //   83c40c               | add                 esp, 0xc
            //   8d85f8f3ffff         | lea                 eax, [ebp - 0xc08]
            //   6800040000           | push                0x400
            //   6a00                 | push                0
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_3 = { 68???????? 8bd0 c645fc29 8d8dd0feffff e8???????? 83c404 6aff }
            // n = 7, score = 100
            //   68????????           |                     
            //   8bd0                 | mov                 edx, eax
            //   c645fc29             | mov                 byte ptr [ebp - 4], 0x29
            //   8d8dd0feffff         | lea                 ecx, [ebp - 0x130]
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   6aff                 | push                -1

        $sequence_4 = { 89460c eb6a 8d0492 c1e003 50 8b450c 50 }
            // n = 7, score = 100
            //   89460c               | mov                 dword ptr [esi + 0xc], eax
            //   eb6a                 | jmp                 0x6c
            //   8d0492               | lea                 eax, [edx + edx*4]
            //   c1e003               | shl                 eax, 3
            //   50                   | push                eax
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   50                   | push                eax

        $sequence_5 = { 50 8d4dd4 0f43ce 53 e8???????? 8bb568ffffff }
            // n = 6, score = 100
            //   50                   | push                eax
            //   8d4dd4               | lea                 ecx, [ebp - 0x2c]
            //   0f43ce               | cmovae              ecx, esi
            //   53                   | push                ebx
            //   e8????????           |                     
            //   8bb568ffffff         | mov                 esi, dword ptr [ebp - 0x98]

        $sequence_6 = { 7202 8b36 56 8d85e8fdffff 68???????? 50 }
            // n = 6, score = 100
            //   7202                 | jb                  4
            //   8b36                 | mov                 esi, dword ptr [esi]
            //   56                   | push                esi
            //   8d85e8fdffff         | lea                 eax, [ebp - 0x218]
            //   68????????           |                     
            //   50                   | push                eax

        $sequence_7 = { 2bca d1f9 51 57 8d8dc4fbffff e8???????? 6a10 }
            // n = 7, score = 100
            //   2bca                 | sub                 ecx, edx
            //   d1f9                 | sar                 ecx, 1
            //   51                   | push                ecx
            //   57                   | push                edi
            //   8d8dc4fbffff         | lea                 ecx, [ebp - 0x43c]
            //   e8????????           |                     
            //   6a10                 | push                0x10

        $sequence_8 = { 6689859cfeffff 8b8598feffff c785acfeffff00000000 83f808 7213 40 8d8d84feffff }
            // n = 7, score = 100
            //   6689859cfeffff       | mov                 word ptr [ebp - 0x164], ax
            //   8b8598feffff         | mov                 eax, dword ptr [ebp - 0x168]
            //   c785acfeffff00000000     | mov    dword ptr [ebp - 0x154], 0
            //   83f808               | cmp                 eax, 8
            //   7213                 | jb                  0x15
            //   40                   | inc                 eax
            //   8d8d84feffff         | lea                 ecx, [ebp - 0x17c]

        $sequence_9 = { 762a 33c0 8a4e04 8bdf 895df0 84c9 745a }
            // n = 7, score = 100
            //   762a                 | jbe                 0x2c
            //   33c0                 | xor                 eax, eax
            //   8a4e04               | mov                 cl, byte ptr [esi + 4]
            //   8bdf                 | mov                 ebx, edi
            //   895df0               | mov                 dword ptr [ebp - 0x10], ebx
            //   84c9                 | test                cl, cl
            //   745a                 | je                  0x5c

    condition:
        7 of them and filesize < 1220608
}