rule win_new_ct_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.new_ct."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.new_ct"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c404 8b45e4 50 8b35???????? ffd6 }
            // n = 5, score = 200
            //   83c404               | add                 esp, 4
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]
            //   50                   | push                eax
            //   8b35????????         |                     
            //   ffd6                 | call                esi

        $sequence_1 = { e8???????? a3???????? 3bc3 756f 47 83ff0a 7cd4 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   a3????????           |                     
            //   3bc3                 | cmp                 eax, ebx
            //   756f                 | jne                 0x71
            //   47                   | inc                 edi
            //   83ff0a               | cmp                 edi, 0xa
            //   7cd4                 | jl                  0xffffffd6

        $sequence_2 = { ffd6 8b4c241c 51 ffd6 55 6a00 ff15???????? }
            // n = 7, score = 200
            //   ffd6                 | call                esi
            //   8b4c241c             | mov                 ecx, dword ptr [esp + 0x1c]
            //   51                   | push                ecx
            //   ffd6                 | call                esi
            //   55                   | push                ebp
            //   6a00                 | push                0
            //   ff15????????         |                     

        $sequence_3 = { 52 68???????? 8d842480000000 68???????? 50 ffd6 }
            // n = 6, score = 200
            //   52                   | push                edx
            //   68????????           |                     
            //   8d842480000000       | lea                 eax, [esp + 0x80]
            //   68????????           |                     
            //   50                   | push                eax
            //   ffd6                 | call                esi

        $sequence_4 = { 3931 740c 40 83c10c 3bc2 7cf4 33c0 }
            // n = 7, score = 200
            //   3931                 | cmp                 dword ptr [ecx], esi
            //   740c                 | je                  0xe
            //   40                   | inc                 eax
            //   83c10c               | add                 ecx, 0xc
            //   3bc2                 | cmp                 eax, edx
            //   7cf4                 | jl                  0xfffffff6
            //   33c0                 | xor                 eax, eax

        $sequence_5 = { 6a04 8d8dd4fdffff 51 6a4a }
            // n = 4, score = 200
            //   6a04                 | push                4
            //   8d8dd4fdffff         | lea                 ecx, [ebp - 0x22c]
            //   51                   | push                ecx
            //   6a4a                 | push                0x4a

        $sequence_6 = { 50 6a00 6a00 68???????? 6a00 68???????? ff15???????? }
            // n = 7, score = 200
            //   50                   | push                eax
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   68????????           |                     
            //   6a00                 | push                0
            //   68????????           |                     
            //   ff15????????         |                     

        $sequence_7 = { e8???????? 83c404 8985c4ebffff 85c0 7409 8bc8 e8???????? }
            // n = 7, score = 200
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8985c4ebffff         | mov                 dword ptr [ebp - 0x143c], eax
            //   85c0                 | test                eax, eax
            //   7409                 | je                  0xb
            //   8bc8                 | mov                 ecx, eax
            //   e8????????           |                     

        $sequence_8 = { ffd3 83c414 c745fcffffffff b801000000 }
            // n = 4, score = 200
            //   ffd3                 | call                ebx
            //   83c414               | add                 esp, 0x14
            //   c745fcffffffff       | mov                 dword ptr [ebp - 4], 0xffffffff
            //   b801000000           | mov                 eax, 1

        $sequence_9 = { 33c0 83c40c f2ae f7d1 49 6800000020 8d84247c070000 }
            // n = 7, score = 200
            //   33c0                 | xor                 eax, eax
            //   83c40c               | add                 esp, 0xc
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   f7d1                 | not                 ecx
            //   49                   | dec                 ecx
            //   6800000020           | push                0x20000000
            //   8d84247c070000       | lea                 eax, [esp + 0x77c]

    condition:
        7 of them and filesize < 122880
}