rule win_nocturnalstealer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.nocturnalstealer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nocturnalstealer"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e9???????? 53 c70424e630fe1e 890424 51 e9???????? 81f2150c9f7b }
            // n = 7, score = 100
            //   e9????????           |                     
            //   53                   | push                ebx
            //   c70424e630fe1e       | mov                 dword ptr [esp], 0x1efe30e6
            //   890424               | mov                 dword ptr [esp], eax
            //   51                   | push                ecx
            //   e9????????           |                     
            //   81f2150c9f7b         | xor                 edx, 0x7b9f0c15

        $sequence_1 = { ce f24b 0205???????? d91ca2 ac 97 8c80313ff9c1 }
            // n = 7, score = 100
            //   ce                   | into                
            //   f24b                 | dec                 ebx
            //   0205????????         |                     
            //   d91ca2               | fstp                dword ptr [edx]
            //   ac                   | lodsb               al, byte ptr [esi]
            //   97                   | xchg                eax, edi
            //   8c80313ff9c1         | mov                 word ptr [eax - 0x3e06c0cf], es

        $sequence_2 = { e9???????? 01c6 e9???????? 50 54 e9???????? 01d9 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   01c6                 | add                 esi, eax
            //   e9????????           |                     
            //   50                   | push                eax
            //   54                   | push                esp
            //   e9????????           |                     
            //   01d9                 | add                 ecx, ebx

        $sequence_3 = { e9???????? 59 c1ef01 81f7???????? 81cf424a8d6f e9???????? 52 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   59                   | pop                 ecx
            //   c1ef01               | shr                 edi, 1
            //   81f7????????         |                     
            //   81cf424a8d6f         | or                  edi, 0x6f8d4a42
            //   e9????????           |                     
            //   52                   | push                edx

        $sequence_4 = { e9???????? 50 e9???????? 8b2c24 83c404 81e801000000 0f853bffffff }
            // n = 7, score = 100
            //   e9????????           |                     
            //   50                   | push                eax
            //   e9????????           |                     
            //   8b2c24               | mov                 ebp, dword ptr [esp]
            //   83c404               | add                 esp, 4
            //   81e801000000         | sub                 eax, 1
            //   0f853bffffff         | jne                 0xffffff41

        $sequence_5 = { e9???????? f7db 81f3a7b72281 57 bf57bc7f6f 56 e9???????? }
            // n = 7, score = 100
            //   e9????????           |                     
            //   f7db                 | neg                 ebx
            //   81f3a7b72281         | xor                 ebx, 0x8122b7a7
            //   57                   | push                edi
            //   bf57bc7f6f           | mov                 edi, 0x6f7fbc57
            //   56                   | push                esi
            //   e9????????           |                     

        $sequence_6 = { ff3424 e9???????? 81e942e2bf7f 01d9 81c142e2bf7f e9???????? 872c24 }
            // n = 7, score = 100
            //   ff3424               | push                dword ptr [esp]
            //   e9????????           |                     
            //   81e942e2bf7f         | sub                 ecx, 0x7fbfe242
            //   01d9                 | add                 ecx, ebx
            //   81c142e2bf7f         | add                 ecx, 0x7fbfe242
            //   e9????????           |                     
            //   872c24               | xchg                dword ptr [esp], ebp

        $sequence_7 = { e9???????? 01ea 5d e9???????? 29c5 58 332c24 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   01ea                 | add                 edx, ebp
            //   5d                   | pop                 ebp
            //   e9????????           |                     
            //   29c5                 | sub                 ebp, eax
            //   58                   | pop                 eax
            //   332c24               | xor                 ebp, dword ptr [esp]

        $sequence_8 = { 89e0 0504000000 83e804 870424 5c 892c24 e9???????? }
            // n = 7, score = 100
            //   89e0                 | mov                 eax, esp
            //   0504000000           | add                 eax, 4
            //   83e804               | sub                 eax, 4
            //   870424               | xchg                dword ptr [esp], eax
            //   5c                   | pop                 esp
            //   892c24               | mov                 dword ptr [esp], ebp
            //   e9????????           |                     

        $sequence_9 = { e9???????? 59 52 89f2 89d0 5a e9???????? }
            // n = 7, score = 100
            //   e9????????           |                     
            //   59                   | pop                 ecx
            //   52                   | push                edx
            //   89f2                 | mov                 edx, esi
            //   89d0                 | mov                 eax, edx
            //   5a                   | pop                 edx
            //   e9????????           |                     

    condition:
        7 of them and filesize < 10739712
}