rule win_nspx30_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.nspx30."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nspx30"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { f3ab 66ab aa b06c }
            // n = 4, score = 200
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   aa                   | stosb               byte ptr es:[edi], al
            //   b06c                 | mov                 al, 0x6c

        $sequence_1 = { 0f8794000000 8088c166001004 40 ebee 8365fc00 }
            // n = 5, score = 100
            //   0f8794000000         | ja                  0x9a
            //   8088c166001004       | or                  byte ptr [eax + 0x100066c1], 4
            //   40                   | inc                 eax
            //   ebee                 | jmp                 0xfffffff0
            //   8365fc00             | and                 dword ptr [ebp - 4], 0

        $sequence_2 = { c644240e6e c644240f64 c64424106f c644241177 c644241273 88542413 }
            // n = 6, score = 100
            //   c644240e6e           | mov                 byte ptr [esp + 0xe], 0x6e
            //   c644240f64           | mov                 byte ptr [esp + 0xf], 0x64
            //   c64424106f           | mov                 byte ptr [esp + 0x10], 0x6f
            //   c644241177           | mov                 byte ptr [esp + 0x11], 0x77
            //   c644241273           | mov                 byte ptr [esp + 0x12], 0x73
            //   88542413             | mov                 byte ptr [esp + 0x13], dl

        $sequence_3 = { 6689842424010000 66899c2426010000 6689ac2428010000 6689bc242a010000 668984242c010000 66c784242e0100003200 6689842430010000 }
            // n = 7, score = 100
            //   6689842424010000     | mov                 word ptr [esp + 0x124], ax
            //   66899c2426010000     | mov                 word ptr [esp + 0x126], bx
            //   6689ac2428010000     | mov                 word ptr [esp + 0x128], bp
            //   6689bc242a010000     | mov                 word ptr [esp + 0x12a], di
            //   668984242c010000     | mov                 word ptr [esp + 0x12c], ax
            //   66c784242e0100003200     | mov    word ptr [esp + 0x12e], 0x32
            //   6689842430010000     | mov                 word ptr [esp + 0x130], ax

        $sequence_4 = { 55 8bec 8b4508 56 833c850061001000 8d348500610010 753e }
            // n = 7, score = 100
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   56                   | push                esi
            //   833c850061001000     | cmp                 dword ptr [eax*4 + 0x10006100], 0
            //   8d348500610010       | lea                 esi, [eax*4 + 0x10006100]
            //   753e                 | jne                 0x40

        $sequence_5 = { ff15???????? 83c8ff 5e c20800 6879270000 ff15???????? 83c8ff }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   83c8ff               | or                  eax, 0xffffffff
            //   5e                   | pop                 esi
            //   c20800               | ret                 8
            //   6879270000           | push                0x2779
            //   ff15????????         |                     
            //   83c8ff               | or                  eax, 0xffffffff

        $sequence_6 = { 8d7c2410 83c9ff 33c0 83c404 f2ae }
            // n = 5, score = 100
            //   8d7c2410             | lea                 edi, [esp + 0x10]
            //   83c9ff               | or                  ecx, 0xffffffff
            //   33c0                 | xor                 eax, eax
            //   83c404               | add                 esp, 4
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]

        $sequence_7 = { 33d2 b940000000 33c0 8d7c2415 88542414 f3ab 66ab }
            // n = 7, score = 100
            //   33d2                 | xor                 edx, edx
            //   b940000000           | mov                 ecx, 0x40
            //   33c0                 | xor                 eax, eax
            //   8d7c2415             | lea                 edi, [esp + 0x15]
            //   88542414             | mov                 byte ptr [esp + 0x14], dl
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   66ab                 | stosw               word ptr es:[edi], ax

        $sequence_8 = { 756c 8d84241c010000 68???????? 50 ffd6 }
            // n = 5, score = 100
            //   756c                 | jne                 0x6e
            //   8d84241c010000       | lea                 eax, [esp + 0x11c]
            //   68????????           |                     
            //   50                   | push                eax
            //   ffd6                 | call                esi

        $sequence_9 = { a3???????? 5d c3 ff15???????? 33c9 }
            // n = 5, score = 100
            //   a3????????           |                     
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   ff15????????         |                     
            //   33c9                 | xor                 ecx, ecx

        $sequence_10 = { 0c01 88443124 eb34 80c980 884c3704 8b0c9d384c0410 8a443124 }
            // n = 7, score = 100
            //   0c01                 | or                  al, 1
            //   88443124             | mov                 byte ptr [ecx + esi + 0x24], al
            //   eb34                 | jmp                 0x36
            //   80c980               | or                  cl, 0x80
            //   884c3704             | mov                 byte ptr [edi + esi + 4], cl
            //   8b0c9d384c0410       | mov                 ecx, dword ptr [ebx*4 + 0x10044c38]
            //   8a443124             | mov                 al, byte ptr [ecx + esi + 0x24]

        $sequence_11 = { 7c00 10547c00 10767c 0010 d07c0010 a0???????? 7c00 }
            // n = 7, score = 100
            //   7c00                 | jl                  2
            //   10547c00             | adc                 byte ptr [esp + edi*2], dl
            //   10767c               | adc                 byte ptr [esi + 0x7c], dh
            //   0010                 | add                 byte ptr [eax], dl
            //   d07c0010             | sar                 byte ptr [eax + eax + 0x10], 1
            //   a0????????           |                     
            //   7c00                 | jl                  2

        $sequence_12 = { aa b06c 6804010000 8844240c }
            // n = 4, score = 100
            //   aa                   | stosb               byte ptr es:[edi], al
            //   b06c                 | mov                 al, 0x6c
            // 
            //   8844240c             | mov                 byte ptr [esp + 0xc], al

        $sequence_13 = { 8bf8 8b4508 8d34c6 8d450c 50 }
            // n = 5, score = 100
            //   8bf8                 | mov                 edi, eax
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8d34c6               | lea                 esi, [esi + eax*8]
            //   8d450c               | lea                 eax, [ebp + 0xc]
            //   50                   | push                eax

        $sequence_14 = { 85c0 0f8475010000 85ff 0f846d010000 ba42000000 6a00 }
            // n = 6, score = 100
            //   85c0                 | test                eax, eax
            //   0f8475010000         | je                  0x17b
            //   85ff                 | test                edi, edi
            //   0f846d010000         | je                  0x173
            //   ba42000000           | mov                 edx, 0x42
            //   6a00                 | push                0

        $sequence_15 = { 66c78424ee0000003a00 66c78424f00000007b00 66c78424f20000004600 6689bc24f8000000 66898c24fa000000 66899424fc000000 }
            // n = 6, score = 100
            //   66c78424ee0000003a00     | mov    word ptr [esp + 0xee], 0x3a
            //   66c78424f00000007b00     | mov    word ptr [esp + 0xf0], 0x7b
            //   66c78424f20000004600     | mov    word ptr [esp + 0xf2], 0x46
            //   6689bc24f8000000     | mov                 word ptr [esp + 0xf8], di
            //   66898c24fa000000     | mov                 word ptr [esp + 0xfa], cx
            //   66899424fc000000     | mov                 word ptr [esp + 0xfc], dx

        $sequence_16 = { 03cb e8???????? f30f7e442414 660fd600 f30f7e44241c }
            // n = 5, score = 100
            //   03cb                 | add                 ecx, ebx
            //   e8????????           |                     
            //   f30f7e442414         | movq                xmm0, qword ptr [esp + 0x14]
            //   660fd600             | movq                qword ptr [eax], xmm0
            //   f30f7e44241c         | movq                xmm0, qword ptr [esp + 0x1c]

        $sequence_17 = { 8a02 83f078 05ae000000 25ff000080 7907 }
            // n = 5, score = 100
            //   8a02                 | mov                 al, byte ptr [edx]
            //   83f078               | xor                 eax, 0x78
            //   05ae000000           | add                 eax, 0xae
            //   25ff000080           | and                 eax, 0x800000ff
            //   7907                 | jns                 9

        $sequence_18 = { 88441905 8b0c95384c0410 8a45f9 88441925 8b0495384c0410 6a0a 59 }
            // n = 7, score = 100
            //   88441905             | mov                 byte ptr [ecx + ebx + 5], al
            //   8b0c95384c0410       | mov                 ecx, dword ptr [edx*4 + 0x10044c38]
            //   8a45f9               | mov                 al, byte ptr [ebp - 7]
            //   88441925             | mov                 byte ptr [ecx + ebx + 0x25], al
            //   8b0495384c0410       | mov                 eax, dword ptr [edx*4 + 0x10044c38]
            //   6a0a                 | push                0xa
            //   59                   | pop                 ecx

        $sequence_19 = { 50 c785f8fcffff9c000000 ff15???????? 85c0 0f85a6000000 8d85f8fcffff }
            // n = 6, score = 100
            //   50                   | push                eax
            //   c785f8fcffff9c000000     | mov    dword ptr [ebp - 0x308], 0x9c
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f85a6000000         | jne                 0xac
            //   8d85f8fcffff         | lea                 eax, [ebp - 0x308]

        $sequence_20 = { b801000000 5b 81c410030000 c20c00 5f 5e 33c0 }
            // n = 7, score = 100
            //   b801000000           | mov                 eax, 1
            //   5b                   | pop                 ebx
            //   81c410030000         | add                 esp, 0x310
            //   c20c00               | ret                 0xc
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   33c0                 | xor                 eax, eax

        $sequence_21 = { 6800300000 6854130000 53 50 ff15???????? 8bd0 }
            // n = 6, score = 100
            //   6800300000           | push                0x3000
            //   6854130000           | push                0x1354
            //   53                   | push                ebx
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8bd0                 | mov                 edx, eax

        $sequence_22 = { c644241e69 c644241f74 c644242050 c644242172 c64424226f c644242363 885c2424 }
            // n = 7, score = 100
            //   c644241e69           | mov                 byte ptr [esp + 0x1e], 0x69
            //   c644241f74           | mov                 byte ptr [esp + 0x1f], 0x74
            //   c644242050           | mov                 byte ptr [esp + 0x20], 0x50
            //   c644242172           | mov                 byte ptr [esp + 0x21], 0x72
            //   c64424226f           | mov                 byte ptr [esp + 0x22], 0x6f
            //   c644242363           | mov                 byte ptr [esp + 0x23], 0x63
            //   885c2424             | mov                 byte ptr [esp + 0x24], bl

        $sequence_23 = { 8945a0 681bc64679 8b55f8 52 }
            // n = 4, score = 100
            //   8945a0               | mov                 dword ptr [ebp - 0x60], eax
            //   681bc64679           | push                0x7946c61b
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   52                   | push                edx

        $sequence_24 = { c7459400000000 c745ec00000000 eb09 8b45ec }
            // n = 4, score = 100
            //   c7459400000000       | mov                 dword ptr [ebp - 0x6c], 0
            //   c745ec00000000       | mov                 dword ptr [ebp - 0x14], 0
            //   eb09                 | jmp                 0xb
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]

        $sequence_25 = { 8b08 8b55e0 895134 8b450c 50 8b4dfc }
            // n = 6, score = 100
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   8b55e0               | mov                 edx, dword ptr [ebp - 0x20]
            //   895134               | mov                 dword ptr [ecx + 0x34], edx
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   50                   | push                eax
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]

        $sequence_26 = { 8bd8 8b6c2418 85ed 762a 8b4c241c 51 55 }
            // n = 7, score = 100
            //   8bd8                 | mov                 ebx, eax
            //   8b6c2418             | mov                 ebp, dword ptr [esp + 0x18]
            //   85ed                 | test                ebp, ebp
            //   762a                 | jbe                 0x2c
            //   8b4c241c             | mov                 ecx, dword ptr [esp + 0x1c]
            //   51                   | push                ecx
            //   55                   | push                ebp

        $sequence_27 = { 57 b904000000 bf???????? 33c0 f3a7 }
            // n = 5, score = 100
            //   57                   | push                edi
            //   b904000000           | mov                 ecx, 4
            //   bf????????           |                     
            //   33c0                 | xor                 eax, eax
            //   f3a7                 | repe cmpsd          dword ptr [esi], dword ptr es:[edi]

        $sequence_28 = { a880 741d 8b4b24 85c9 7616 8b4fe4 }
            // n = 6, score = 100
            //   a880                 | test                al, 0x80
            //   741d                 | je                  0x1f
            //   8b4b24               | mov                 ecx, dword ptr [ebx + 0x24]
            //   85c9                 | test                ecx, ecx
            //   7616                 | jbe                 0x18
            //   8b4fe4               | mov                 ecx, dword ptr [edi - 0x1c]

        $sequence_29 = { 8b4dfc 890d???????? 8b15???????? 813a0c010000 730e c705????????00000000 33c0 }
            // n = 7, score = 100
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   890d????????         |                     
            //   8b15????????         |                     
            //   813a0c010000         | cmp                 dword ptr [edx], 0x10c
            //   730e                 | jae                 0x10
            //   c705????????00000000     |     
            //   33c0                 | xor                 eax, eax

        $sequence_30 = { 8d7c240c 83c9ff 33c0 c644240c57 c644240d69 }
            // n = 5, score = 100
            //   8d7c240c             | lea                 edi, [esp + 0xc]
            //   83c9ff               | or                  ecx, 0xffffffff
            //   33c0                 | xor                 eax, eax
            //   c644240c57           | mov                 byte ptr [esp + 0xc], 0x57
            //   c644240d69           | mov                 byte ptr [esp + 0xd], 0x69

    condition:
        7 of them and filesize < 3789824
}