rule win_nullmixer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.nullmixer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nullmixer"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0b45d0 0f8436ffffff 837db840 7475 89f0 8d7728 83c302 }
            // n = 7, score = 100
            //   0b45d0               | or                  eax, dword ptr [ebp - 0x30]
            //   0f8436ffffff         | je                  0xffffff3c
            //   837db840             | cmp                 dword ptr [ebp - 0x48], 0x40
            //   7475                 | je                  0x77
            //   89f0                 | mov                 eax, esi
            //   8d7728               | lea                 esi, [edi + 0x28]
            //   83c302               | add                 ebx, 2

        $sequence_1 = { 8b4508 8b7518 894db0 8d4dcf 8945bc 8b450c 8945b4 }
            // n = 7, score = 100
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b7518               | mov                 esi, dword ptr [ebp + 0x18]
            //   894db0               | mov                 dword ptr [ebp - 0x50], ecx
            //   8d4dcf               | lea                 ecx, [ebp - 0x31]
            //   8945bc               | mov                 dword ptr [ebp - 0x44], eax
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8945b4               | mov                 dword ptr [ebp - 0x4c], eax

        $sequence_2 = { 807dcf01 0f8447030000 8b4520 c70000000000 c7400400000000 8b451c c70004000000 }
            // n = 7, score = 100
            //   807dcf01             | cmp                 byte ptr [ebp - 0x31], 1
            //   0f8447030000         | je                  0x34d
            //   8b4520               | mov                 eax, dword ptr [ebp + 0x20]
            //   c70000000000         | mov                 dword ptr [eax], 0
            //   c7400400000000       | mov                 dword ptr [eax + 4], 0
            //   8b451c               | mov                 eax, dword ptr [ebp + 0x1c]
            //   c70004000000         | mov                 dword ptr [eax], 4

        $sequence_3 = { 0fb61c37 8d4508 e8???????? 38c3 0f851cfeffff 8b4d08 83c601 }
            // n = 7, score = 100
            //   0fb61c37             | movzx               ebx, byte ptr [edi + esi]
            //   8d4508               | lea                 eax, [ebp + 8]
            //   e8????????           |                     
            //   38c3                 | cmp                 bl, al
            //   0f851cfeffff         | jne                 0xfffffe22
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   83c601               | add                 esi, 1

        $sequence_4 = { 8b842498000000 895c2404 6631db 89442418 8b842494000000 89442414 8b842490000000 }
            // n = 7, score = 100
            //   8b842498000000       | mov                 eax, dword ptr [esp + 0x98]
            //   895c2404             | mov                 dword ptr [esp + 4], ebx
            //   6631db               | xor                 bx, bx
            //   89442418             | mov                 dword ptr [esp + 0x18], eax
            //   8b842494000000       | mov                 eax, dword ptr [esp + 0x94]
            //   89442414             | mov                 dword ptr [esp + 0x14], eax
            //   8b842490000000       | mov                 eax, dword ptr [esp + 0x90]

        $sequence_5 = { 89ce 0f85a8080000 38d0 0f845d080000 8b4d08 0fb7750c 85c9 }
            // n = 7, score = 100
            //   89ce                 | mov                 esi, ecx
            //   0f85a8080000         | jne                 0x8ae
            //   38d0                 | cmp                 al, dl
            //   0f845d080000         | je                  0x863
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   0fb7750c             | movzx               esi, word ptr [ebp + 0xc]
            //   85c9                 | test                ecx, ecx

        $sequence_6 = { 83ec04 84c0 740a 8b8424c4000000 830802 0fb744247c 8b7c2478 }
            // n = 7, score = 100
            //   83ec04               | sub                 esp, 4
            //   84c0                 | test                al, al
            //   740a                 | je                  0xc
            //   8b8424c4000000       | mov                 eax, dword ptr [esp + 0xc4]
            //   830802               | or                  dword ptr [eax], 2
            //   0fb744247c           | movzx               eax, word ptr [esp + 0x7c]
            //   8b7c2478             | mov                 edi, dword ptr [esp + 0x78]

        $sequence_7 = { 55 57 56 53 8b442418 8b7904 8b74241c }
            // n = 7, score = 100
            //   55                   | push                ebp
            //   57                   | push                edi
            //   56                   | push                esi
            //   53                   | push                ebx
            //   8b442418             | mov                 eax, dword ptr [esp + 0x18]
            //   8b7904               | mov                 edi, dword ptr [ecx + 4]
            //   8b74241c             | mov                 esi, dword ptr [esp + 0x1c]

        $sequence_8 = { 89c6 8b00 8b4010 3d???????? 0f8598030000 8d45d9 8d4ddc }
            // n = 7, score = 100
            //   89c6                 | mov                 esi, eax
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   8b4010               | mov                 eax, dword ptr [eax + 0x10]
            //   3d????????           |                     
            //   0f8598030000         | jne                 0x39e
            //   8d45d9               | lea                 eax, [ebp - 0x27]
            //   8d4ddc               | lea                 ecx, [ebp - 0x24]

        $sequence_9 = { e8???????? 89c3 893424 89d9 e8???????? 83ec04 8d45e0 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   89c3                 | mov                 ebx, eax
            //   893424               | mov                 dword ptr [esp], esi
            //   89d9                 | mov                 ecx, ebx
            //   e8????????           |                     
            //   83ec04               | sub                 esp, 4
            //   8d45e0               | lea                 eax, [ebp - 0x20]

    condition:
        7 of them and filesize < 2351104
}