rule win_obscene_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.obscene."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.obscene"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 68ff000000 ff15???????? 8d8500ffffff 50 68???????? }
            // n = 6, score = 100
            //   50                   | push                eax
            //   68ff000000           | push                0xff
            //   ff15????????         |                     
            //   8d8500ffffff         | lea                 eax, [ebp - 0x100]
            //   50                   | push                eax
            //   68????????           |                     

        $sequence_1 = { 6aff ff15???????? 68???????? ff75f8 }
            // n = 4, score = 100
            //   6aff                 | push                -1
            //   ff15????????         |                     
            //   68????????           |                     
            //   ff75f8               | push                dword ptr [ebp - 8]

        $sequence_2 = { 0fbe00 83f830 7c0b 8b45f8 }
            // n = 4, score = 100
            //   0fbe00               | movsx               eax, byte ptr [eax]
            //   83f830               | cmp                 eax, 0x30
            //   7c0b                 | jl                  0xd
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]

        $sequence_3 = { 6828431010 68e4401010 e8???????? 59 59 682c431010 }
            // n = 6, score = 100
            //   6828431010           | push                0x10104328
            //   68e4401010           | push                0x101040e4
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   682c431010           | push                0x1010432c

        $sequence_4 = { 6a06 68???????? ff35???????? 6aff ff15???????? 68???????? }
            // n = 6, score = 100
            //   6a06                 | push                6
            //   68????????           |                     
            //   ff35????????         |                     
            //   6aff                 | push                -1
            //   ff15????????         |                     
            //   68????????           |                     

        $sequence_5 = { eb61 68???????? 68???????? 68???????? e8???????? 83c40c 68???????? }
            // n = 7, score = 100
            //   eb61                 | jmp                 0x63
            //   68????????           |                     
            //   68????????           |                     
            //   68????????           |                     
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   68????????           |                     

        $sequence_6 = { ff15???????? 59 59 85c0 752f ff7508 68???????? }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax
            //   752f                 | jne                 0x31
            //   ff7508               | push                dword ptr [ebp + 8]
            //   68????????           |                     

        $sequence_7 = { ff75ee ff15???????? 0fb7c0 83f819 }
            // n = 4, score = 100
            //   ff75ee               | push                dword ptr [ebp - 0x12]
            //   ff15????????         |                     
            //   0fb7c0               | movzx               eax, ax
            //   83f819               | cmp                 eax, 0x19

        $sequence_8 = { c605????????68 c705????????d15aaa00 c605????????c3 8d45fc 50 6a06 }
            // n = 6, score = 100
            //   c605????????68       |                     
            //   c705????????d15aaa00     |     
            //   c605????????c3       |                     
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax
            //   6a06                 | push                6

        $sequence_9 = { 51 51 8d45f8 50 6a06 68???????? ff35???????? }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   51                   | push                ecx
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   50                   | push                eax
            //   6a06                 | push                6
            //   68????????           |                     
            //   ff35????????         |                     

    condition:
        7 of them and filesize < 2170880
}