rule win_oski_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.oski."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.oski"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 a1???????? 50 8d8df0feffff }
            // n = 4, score = 1100
            //   50                   | push                eax
            //   a1????????           |                     
            //   50                   | push                eax
            //   8d8df0feffff         | lea                 ecx, [ebp - 0x110]

        $sequence_1 = { 25ff7f0000 c3 8bff 55 8bec 83ec14 ff7510 }
            // n = 7, score = 1000
            //   25ff7f0000           | and                 eax, 0x7fff
            //   c3                   | ret                 
            //   8bff                 | mov                 edi, edi
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83ec14               | sub                 esp, 0x14
            //   ff7510               | push                dword ptr [ebp + 0x10]

        $sequence_2 = { e8???????? 83c40c e8???????? 50 a1???????? }
            // n = 5, score = 900
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   e8????????           |                     
            //   50                   | push                eax
            //   a1????????           |                     

        $sequence_3 = { 8975f0 e8???????? cc 8bff 55 8bec 8b550c }
            // n = 7, score = 900
            //   8975f0               | mov                 dword ptr [ebp - 0x10], esi
            //   e8????????           |                     
            //   cc                   | int3                
            //   8bff                 | mov                 edi, edi
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]

        $sequence_4 = { 0f8584fbffff 668b8590fbffff 83431810 66898568fbffff }
            // n = 4, score = 800
            //   0f8584fbffff         | jne                 0xfffffb8a
            //   668b8590fbffff       | mov                 ax, word ptr [ebp - 0x470]
            //   83431810             | add                 dword ptr [ebx + 0x18], 0x10
            //   66898568fbffff       | mov                 word ptr [ebp - 0x498], ax

        $sequence_5 = { 85c0 7557 8bb54ce0ffff 8b8d48e0ffff }
            // n = 4, score = 800
            //   85c0                 | test                eax, eax
            //   7557                 | jne                 0x59
            //   8bb54ce0ffff         | mov                 esi, dword ptr [ebp - 0x1fb4]
            //   8b8d48e0ffff         | mov                 ecx, dword ptr [ebp - 0x1fb8]

        $sequence_6 = { 50 ff15???????? e8???????? 57 ff15???????? 8b4df8 }
            // n = 6, score = 800
            //   50                   | push                eax
            //   ff15????????         |                     
            //   e8????????           |                     
            //   57                   | push                edi
            //   ff15????????         |                     
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]

        $sequence_7 = { 85c0 0f8468010000 ff15???????? 8bf0 }
            // n = 4, score = 800
            //   85c0                 | test                eax, eax
            //   0f8468010000         | je                  0x16e
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax

        $sequence_8 = { 83c40c 8d959cfbffff 52 8d85dcfcffff 50 }
            // n = 5, score = 800
            //   83c40c               | add                 esp, 0xc
            //   8d959cfbffff         | lea                 edx, [ebp - 0x464]
            //   52                   | push                edx
            //   8d85dcfcffff         | lea                 eax, [ebp - 0x324]
            //   50                   | push                eax

        $sequence_9 = { f3c3 e9???????? 8bff 55 8bec 83ec1c a1???????? }
            // n = 7, score = 800
            //   f3c3                 | ret                 
            //   e9????????           |                     
            //   8bff                 | mov                 edi, edi
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83ec1c               | sub                 esp, 0x1c
            //   a1????????           |                     

        $sequence_10 = { 8b511c 83c220 52 6a00 }
            // n = 4, score = 400
            //   8b511c               | mov                 edx, dword ptr [ecx + 0x1c]
            //   83c220               | add                 edx, 0x20
            //   52                   | push                edx
            //   6a00                 | push                0

        $sequence_11 = { 8d45fc 50 8d4df8 51 6800020000 8b55f4 52 }
            // n = 7, score = 400
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax
            //   8d4df8               | lea                 ecx, [ebp - 8]
            //   51                   | push                ecx
            //   6800020000           | push                0x200
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   52                   | push                edx

        $sequence_12 = { 83c404 8b55f8 8955f4 8b45f4 50 e8???????? }
            // n = 6, score = 400
            //   83c404               | add                 esp, 4
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   8955f4               | mov                 dword ptr [ebp - 0xc], edx
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_13 = { 8b45f4 50 e8???????? 83c404 8b0d???????? 51 ff15???????? }
            // n = 7, score = 400
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8b0d????????         |                     
            //   51                   | push                ecx
            //   ff15????????         |                     

        $sequence_14 = { 68???????? 6a00 e8???????? 83c40c 8985e4fdffff }
            // n = 5, score = 400
            //   68????????           |                     
            //   6a00                 | push                0
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8985e4fdffff         | mov                 dword ptr [ebp - 0x21c], eax

        $sequence_15 = { 6800020000 8b55f4 52 ff15???????? 8945f0 837df000 }
            // n = 6, score = 400
            //   6800020000           | push                0x200
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   837df000             | cmp                 dword ptr [ebp - 0x10], 0

        $sequence_16 = { 8d55f4 52 6a00 68???????? ff15???????? 8945f0 837df000 }
            // n = 7, score = 400
            //   8d55f4               | lea                 edx, [ebp - 0xc]
            //   52                   | push                edx
            //   6a00                 | push                0
            //   68????????           |                     
            //   ff15????????         |                     
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   837df000             | cmp                 dword ptr [ebp - 0x10], 0

    condition:
        7 of them and filesize < 423936
}