rule win_phandoor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.phandoor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.phandoor"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 833d????????00 0f84ea000000 833d????????00 0f84dd000000 833d????????00 0f84d0000000 }
            // n = 6, score = 800
            //   833d????????00       |                     
            //   0f84ea000000         | je                  0xf0
            //   833d????????00       |                     
            //   0f84dd000000         | je                  0xe3
            //   833d????????00       |                     
            //   0f84d0000000         | je                  0xd6

        $sequence_1 = { 57 750c 8b36 e8???????? 83c404 eb25 }
            // n = 6, score = 800
            //   57                   | push                edi
            //   750c                 | jne                 0xe
            //   8b36                 | mov                 esi, dword ptr [esi]
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   eb25                 | jmp                 0x27

        $sequence_2 = { 50 ffd3 8bf8 85ff 0f84c6010000 }
            // n = 5, score = 800
            //   50                   | push                eax
            //   ffd3                 | call                ebx
            //   8bf8                 | mov                 edi, eax
            //   85ff                 | test                edi, edi
            //   0f84c6010000         | je                  0x1cc

        $sequence_3 = { b9???????? 8975fc 8975f8 8975f4 8975f0 }
            // n = 5, score = 800
            //   b9????????           |                     
            //   8975fc               | mov                 dword ptr [ebp - 4], esi
            //   8975f8               | mov                 dword ptr [ebp - 8], esi
            //   8975f4               | mov                 dword ptr [ebp - 0xc], esi
            //   8975f0               | mov                 dword ptr [ebp - 0x10], esi

        $sequence_4 = { e8???????? 83c404 8d55fc 8bf0 52 56 }
            // n = 6, score = 800
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8d55fc               | lea                 edx, [ebp - 4]
            //   8bf0                 | mov                 esi, eax
            //   52                   | push                edx
            //   56                   | push                esi

        $sequence_5 = { 833d????????00 0f8404010000 833d????????00 0f84f7000000 }
            // n = 4, score = 800
            //   833d????????00       |                     
            //   0f8404010000         | je                  0x10a
            //   833d????????00       |                     
            //   0f84f7000000         | je                  0xfd

        $sequence_6 = { 8bd9 c1ea08 c1eb10 22da }
            // n = 4, score = 800
            //   8bd9                 | mov                 ebx, ecx
            //   c1ea08               | shr                 edx, 8
            //   c1eb10               | shr                 ebx, 0x10
            //   22da                 | and                 bl, dl

        $sequence_7 = { 0fb6843e94010000 50 b9???????? e8???????? 50 53 e8???????? }
            // n = 7, score = 800
            //   0fb6843e94010000     | movzx               eax, byte ptr [esi + edi + 0x194]
            //   50                   | push                eax
            //   b9????????           |                     
            //   e8????????           |                     
            //   50                   | push                eax
            //   53                   | push                ebx
            //   e8????????           |                     

        $sequence_8 = { 85c0 7502 5f c3 8a08 84c9 }
            // n = 6, score = 500
            //   85c0                 | test                eax, eax
            //   7502                 | jne                 4
            //   5f                   | pop                 edi
            //   c3                   | ret                 
            //   8a08                 | mov                 cl, byte ptr [eax]
            //   84c9                 | test                cl, cl

        $sequence_9 = { 83c624 833e00 75ea 85c0 }
            // n = 4, score = 500
            //   83c624               | add                 esi, 0x24
            //   833e00               | cmp                 dword ptr [esi], 0
            //   75ea                 | jne                 0xffffffec
            //   85c0                 | test                eax, eax

        $sequence_10 = { 83c002 89b5e0eeffff 33c9 8975fc }
            // n = 4, score = 500
            //   83c002               | add                 eax, 2
            //   89b5e0eeffff         | mov                 dword ptr [ebp - 0x1120], esi
            //   33c9                 | xor                 ecx, ecx
            //   8975fc               | mov                 dword ptr [ebp - 4], esi

        $sequence_11 = { 83c604 81fe???????? 7ceb 5f b801000000 }
            // n = 5, score = 500
            //   83c604               | add                 esi, 4
            //   81fe????????         |                     
            //   7ceb                 | jl                  0xffffffed
            //   5f                   | pop                 edi
            //   b801000000           | mov                 eax, 1

        $sequence_12 = { 43 84c0 7409 8803 }
            // n = 4, score = 500
            //   43                   | inc                 ebx
            //   84c0                 | test                al, al
            //   7409                 | je                  0xb
            //   8803                 | mov                 byte ptr [ebx], al

        $sequence_13 = { 3acb 740e 50 ffd6 8a08 84c9 }
            // n = 6, score = 500
            //   3acb                 | cmp                 cl, bl
            //   740e                 | je                  0x10
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   8a08                 | mov                 cl, byte ptr [eax]
            //   84c9                 | test                cl, cl

        $sequence_14 = { 83c604 e8???????? 57 8bf0 }
            // n = 4, score = 500
            //   83c604               | add                 esi, 4
            //   e8????????           |                     
            //   57                   | push                edi
            //   8bf0                 | mov                 esi, eax

        $sequence_15 = { 56 8b7308 85f6 7420 57 }
            // n = 5, score = 500
            //   56                   | push                esi
            //   8b7308               | mov                 esi, dword ptr [ebx + 8]
            //   85f6                 | test                esi, esi
            //   7420                 | je                  0x22
            //   57                   | push                edi

    condition:
        7 of them and filesize < 2124800
}