rule win_play_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.play."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.play"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 80c316 befcffffff 8ac3 02db 02c3 02c7 008528feffff }
            // n = 7, score = 100
            //   80c316               | add                 bl, 0x16
            //   befcffffff           | mov                 esi, 0xfffffffc
            //   8ac3                 | mov                 al, bl
            //   02db                 | add                 bl, bl
            //   02c3                 | add                 al, bl
            //   02c7                 | add                 al, bh
            //   008528feffff         | add                 byte ptr [ebp - 0x1d8], al

        $sequence_1 = { 6804010000 50 e8???????? 8b95acfdffff 8d8dc8fdffff }
            // n = 5, score = 100
            //   6804010000           | push                0x104
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b95acfdffff         | mov                 edx, dword ptr [ebp - 0x254]
            //   8d8dc8fdffff         | lea                 ecx, [ebp - 0x238]

        $sequence_2 = { f30f7e05???????? 660fd685d8fcffff 0f1005???????? c68508fdffff00 c68566fdffff4f 0f11857cfcffff }
            // n = 6, score = 100
            //   f30f7e05????????     |                     
            //   660fd685d8fcffff     | movq                qword ptr [ebp - 0x328], xmm0
            //   0f1005????????       |                     
            //   c68508fdffff00       | mov                 byte ptr [ebp - 0x2f8], 0
            //   c68566fdffff4f       | mov                 byte ptr [ebp - 0x29a], 0x4f
            //   0f11857cfcffff       | movups              xmmword ptr [ebp - 0x384], xmm0

        $sequence_3 = { 99 8bf8 8d45c8 83c7ff 50 83d2ff 83ec08 }
            // n = 7, score = 100
            //   99                   | cdq                 
            //   8bf8                 | mov                 edi, eax
            //   8d45c8               | lea                 eax, [ebp - 0x38]
            //   83c7ff               | add                 edi, -1
            //   50                   | push                eax
            //   83d2ff               | adc                 edx, -1
            //   83ec08               | sub                 esp, 8

        $sequence_4 = { 8b5df8 8bd3 e8???????? 0fb67dbe 8bd3 8b4de4 }
            // n = 6, score = 100
            //   8b5df8               | mov                 ebx, dword ptr [ebp - 8]
            //   8bd3                 | mov                 edx, ebx
            //   e8????????           |                     
            //   0fb67dbe             | movzx               edi, byte ptr [ebp - 0x42]
            //   8bd3                 | mov                 edx, ebx
            //   8b4de4               | mov                 ecx, dword ptr [ebp - 0x1c]

        $sequence_5 = { 000f 843402 0000 83ec04 b021 b24c }
            // n = 6, score = 100
            //   000f                 | add                 byte ptr [edi], cl
            //   843402               | test                byte ptr [edx + eax], dh
            //   0000                 | add                 byte ptr [eax], al
            //   83ec04               | sub                 esp, 4
            //   b021                 | mov                 al, 0x21
            //   b24c                 | mov                 dl, 0x4c

        $sequence_6 = { e9???????? 0fb7cb 81f97e0e0000 7645 8a95cffeffff 81c182f1ffff }
            // n = 6, score = 100
            //   e9????????           |                     
            //   0fb7cb               | movzx               ecx, bx
            //   81f97e0e0000         | cmp                 ecx, 0xe7e
            //   7645                 | jbe                 0x47
            //   8a95cffeffff         | mov                 dl, byte ptr [ebp - 0x131]
            //   81c182f1ffff         | add                 ecx, 0xfffff182

        $sequence_7 = { 8945e8 0fb705???????? 668945ec a1???????? }
            // n = 4, score = 100
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   0fb705????????       |                     
            //   668945ec             | mov                 word ptr [ebp - 0x14], ax
            //   a1????????           |                     

        $sequence_8 = { 0fb705???????? 660fd68584fdffff f30f7e05???????? 660fd68578fdffff 0f1005???????? 668985b4fdffff }
            // n = 6, score = 100
            //   0fb705????????       |                     
            //   660fd68584fdffff     | movq                qword ptr [ebp - 0x27c], xmm0
            //   f30f7e05????????     |                     
            //   660fd68578fdffff     | movq                qword ptr [ebp - 0x288], xmm0
            //   0f1005????????       |                     
            //   668985b4fdffff       | mov                 word ptr [ebp - 0x24c], ax

        $sequence_9 = { 8b85a8fdffff 6603fb 6640 6689bd04feffff 8985a8fdffff 41 66898588fdffff }
            // n = 7, score = 100
            //   8b85a8fdffff         | mov                 eax, dword ptr [ebp - 0x258]
            //   6603fb               | add                 di, bx
            //   6640                 | inc                 ax
            //   6689bd04feffff       | mov                 word ptr [ebp - 0x1fc], di
            //   8985a8fdffff         | mov                 dword ptr [ebp - 0x258], eax
            //   41                   | inc                 ecx
            //   66898588fdffff       | mov                 word ptr [ebp - 0x278], ax

    condition:
        7 of them and filesize < 389120
}