rule win_plead_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.plead."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.plead"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 6a01 ff15???????? 83c40c 85c0 7504 33c0 }
            // n = 7, score = 900
            //   50                   | push                eax
            //   6a01                 | push                1
            //   ff15????????         |                     
            //   83c40c               | add                 esp, 0xc
            //   85c0                 | test                eax, eax
            //   7504                 | jne                 6
            //   33c0                 | xor                 eax, eax

        $sequence_1 = { 83c40c 8d4514 53 50 56 }
            // n = 5, score = 900
            //   83c40c               | add                 esp, 0xc
            //   8d4514               | lea                 eax, [ebp + 0x14]
            //   53                   | push                ebx
            //   50                   | push                eax
            //   56                   | push                esi

        $sequence_2 = { ff15???????? 85c0 750c c745fcfbffffff }
            // n = 4, score = 900
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   750c                 | jne                 0xe
            //   c745fcfbffffff       | mov                 dword ptr [ebp - 4], 0xfffffffb

        $sequence_3 = { 85c0 7504 33c0 eb09 56 50 }
            // n = 6, score = 900
            //   85c0                 | test                eax, eax
            //   7504                 | jne                 6
            //   33c0                 | xor                 eax, eax
            //   eb09                 | jmp                 0xb
            //   56                   | push                esi
            //   50                   | push                eax

        $sequence_4 = { ebda 33f6 c745fcf8ffffff 3bf7 750c 895dfc }
            // n = 6, score = 900
            //   ebda                 | jmp                 0xffffffdc
            //   33f6                 | xor                 esi, esi
            //   c745fcf8ffffff       | mov                 dword ptr [ebp - 4], 0xfffffff8
            //   3bf7                 | cmp                 esi, edi
            //   750c                 | jne                 0xe
            //   895dfc               | mov                 dword ptr [ebp - 4], ebx

        $sequence_5 = { 59 894510 0f878f000000 3bc3 0f8482000000 }
            // n = 5, score = 900
            //   59                   | pop                 ecx
            //   894510               | mov                 dword ptr [ebp + 0x10], eax
            //   0f878f000000         | ja                  0x95
            //   3bc3                 | cmp                 eax, ebx
            //   0f8482000000         | je                  0x88

        $sequence_6 = { 85c0 750f 56 ff15???????? 6afe 58 e9???????? }
            // n = 7, score = 900
            //   85c0                 | test                eax, eax
            //   750f                 | jne                 0x11
            //   56                   | push                esi
            //   ff15????????         |                     
            //   6afe                 | push                -2
            //   58                   | pop                 eax
            //   e9????????           |                     

        $sequence_7 = { e8???????? 817d14e8030000 53 56 }
            // n = 4, score = 900
            //   e8????????           |                     
            //   817d14e8030000       | cmp                 dword ptr [ebp + 0x14], 0x3e8
            //   53                   | push                ebx
            //   56                   | push                esi

        $sequence_8 = { 81ec1c020000 53 56 57 8965f0 ff15???????? 8bd8 }
            // n = 7, score = 600
            //   81ec1c020000         | sub                 esp, 0x21c
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   8965f0               | mov                 dword ptr [ebp - 0x10], esp
            //   ff15????????         |                     
            //   8bd8                 | mov                 ebx, eax

        $sequence_9 = { 8a10 03f2 40 49 8975fc 75ec 8bc6 }
            // n = 7, score = 600
            //   8a10                 | mov                 dl, byte ptr [eax]
            //   03f2                 | add                 esi, edx
            //   40                   | inc                 eax
            //   49                   | dec                 ecx
            //   8975fc               | mov                 dword ptr [ebp - 4], esi
            //   75ec                 | jne                 0xffffffee
            //   8bc6                 | mov                 eax, esi

        $sequence_10 = { 50 f3ab c705????????01000000 ff15???????? 8b1d???????? ffd3 8bf8 }
            // n = 7, score = 600
            //   50                   | push                eax
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   c705????????01000000     |     
            //   ff15????????         |                     
            //   8b1d????????         |                     
            //   ffd3                 | call                ebx
            //   8bf8                 | mov                 edi, eax

        $sequence_11 = { 8b942428020000 8b842424020000 52 50 51 8b8c2428020000 }
            // n = 6, score = 600
            //   8b942428020000       | mov                 edx, dword ptr [esp + 0x228]
            //   8b842424020000       | mov                 eax, dword ptr [esp + 0x224]
            //   52                   | push                edx
            //   50                   | push                eax
            //   51                   | push                ecx
            //   8b8c2428020000       | mov                 ecx, dword ptr [esp + 0x228]

        $sequence_12 = { 5d 8a44341c 32c2 8844341c 46 3bf1 }
            // n = 6, score = 600
            //   5d                   | pop                 ebp
            //   8a44341c             | mov                 al, byte ptr [esp + esi + 0x1c]
            //   32c2                 | xor                 al, dl
            //   8844341c             | mov                 byte ptr [esp + esi + 0x1c], al
            //   46                   | inc                 esi
            //   3bf1                 | cmp                 esi, ecx

        $sequence_13 = { 52 ff15???????? 6aff a1???????? }
            // n = 4, score = 600
            //   52                   | push                edx
            //   ff15????????         |                     
            //   6aff                 | push                -1
            //   a1????????           |                     

        $sequence_14 = { 8b8c241c020000 68???????? 51 ff15???????? 33c0 81c418020000 c21000 }
            // n = 7, score = 600
            //   8b8c241c020000       | mov                 ecx, dword ptr [esp + 0x21c]
            //   68????????           |                     
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   33c0                 | xor                 eax, eax
            //   81c418020000         | add                 esp, 0x218
            //   c21000               | ret                 0x10

        $sequence_15 = { 8d7c241c 6804010000 52 50 }
            // n = 4, score = 600
            //   8d7c241c             | lea                 edi, [esp + 0x1c]
            //   6804010000           | push                0x104
            //   52                   | push                edx
            //   50                   | push                eax

        $sequence_16 = { 648b1530000000 8b520c 8b521c 8b5a08 }
            // n = 4, score = 200
            //   648b1530000000       | mov                 edx, dword ptr fs:[0x30]
            //   8b520c               | mov                 edx, dword ptr [edx + 0xc]
            //   8b521c               | mov                 edx, dword ptr [edx + 0x1c]
            //   8b5a08               | mov                 ebx, dword ptr [edx + 8]

        $sequence_17 = { 833f00 7420 85db 7505 bb50000000 }
            // n = 5, score = 100
            //   833f00               | cmp                 dword ptr [edi], 0
            //   7420                 | je                  0x22
            //   85db                 | test                ebx, ebx
            //   7505                 | jne                 7
            //   bb50000000           | mov                 ebx, 0x50

        $sequence_18 = { 6a04 6800200000 ff7750 50 ff5644 }
            // n = 5, score = 100
            //   6a04                 | push                4
            //   6800200000           | push                0x2000
            //   ff7750               | push                dword ptr [edi + 0x50]
            //   50                   | push                eax
            //   ff5644               | call                dword ptr [esi + 0x44]

        $sequence_19 = { 51 035b3c 894334 e8???????? 8b45f8 }
            // n = 5, score = 100
            //   51                   | push                ecx
            //   035b3c               | add                 ebx, dword ptr [ebx + 0x3c]
            //   894334               | mov                 dword ptr [ebx + 0x34], eax
            //   e8????????           |                     
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]

        $sequence_20 = { 89048a 8945ec 8b567c 895004 c7467c00000000 }
            // n = 5, score = 100
            //   89048a               | mov                 dword ptr [edx + ecx*4], eax
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   8b567c               | mov                 edx, dword ptr [esi + 0x7c]
            //   895004               | mov                 dword ptr [eax + 4], edx
            //   c7467c00000000       | mov                 dword ptr [esi + 0x7c], 0

        $sequence_21 = { e8???????? b02c aa 8b4510 85c0 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   b02c                 | mov                 al, 0x2c
            //   aa                   | stosb               byte ptr es:[edi], al
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   85c0                 | test                eax, eax

        $sequence_22 = { 85c0 0f849f020000 8945f0 6a0c 8d4de0 }
            // n = 5, score = 100
            //   85c0                 | test                eax, eax
            //   0f849f020000         | je                  0x2a5
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   6a0c                 | push                0xc
            //   8d4de0               | lea                 ecx, [ebp - 0x20]

        $sequence_23 = { 6a00 ff75f8 ff5648 eb0d }
            // n = 4, score = 100
            //   6a00                 | push                0
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   ff5648               | call                dword ptr [esi + 0x48]
            //   eb0d                 | jmp                 0xf

    condition:
        7 of them and filesize < 8224768
}