rule win_polyglotduke_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.polyglotduke."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.polyglotduke"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4889442428 33d2 897dc0 4c89642420 ff15???????? 85c0 }
            // n = 6, score = 100
            //   4889442428           | dec                 eax
            //   33d2                 | lea                 edi, [esp + 0x30]
            //   897dc0               | dec                 ecx
            //   4c89642420           | mov                 ecx, esp
            //   ff15????????         |                     
            //   85c0                 | dec                 eax

        $sequence_1 = { 488d15804e0000 488bce 488905???????? ff15???????? 488bc8 ff15???????? 4c8bd8 }
            // n = 7, score = 100
            //   488d15804e0000       | dec                 ebp
            //   488bce               | cmp                 ecx, edx
            //   488905????????       |                     
            //   ff15????????         |                     
            //   488bc8               | jl                  0x1d3c
            //   ff15????????         |                     
            //   4c8bd8               | or                  ax, dx

        $sequence_2 = { eb05 be04000000 488b4c2450 ff15???????? 488b4c2458 ff15???????? }
            // n = 6, score = 100
            //   eb05                 | dec                 eax
            //   be04000000           | mov                 edi, eax
            //   488b4c2450           | dec                 eax
            //   ff15????????         |                     
            //   488b4c2458           | sub                 esp, 0x20
            //   ff15????????         |                     

        $sequence_3 = { 488bd8 4883f8ff 744d 488bc8 ff15???????? 488bcb 85c0 }
            // n = 7, score = 100
            //   488bd8               | inc                 esp
            //   4883f8ff             | mov                 edx, ebp
            //   744d                 | dec                 esp
            //   488bc8               | mov                 ebp, eax
            //   ff15????????         |                     
            //   488bcb               | test                ebp, ebp
            //   85c0                 | jle                 0x643

        $sequence_4 = { eb0e 498bd7 488bcb e8???????? 488bf8 4d85ff 7408 }
            // n = 7, score = 100
            //   eb0e                 | mov                 ecx, ebx
            //   498bd7               | dec                 eax
            //   488bcb               | mov                 ecx, edi
            //   e8????????           |                     
            //   488bf8               | inc                 ecx
            //   4d85ff               | mov                 ah, 1
            //   7408                 | lea                 edi, [eax + 1]

        $sequence_5 = { ff15???????? 4863f0 85c0 74d6 }
            // n = 4, score = 100
            //   ff15????????         |                     
            //   4863f0               | mov                 edi, dword ptr [esp + 0x48]
            //   85c0                 | dec                 ecx
            //   74d6                 | lea                 ecx, [ebp + eax*2]

        $sequence_6 = { 83f801 750e 498bd5 488bcf e8???????? 488be8 }
            // n = 6, score = 100
            //   83f801               | or                  ecx, 0xffffffff
            //   750e                 | inc                 eax
            //   498bd5               | sub                 bh, al
            //   488bcf               | xor                 eax, eax
            //   e8????????           |                     
            //   488be8               | inc                 eax

        $sequence_7 = { 33c0 eb56 8364242800 488364242000 4c8bc1 b9e9fd0000 4183c9ff }
            // n = 7, score = 100
            //   33c0                 | mov                 dword ptr [esp + 0x28], ecx
            //   eb56                 | dec                 eax
            //   8364242800           | mov                 dword ptr [esp + 0x50], esi
            //   488364242000         | mov                 word ptr [esp + 0x40], ax
            //   4c8bc1               | test                eax, eax
            //   b9e9fd0000           | je                  0x1c70
            //   4183c9ff             | dec                 eax

        $sequence_8 = { 488bcb ba01000000 e8???????? 4c897c2438 4c897c2430 448bce }
            // n = 6, score = 100
            //   488bcb               | dec                 esp
            //   ba01000000           | lea                 ebx, [esp + 0xa40]
            //   e8????????           |                     
            //   4c897c2438           | dec                 ecx
            //   4c897c2430           | mov                 ebx, dword ptr [ebx + 0x10]
            //   448bce               | dec                 ecx

        $sequence_9 = { 4889742410 57 4881ec10010000 488b05???????? 4833c4 }
            // n = 5, score = 100
            //   4889742410           | mov                 ecx, dword ptr [esp + 0x58]
            //   57                   | mov                 esi, 5
            //   4881ec10010000       | inc                 eax
            //   488b05????????       |                     
            //   4833c4               | cmp                 ch, 1

    condition:
        7 of them and filesize < 222784
}