rule win_pteranodon_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.pteranodon."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.pteranodon"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d0dc02b4300 ba1b000000 e9???????? a900000080 7517 ebd4 a9ffff0f00 }
            // n = 7, score = 100
            //   8d0dc02b4300         | lea                 ecx, [0x432bc0]
            //   ba1b000000           | mov                 edx, 0x1b
            //   e9????????           |                     
            //   a900000080           | test                eax, 0x80000000
            //   7517                 | jne                 0x19
            //   ebd4                 | jmp                 0xffffffd6
            //   a9ffff0f00           | test                eax, 0xfffff

        $sequence_1 = { 56 8b0485b8690310 33db 8b7508 57 }
            // n = 5, score = 100
            //   56                   | push                esi
            //   8b0485b8690310       | mov                 eax, dword ptr [eax*4 + 0x100369b8]
            //   33db                 | xor                 ebx, ebx
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   57                   | push                edi

        $sequence_2 = { c1e002 50 8b85a4f8ffff 0fb70485fcef0210 8d0485f8e60210 50 }
            // n = 6, score = 100
            //   c1e002               | shl                 eax, 2
            //   50                   | push                eax
            //   8b85a4f8ffff         | mov                 eax, dword ptr [ebp - 0x75c]
            //   0fb70485fcef0210     | movzx               eax, word ptr [eax*4 + 0x1002effc]
            //   8d0485f8e60210       | lea                 eax, [eax*4 + 0x1002e6f8]
            //   50                   | push                eax

        $sequence_3 = { 8d75c0 8d0417 0f4375c0 8945d0 8d0416 }
            // n = 5, score = 100
            //   8d75c0               | lea                 esi, [ebp - 0x40]
            //   8d0417               | lea                 eax, [edi + edx]
            //   0f4375c0             | cmovae              esi, dword ptr [ebp - 0x40]
            //   8945d0               | mov                 dword ptr [ebp - 0x30], eax
            //   8d0416               | lea                 eax, [esi + edx]

        $sequence_4 = { 50 46 e8???????? 83c40c 8d85c8faffff }
            // n = 5, score = 100
            //   50                   | push                eax
            //   46                   | inc                 esi
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8d85c8faffff         | lea                 eax, [ebp - 0x538]

        $sequence_5 = { 50 c745dc9c090310 e8???????? 8b75ec 8bce 8935???????? }
            // n = 6, score = 100
            //   50                   | push                eax
            //   c745dc9c090310       | mov                 dword ptr [ebp - 0x24], 0x1003099c
            //   e8????????           |                     
            //   8b75ec               | mov                 esi, dword ptr [ebp - 0x14]
            //   8bce                 | mov                 ecx, esi
            //   8935????????         |                     

        $sequence_6 = { ff15???????? 6a00 56 6a00 ff15???????? 6a00 ffb588dbffff }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   6a00                 | push                0
            //   56                   | push                esi
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   6a00                 | push                0
            //   ffb588dbffff         | push                dword ptr [ebp - 0x2478]

        $sequence_7 = { e8???????? 8bb55cfeffff 83c418 03d8 13fa eb0c 039d88feffff }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8bb55cfeffff         | mov                 esi, dword ptr [ebp - 0x1a4]
            //   83c418               | add                 esp, 0x18
            //   03d8                 | add                 ebx, eax
            //   13fa                 | adc                 edi, edx
            //   eb0c                 | jmp                 0xe
            //   039d88feffff         | add                 ebx, dword ptr [ebp - 0x178]

        $sequence_8 = { 83e03f 6bc838 8b0495e0874300 8b440818 83f8ff }
            // n = 5, score = 100
            //   83e03f               | and                 eax, 0x3f
            //   6bc838               | imul                ecx, eax, 0x38
            //   8b0495e0874300       | mov                 eax, dword ptr [edx*4 + 0x4387e0]
            //   8b440818             | mov                 eax, dword ptr [eax + ecx + 0x18]
            //   83f8ff               | cmp                 eax, -1

        $sequence_9 = { 8bd8 e8???????? 8bf8 c645fc01 b883de1b43 }
            // n = 5, score = 100
            //   8bd8                 | mov                 ebx, eax
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   c645fc01             | mov                 byte ptr [ebp - 4], 1
            //   b883de1b43           | mov                 eax, 0x431bde83

        $sequence_10 = { 56 57 8d3c85d8844300 8b07 83ceff 3bc6 }
            // n = 6, score = 100
            //   56                   | push                esi
            //   57                   | push                edi
            //   8d3c85d8844300       | lea                 edi, [eax*4 + 0x4384d8]
            //   8b07                 | mov                 eax, dword ptr [edi]
            //   83ceff               | or                  esi, 0xffffffff
            //   3bc6                 | cmp                 eax, esi

        $sequence_11 = { 7213 40 8d8df0f8ffff 50 ffb5f0f8ffff e8???????? }
            // n = 6, score = 100
            //   7213                 | jb                  0x15
            //   40                   | inc                 eax
            //   8d8df0f8ffff         | lea                 ecx, [ebp - 0x710]
            //   50                   | push                eax
            //   ffb5f0f8ffff         | push                dword ptr [ebp - 0x710]
            //   e8????????           |                     

        $sequence_12 = { e8???????? 83c404 8b45b8 33db }
            // n = 4, score = 100
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8b45b8               | mov                 eax, dword ptr [ebp - 0x48]
            //   33db                 | xor                 ebx, ebx

        $sequence_13 = { 8b55f0 897734 83c714 c74304???????? 8d7028 c6434c00 }
            // n = 6, score = 100
            //   8b55f0               | mov                 edx, dword ptr [ebp - 0x10]
            //   897734               | mov                 dword ptr [edi + 0x34], esi
            //   83c714               | add                 edi, 0x14
            //   c74304????????       |                     
            //   8d7028               | lea                 esi, [eax + 0x28]
            //   c6434c00             | mov                 byte ptr [ebx + 0x4c], 0

        $sequence_14 = { 8bb590dbffff 56 50 8b8584dbffff 83c004 50 }
            // n = 6, score = 100
            //   8bb590dbffff         | mov                 esi, dword ptr [ebp - 0x2470]
            //   56                   | push                esi
            //   50                   | push                eax
            //   8b8584dbffff         | mov                 eax, dword ptr [ebp - 0x247c]
            //   83c004               | add                 eax, 4
            //   50                   | push                eax

        $sequence_15 = { f6c201 742b 8d55e8 2bd6 881c32 8d7601 }
            // n = 6, score = 100
            //   f6c201               | test                dl, 1
            //   742b                 | je                  0x2d
            //   8d55e8               | lea                 edx, [ebp - 0x18]
            //   2bd6                 | sub                 edx, esi
            //   881c32               | mov                 byte ptr [edx + esi], bl
            //   8d7601               | lea                 esi, [esi + 1]

    condition:
        7 of them and filesize < 499712
}