rule win_punkey_pos_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.punkey_pos."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.punkey_pos"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 57 8b7d0c f7c600000040 741d }
            // n = 4, score = 200
            //   57                   | push                edi
            //   8b7d0c               | mov                 edi, dword ptr [ebp + 0xc]
            //   f7c600000040         | test                esi, 0x40000000
            //   741d                 | je                  0x1f

        $sequence_1 = { 85c0 740e 56 57 68e7070000 50 }
            // n = 6, score = 200
            //   85c0                 | test                eax, eax
            //   740e                 | je                  0x10
            //   56                   | push                esi
            //   57                   | push                edi
            //   68e7070000           | push                0x7e7
            //   50                   | push                eax

        $sequence_2 = { a3???????? ff15???????? 8bf0 85f6 7508 5f 33c0 }
            // n = 7, score = 200
            //   a3????????           |                     
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi
            //   7508                 | jne                 0xa
            //   5f                   | pop                 edi
            //   33c0                 | xor                 eax, eax

        $sequence_3 = { 56 57 756b 8b4508 }
            // n = 4, score = 200
            //   56                   | push                esi
            //   57                   | push                edi
            //   756b                 | jne                 0x6d
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_4 = { 56 ffd7 a3???????? 85c0 74ae 5f b801000000 }
            // n = 7, score = 200
            //   56                   | push                esi
            //   ffd7                 | call                edi
            //   a3????????           |                     
            //   85c0                 | test                eax, eax
            //   74ae                 | je                  0xffffffb0
            //   5f                   | pop                 edi
            //   b801000000           | mov                 eax, 1

        $sequence_5 = { 85c0 740e 56 57 68e7070000 }
            // n = 5, score = 200
            //   85c0                 | test                eax, eax
            //   740e                 | je                  0x10
            //   56                   | push                esi
            //   57                   | push                edi
            //   68e7070000           | push                0x7e7

        $sequence_6 = { a3???????? 85c0 74ae 5f b801000000 }
            // n = 5, score = 200
            //   a3????????           |                     
            //   85c0                 | test                eax, eax
            //   74ae                 | je                  0xffffffb0
            //   5f                   | pop                 edi
            //   b801000000           | mov                 eax, 1

        $sequence_7 = { 55 8bec 837d0c01 56 57 756b }
            // n = 6, score = 200
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   837d0c01             | cmp                 dword ptr [ebp + 0xc], 1
            //   56                   | push                esi
            //   57                   | push                edi
            //   756b                 | jne                 0x6d

        $sequence_8 = { ffd7 a3???????? 85c0 74d0 }
            // n = 4, score = 200
            //   ffd7                 | call                edi
            //   a3????????           |                     
            //   85c0                 | test                eax, eax
            //   74d0                 | je                  0xffffffd2

        $sequence_9 = { 5d c20c00 75e5 56 8b7510 }
            // n = 5, score = 200
            //   5d                   | pop                 ebp
            //   c20c00               | ret                 0xc
            //   75e5                 | jne                 0xffffffe7
            //   56                   | push                esi
            //   8b7510               | mov                 esi, dword ptr [ebp + 0x10]

    condition:
        7 of them and filesize < 499712
}