rule win_rektloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.rektloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rektloader"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0fbe02 8b4d24 2bc8 894d24 0fb655af 52 6a01 }
            // n = 7, score = 100
            //   0fbe02               | movsx               eax, byte ptr [edx]
            //   8b4d24               | mov                 ecx, dword ptr [ebp + 0x24]
            //   2bc8                 | sub                 ecx, eax
            //   894d24               | mov                 dword ptr [ebp + 0x24], ecx
            //   0fb655af             | movzx               edx, byte ptr [ebp - 0x51]
            //   52                   | push                edx
            //   6a01                 | push                1

        $sequence_1 = { c1f906 8b5508 83e23f 6bc238 03048d08ab5600 b901000000 d1e1 }
            // n = 7, score = 100
            //   c1f906               | sar                 ecx, 6
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   83e23f               | and                 edx, 0x3f
            //   6bc238               | imul                eax, edx, 0x38
            //   03048d08ab5600       | add                 eax, dword ptr [ecx*4 + 0x56ab08]
            //   b901000000           | mov                 ecx, 1
            //   d1e1                 | shl                 ecx, 1

        $sequence_2 = { 89459c c745fcffffffff 8d4d84 e8???????? 6a30 8b4d9c e8???????? }
            // n = 7, score = 100
            //   89459c               | mov                 dword ptr [ebp - 0x64], eax
            //   c745fcffffffff       | mov                 dword ptr [ebp - 4], 0xffffffff
            //   8d4d84               | lea                 ecx, [ebp - 0x7c]
            //   e8????????           |                     
            //   6a30                 | push                0x30
            //   8b4d9c               | mov                 ecx, dword ptr [ebp - 0x64]
            //   e8????????           |                     

        $sequence_3 = { 33c0 8845ef 0fb64def 51 8b5508 52 }
            // n = 6, score = 100
            //   33c0                 | xor                 eax, eax
            //   8845ef               | mov                 byte ptr [ebp - 0x11], al
            //   0fb64def             | movzx               ecx, byte ptr [ebp - 0x11]
            //   51                   | push                ecx
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   52                   | push                edx

        $sequence_4 = { 854a00 40 854a00 40 854a00 2f }
            // n = 6, score = 100
            //   854a00               | test                dword ptr [edx], ecx
            //   40                   | inc                 eax
            //   854a00               | test                dword ptr [edx], ecx
            //   40                   | inc                 eax
            //   854a00               | test                dword ptr [edx], ecx
            //   2f                   | das                 

        $sequence_5 = { 3b10 7427 8b4508 81784ca0725600 741b 8b4d08 8b514c }
            // n = 7, score = 100
            //   3b10                 | cmp                 edx, dword ptr [eax]
            //   7427                 | je                  0x29
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   81784ca0725600       | cmp                 dword ptr [eax + 0x4c], 0x5672a0
            //   741b                 | je                  0x1d
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8b514c               | mov                 edx, dword ptr [ecx + 0x4c]

        $sequence_6 = { e8???????? 83c418 83f801 7501 cc 6a00 683e020000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   83f801               | cmp                 eax, 1
            //   7501                 | jne                 3
            //   cc                   | int3                
            //   6a00                 | push                0
            //   683e020000           | push                0x23e

        $sequence_7 = { 837d1000 740b 8b4d10 898dc47fffff eb0a c785c47fffff3cc05400 8b95c47fffff }
            // n = 7, score = 100
            //   837d1000             | cmp                 dword ptr [ebp + 0x10], 0
            //   740b                 | je                  0xd
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]
            //   898dc47fffff         | mov                 dword ptr [ebp - 0x803c], ecx
            //   eb0a                 | jmp                 0xc
            //   c785c47fffff3cc05400     | mov    dword ptr [ebp - 0x803c], 0x54c03c
            //   8b95c47fffff         | mov                 edx, dword ptr [ebp - 0x803c]

        $sequence_8 = { 51 8b55cc 52 e8???????? 83c404 50 8b45d0 }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   8b55cc               | mov                 edx, dword ptr [ebp - 0x34]
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   50                   | push                eax
            //   8b45d0               | mov                 eax, dword ptr [ebp - 0x30]

        $sequence_9 = { 83c408 8945f4 837df400 7515 660fb645ff 8b4d08 668901 }
            // n = 7, score = 100
            //   83c408               | add                 esp, 8
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   837df400             | cmp                 dword ptr [ebp - 0xc], 0
            //   7515                 | jne                 0x17
            //   660fb645ff           | movzx               ax, byte ptr [ebp - 1]
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   668901               | mov                 word ptr [ecx], ax

    condition:
        7 of them and filesize < 3080192
}