rule win_remcos_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.remcos."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.remcos"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 50 ff15???????? 8d45f0 33f6 50 }
            // n = 6, score = 2000
            //   ff15????????         |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   33f6                 | xor                 esi, esi
            //   50                   | push                eax

        $sequence_1 = { ff15???????? 85c0 7410 6a00 ff35???????? }
            // n = 5, score = 2000
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7410                 | je                  0x12
            //   6a00                 | push                0
            //   ff35????????         |                     

        $sequence_2 = { 50 ff15???????? 8d45f0 33f6 50 }
            // n = 5, score = 2000
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   33f6                 | xor                 esi, esi
            //   50                   | push                eax

        $sequence_3 = { ff35???????? ff15???????? 85c0 7410 6a00 }
            // n = 5, score = 2000
            //   ff35????????         |                     
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7410                 | je                  0x12
            //   6a00                 | push                0

        $sequence_4 = { 8d45f8 50 ff15???????? ff7508 }
            // n = 4, score = 2000
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   ff7508               | push                dword ptr [ebp + 8]

        $sequence_5 = { 6a09 ff35???????? ff15???????? ff35???????? ff15???????? }
            // n = 5, score = 2000
            //   6a09                 | push                9
            //   ff35????????         |                     
            //   ff15????????         |                     
            //   ff35????????         |                     
            //   ff15????????         |                     

        $sequence_6 = { 7508 ff15???????? 33c0 5f }
            // n = 4, score = 2000
            //   7508                 | jne                 0xa
            //   ff15????????         |                     
            //   33c0                 | xor                 eax, eax
            //   5f                   | pop                 edi

        $sequence_7 = { 50 ff15???????? 8d45f0 33f6 }
            // n = 4, score = 2000
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   33f6                 | xor                 esi, esi

        $sequence_8 = { ab ab e8???????? 52 50 }
            // n = 5, score = 2000
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   e8????????           |                     
            //   52                   | push                edx
            //   50                   | push                eax

        $sequence_9 = { 50 6a28 ff15???????? 50 ff15???????? 8d45f0 33f6 }
            // n = 7, score = 2000
            //   50                   | push                eax
            //   6a28                 | push                0x28
            //   ff15????????         |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   33f6                 | xor                 esi, esi

    condition:
        7 of them and filesize < 1054720
}