rule win_rokku_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.rokku."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rokku"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 750b 3944242c 7523 b805000080 3d06000080 7517 57 }
            // n = 7, score = 200
            //   750b                 | jne                 0xd
            //   3944242c             | cmp                 dword ptr [esp + 0x2c], eax
            //   7523                 | jne                 0x25
            //   b805000080           | mov                 eax, 0x80000005
            //   3d06000080           | cmp                 eax, 0x80000006
            //   7517                 | jne                 0x19
            //   57                   | push                edi

        $sequence_1 = { 66c745fd5352 885dff 80441de5fa 43 83fb1a 72f5 }
            // n = 6, score = 200
            //   66c745fd5352         | mov                 word ptr [ebp - 3], 0x5253
            //   885dff               | mov                 byte ptr [ebp - 1], bl
            //   80441de5fa           | add                 byte ptr [ebp + ebx - 0x1b], 0xfa
            //   43                   | inc                 ebx
            //   83fb1a               | cmp                 ebx, 0x1a
            //   72f5                 | jb                  0xfffffff7

        $sequence_2 = { 8bce e8???????? 0f2805???????? 8bcb 0f1145cf }
            // n = 5, score = 200
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   0f2805????????       |                     
            //   8bcb                 | mov                 ecx, ebx
            //   0f1145cf             | movups              xmmword ptr [ebp - 0x31], xmm0

        $sequence_3 = { 01442414 13ea 8b542414 8bca 81c100000002 83d500 }
            // n = 6, score = 200
            //   01442414             | add                 dword ptr [esp + 0x14], eax
            //   13ea                 | adc                 ebp, edx
            //   8b542414             | mov                 edx, dword ptr [esp + 0x14]
            //   8bca                 | mov                 ecx, edx
            //   81c100000002         | add                 ecx, 0x2000000
            //   83d500               | adc                 ebp, 0

        $sequence_4 = { 8bc7 894a0c 8b4c241c 0fa4c11a 8b4c2410 c1e01a 2bc8 }
            // n = 7, score = 200
            //   8bc7                 | mov                 eax, edi
            //   894a0c               | mov                 dword ptr [edx + 0xc], ecx
            //   8b4c241c             | mov                 ecx, dword ptr [esp + 0x1c]
            //   0fa4c11a             | shld                ecx, eax, 0x1a
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]
            //   c1e01a               | shl                 eax, 0x1a
            //   2bc8                 | sub                 ecx, eax

        $sequence_5 = { 13da f76c2460 03f8 8b44242c }
            // n = 4, score = 200
            //   13da                 | adc                 ebx, edx
            //   f76c2460             | imul                dword ptr [esp + 0x60]
            //   03f8                 | add                 edi, eax
            //   8b44242c             | mov                 eax, dword ptr [esp + 0x2c]

        $sequence_6 = { 8d84244c080000 53 50 e8???????? be00080000 8d442454 56 }
            // n = 7, score = 200
            //   8d84244c080000       | lea                 eax, [esp + 0x84c]
            //   53                   | push                ebx
            //   50                   | push                eax
            //   e8????????           |                     
            //   be00080000           | mov                 esi, 0x800
            //   8d442454             | lea                 eax, [esp + 0x54]
            //   56                   | push                esi

        $sequence_7 = { 75f7 c60607 46 83ed01 75f7 6a08 8d442434 }
            // n = 7, score = 200
            //   75f7                 | jne                 0xfffffff9
            //   c60607               | mov                 byte ptr [esi], 7
            //   46                   | inc                 esi
            //   83ed01               | sub                 ebp, 1
            //   75f7                 | jne                 0xfffffff9
            //   6a08                 | push                8
            //   8d442434             | lea                 eax, [esp + 0x34]

        $sequence_8 = { c645ff00 885dfe 8d55e0 33db c645fd27 50 885dff }
            // n = 7, score = 200
            //   c645ff00             | mov                 byte ptr [ebp - 1], 0
            //   885dfe               | mov                 byte ptr [ebp - 2], bl
            //   8d55e0               | lea                 edx, [ebp - 0x20]
            //   33db                 | xor                 ebx, ebx
            //   c645fd27             | mov                 byte ptr [ebp - 3], 0x27
            //   50                   | push                eax
            //   885dff               | mov                 byte ptr [ebp - 1], bl

        $sequence_9 = { e8???????? b935010000 b8???????? 03c1 51 50 e8???????? }
            // n = 7, score = 200
            //   e8????????           |                     
            //   b935010000           | mov                 ecx, 0x135
            //   b8????????           |                     
            //   03c1                 | add                 eax, ecx
            //   51                   | push                ecx
            //   50                   | push                eax
            //   e8????????           |                     

    condition:
        7 of them and filesize < 548864
}