rule win_sasfis_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.sasfis."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sasfis"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 9c 8a4d02 9c 83ed02 }
            // n = 4, score = 100
            //   9c                   | pushfd              
            //   8a4d02               | mov                 cl, byte ptr [ebp + 2]
            //   9c                   | pushfd              
            //   83ed02               | sub                 ebp, 2

        $sequence_1 = { 9c ff3424 9c 9c 8f442440 66c70424ae36 ff742440 }
            // n = 7, score = 100
            //   9c                   | pushfd              
            //   ff3424               | push                dword ptr [esp]
            //   9c                   | pushfd              
            //   9c                   | pushfd              
            //   8f442440             | pop                 dword ptr [esp + 0x40]
            //   66c70424ae36         | mov                 word ptr [esp], 0x36ae
            //   ff742440             | push                dword ptr [esp + 0x40]

        $sequence_2 = { 016e05 036e20 43 7465 47 d220 04b7 }
            // n = 7, score = 100
            //   016e05               | add                 dword ptr [esi + 5], ebp
            //   036e20               | add                 ebp, dword ptr [esi + 0x20]
            //   43                   | inc                 ebx
            //   7465                 | je                  0x67
            //   47                   | inc                 edi
            //   d220                 | shl                 byte ptr [eax], cl
            //   04b7                 | add                 al, 0xb7

        $sequence_3 = { 0fc1fd 8d6c2424 ff742408 80fd7b 81cf73a6238d 81ec98000000 }
            // n = 6, score = 100
            //   0fc1fd               | xadd                ebp, edi
            //   8d6c2424             | lea                 ebp, [esp + 0x24]
            //   ff742408             | push                dword ptr [esp + 8]
            //   80fd7b               | cmp                 ch, 0x7b
            //   81cf73a6238d         | or                  edi, 0x8d23a673
            //   81ec98000000         | sub                 esp, 0x98

        $sequence_4 = { 8d881c2d4e65 660fbecb 57 660fc9 0f92c5 0fb6c9 53 }
            // n = 7, score = 100
            //   8d881c2d4e65         | lea                 ecx, [eax + 0x654e2d1c]
            //   660fbecb             | movsx               cx, bl
            //   57                   | push                edi
            //   660fc9               | bswap               cx
            //   0f92c5               | setb                ch
            //   0fb6c9               | movzx               ecx, cl
            //   53                   | push                ebx

        $sequence_5 = { 66ffc1 f6d0 660fbec9 8a46ff 9c 66ffc9 }
            // n = 6, score = 100
            //   66ffc1               | inc                 cx
            //   f6d0                 | not                 al
            //   660fbec9             | movsx               cx, cl
            //   8a46ff               | mov                 al, byte ptr [esi - 1]
            //   9c                   | pushfd              
            //   66ffc9               | dec                 cx

        $sequence_6 = { 9c 66ffc9 8a2c24 0fb6c0 }
            // n = 4, score = 100
            //   9c                   | pushfd              
            //   66ffc9               | dec                 cx
            //   8a2c24               | mov                 ch, byte ptr [esp]
            //   0fb6c0               | movzx               eax, al

        $sequence_7 = { 660fbec2 660fb6c0 8b4500 e8???????? 661584f0 fec0 27 }
            // n = 7, score = 100
            //   660fbec2             | movsx               ax, dl
            //   660fb6c0             | movzx               ax, al
            //   8b4500               | mov                 eax, dword ptr [ebp]
            //   e8????????           |                     
            //   661584f0             | adc                 ax, 0xf084
            //   fec0                 | inc                 al
            //   27                   | daa                 

        $sequence_8 = { 6c 785f 007d3f cf }
            // n = 4, score = 100
            //   6c                   | insb                byte ptr es:[edi], dx
            //   785f                 | js                  0x61
            //   007d3f               | add                 byte ptr [ebp + 0x3f], bh
            //   cf                   | iretd               

        $sequence_9 = { 3d0d351d11 0531250968 b3af 7c00 e8???????? }
            // n = 5, score = 100
            //   3d0d351d11           | cmp                 eax, 0x111d350d
            //   0531250968           | add                 eax, 0x68092531
            //   b3af                 | mov                 bl, 0xaf
            //   7c00                 | jl                  2
            //   e8????????           |                     

    condition:
        7 of them and filesize < 8060928
}