rule win_sinowal_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.sinowal."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sinowal"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? c78568fdffff18000000 c7856cfdffff00000000 c78574fdffff40000000 8d9554fdffff }
            // n = 5, score = 200
            //   ff15????????         |                     
            //   c78568fdffff18000000     | mov    dword ptr [ebp - 0x298], 0x18
            //   c7856cfdffff00000000     | mov    dword ptr [ebp - 0x294], 0
            //   c78574fdffff40000000     | mov    dword ptr [ebp - 0x28c], 0x40
            //   8d9554fdffff         | lea                 edx, [ebp - 0x2ac]

        $sequence_1 = { 6800100000 8b4dfc 83c108 51 }
            // n = 4, score = 200
            //   6800100000           | push                0x1000
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   83c108               | add                 ecx, 8
            //   51                   | push                ecx

        $sequence_2 = { 8a4dfb 884c5001 ebbf 5e 8be5 }
            // n = 5, score = 200
            //   8a4dfb               | mov                 cl, byte ptr [ebp - 5]
            //   884c5001             | mov                 byte ptr [eax + edx*2 + 1], cl
            //   ebbf                 | jmp                 0xffffffc1
            //   5e                   | pop                 esi
            //   8be5                 | mov                 esp, ebp

        $sequence_3 = { 83c214 899564fdffff c78580fdffff14000000 8b8548fdffff 83c036 }
            // n = 5, score = 200
            //   83c214               | add                 edx, 0x14
            //   899564fdffff         | mov                 dword ptr [ebp - 0x29c], edx
            //   c78580fdffff14000000     | mov    dword ptr [ebp - 0x280], 0x14
            //   8b8548fdffff         | mov                 eax, dword ptr [ebp - 0x2b8]
            //   83c036               | add                 eax, 0x36

        $sequence_4 = { ff15???????? 8945fc 837dfc00 7521 68???????? 6a00 6a00 }
            // n = 7, score = 200
            //   ff15????????         |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   837dfc00             | cmp                 dword ptr [ebp - 4], 0
            //   7521                 | jne                 0x23
            //   68????????           |                     
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_5 = { 7514 8b4510 50 8b4df8 51 }
            // n = 5, score = 200
            //   7514                 | jne                 0x16
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   50                   | push                eax
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   51                   | push                ecx

        $sequence_6 = { ff15???????? 85c0 7508 8b45f0 e9???????? }
            // n = 5, score = 200
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7508                 | jne                 0xa
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   e9????????           |                     

        $sequence_7 = { c745fc05400080 c745ec00000000 833d????????00 751a e8???????? }
            // n = 5, score = 200
            //   c745fc05400080       | mov                 dword ptr [ebp - 4], 0x80004005
            //   c745ec00000000       | mov                 dword ptr [ebp - 0x14], 0
            //   833d????????00       |                     
            //   751a                 | jne                 0x1c
            //   e8????????           |                     

        $sequence_8 = { 8945e4 837de400 7502 eb0b 68e8030000 }
            // n = 5, score = 200
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   837de400             | cmp                 dword ptr [ebp - 0x1c], 0
            //   7502                 | jne                 4
            //   eb0b                 | jmp                 0xd
            //   68e8030000           | push                0x3e8

        $sequence_9 = { 7418 8b55e8 3b55f8 7510 8b45ec 3b45fc 7508 }
            // n = 7, score = 200
            //   7418                 | je                  0x1a
            //   8b55e8               | mov                 edx, dword ptr [ebp - 0x18]
            //   3b55f8               | cmp                 edx, dword ptr [ebp - 8]
            //   7510                 | jne                 0x12
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   3b45fc               | cmp                 eax, dword ptr [ebp - 4]
            //   7508                 | jne                 0xa

    condition:
        7 of them and filesize < 73728
}