rule win_smac_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.smac."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.smac"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c002 0fb708 6685c9 75df 0fafd6 8bc2 3bc3 }
            // n = 7, score = 200
            //   83c002               | add                 eax, 2
            //   0fb708               | movzx               ecx, word ptr [eax]
            //   6685c9               | test                cx, cx
            //   75df                 | jne                 0xffffffe1
            //   0fafd6               | imul                edx, esi
            //   8bc2                 | mov                 eax, edx
            //   3bc3                 | cmp                 eax, ebx

        $sequence_1 = { e8???????? 57 e8???????? 59 57 8bf8 8bc6 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   57                   | push                edi
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   57                   | push                edi
            //   8bf8                 | mov                 edi, eax
            //   8bc6                 | mov                 eax, esi

        $sequence_2 = { 57 57 6a10 57 57 57 8d8580f1ffff }
            // n = 7, score = 200
            //   57                   | push                edi
            //   57                   | push                edi
            //   6a10                 | push                0x10
            //   57                   | push                edi
            //   57                   | push                edi
            //   57                   | push                edi
            //   8d8580f1ffff         | lea                 eax, [ebp - 0xe80]

        $sequence_3 = { 83c002 50 57 53 e8???????? 83c410 57 }
            // n = 7, score = 200
            //   83c002               | add                 eax, 2
            //   50                   | push                eax
            //   57                   | push                edi
            //   53                   | push                ebx
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   57                   | push                edi

        $sequence_4 = { a840 7411 a900040000 740a 6a09 58 }
            // n = 6, score = 200
            //   a840                 | test                al, 0x40
            //   7411                 | je                  0x13
            //   a900040000           | test                eax, 0x400
            //   740a                 | je                  0xc
            //   6a09                 | push                9
            //   58                   | pop                 eax

        $sequence_5 = { 50 6a00 53 e8???????? 83c410 57 }
            // n = 6, score = 200
            //   50                   | push                eax
            //   6a00                 | push                0
            //   53                   | push                ebx
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   57                   | push                edi

        $sequence_6 = { 48 0f84a6010000 48 741f 6a01 }
            // n = 5, score = 200
            //   48                   | dec                 eax
            //   0f84a6010000         | je                  0x1ac
            //   48                   | dec                 eax
            //   741f                 | je                  0x21
            //   6a01                 | push                1

        $sequence_7 = { 33c0 668975b4 66894db8 668955ba 668945bc }
            // n = 5, score = 200
            //   33c0                 | xor                 eax, eax
            //   668975b4             | mov                 word ptr [ebp - 0x4c], si
            //   66894db8             | mov                 word ptr [ebp - 0x48], cx
            //   668955ba             | mov                 word ptr [ebp - 0x46], dx
            //   668945bc             | mov                 word ptr [ebp - 0x44], ax

        $sequence_8 = { 7320 6a01 33ff 8db514f1ffff e8???????? 6a01 8d750c }
            // n = 7, score = 200
            //   7320                 | jae                 0x22
            //   6a01                 | push                1
            //   33ff                 | xor                 edi, edi
            //   8db514f1ffff         | lea                 esi, [ebp - 0xeec]
            //   e8????????           |                     
            //   6a01                 | push                1
            //   8d750c               | lea                 esi, [ebp + 0xc]

        $sequence_9 = { 8be5 5d c3 55 8bec 83e4f8 81eccc060000 }
            // n = 7, score = 200
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83e4f8               | and                 esp, 0xfffffff8
            //   81eccc060000         | sub                 esp, 0x6cc

    condition:
        7 of them and filesize < 212992
}